/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.devicemanager.Tables;
import com.google.common.annotations.VisibleForTesting;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.util.MeasureUnit;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

final class SizeOnDiskTableCellRenderer
implements TableCellRenderer {
    @NotNull
    private static final LocalizedNumberFormatter GB_WHOLE_FORMATTER = (LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)Locale.ROOT).unit(MeasureUnit.GIGABYTE)).precision((Precision)Precision.fixedFraction((int)0));
    @NotNull
    private static final LocalizedNumberFormatter GB_FRACTION_FORMATTER = (LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)Locale.ROOT).unit(MeasureUnit.GIGABYTE)).precision((Precision)Precision.fixedFraction((int)1));
    @NotNull
    private static final LocalizedNumberFormatter MB_WHOLE_FORMATTER = (LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)Locale.ROOT).unit(MeasureUnit.MEGABYTE)).precision((Precision)Precision.fixedFraction((int)0));
    @NotNull
    private static final LocalizedNumberFormatter MB_FRACTION_FORMATTER = (LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)Locale.ROOT).unit(MeasureUnit.MEGABYTE)).precision((Precision)Precision.fixedFraction((int)1));
    private final JLabel myLabel = new JBLabel();

    SizeOnDiskTableCellRenderer() {
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
        this.myLabel.setBackground(Tables.getBackground(table2, selected));
        this.myLabel.setBorder(Tables.getBorder(selected, focused));
        this.myLabel.setForeground(Tables.getForeground(table2, selected));
        this.myLabel.setText(SizeOnDiskTableCellRenderer.toString((Long)value2));
        return this.myLabel;
    }

    @VisibleForTesting
    @NotNull
    static String toString(long sizeOnDisk) {
        double sizeOnDiskAsDouble;
        LocalizedNumberFormatter formatter = sizeOnDisk >= Storage.Unit.GiB.getNumberOfBytes() ? ((sizeOnDiskAsDouble = (double)sizeOnDisk / (double)Storage.Unit.GiB.getNumberOfBytes()) > 9.94 ? GB_WHOLE_FORMATTER : GB_FRACTION_FORMATTER) : ((sizeOnDiskAsDouble = (double)sizeOnDisk / (double)Storage.Unit.MiB.getNumberOfBytes()) > 9.94 ? MB_WHOLE_FORMATTER : MB_FRACTION_FORMATTER);
        return formatter.format(sizeOnDiskAsDouble).toString();
    }
}

