/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanager.IconButtonTableCellEditor;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePanel;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTable;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTableModel;
import com.google.common.util.concurrent.Futures;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.icons.AllIcons;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.util.concurrent.Executor;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

final class EditButtonTableCellEditor
extends IconButtonTableCellEditor {
    private VirtualDevice myDevice;

    EditButtonTableCellEditor(@NotNull VirtualDevicePanel panel2) {
        super(VirtualDeviceTableModel.EditValue.INSTANCE, AllIcons.Actions.Edit, "Edit this AVD");
        this.myButton.addActionListener(actionEvent -> {
            DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.VIRTUAL_EDIT_ACTION).build();
            DeviceManagerUsageTracker.log(deviceManagerEvent);
            VirtualDeviceTable table2 = panel2.getTable();
            if (AvdWizardUtils.createAvdWizard((Component)((Object)table2), panel2.getProject(), this.myDevice.getAvdInfo()).showAndGet()) {
                DeviceManagerFutureCallback<Key> callback = new DeviceManagerFutureCallback<Key>(EditButtonTableCellEditor.class, table2::setSelectedDevice);
                Futures.addCallback(table2.reloadDevice(this.myDevice.getKey()), callback, (Executor)EdtExecutorService.getInstance());
            }
            this.fireEditingCanceled();
        });
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, int viewRowIndex, int viewColumnIndex) {
        super.getTableCellEditorComponent(table2, value2, selected, viewRowIndex, viewColumnIndex);
        this.myDevice = (VirtualDevice)((VirtualDeviceTable)((Object)table2)).getDeviceAt(viewRowIndex);
        return this.myButton;
    }
}

