/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.devicemanager.IconButtonTableCellEditor;
import com.android.tools.idea.devicemanager.virtualtab.DownloadValue;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTable;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DownloadButtonTableCellEditor
extends IconButtonTableCellEditor {
    private VirtualDevice myDevice;
    private VirtualDeviceTable myTable;

    DownloadButtonTableCellEditor(@Nullable Project project) {
        super(DownloadValue.INSTANCE, AllIcons.Actions.Download, "Download system image");
        this.myButton.addActionListener(event -> {
            String path2 = AvdManagerConnection.getRequiredSystemImagePath(this.myDevice.getAvdInfo());
            assert (path2 != null);
            ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, List.of(path2));
            if (dialog2 == null) {
                return;
            }
            if (dialog2.showAndGet()) {
                this.myTable.refreshAvds();
            }
            this.fireEditingCanceled();
        });
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, int viewRowIndex, int viewColumnIndex) {
        super.getTableCellEditorComponent(table2, value2, selected, viewRowIndex, viewColumnIndex);
        this.myTable = (VirtualDeviceTable)((Object)table2);
        this.myDevice = (VirtualDevice)this.myTable.getDeviceAt(viewRowIndex);
        return this.myButton;
    }
}

