/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePopUpMenuButtonTableCellEditor;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class DeleteItem
extends JBMenuItem {
    DeleteItem(@NotNull VirtualDevicePopUpMenuButtonTableCellEditor editor) {
        this(editor, DeleteItem::showCannotDeleteRunningAvdDialog, DeleteItem::showConfirmDeleteDialog);
    }

    @VisibleForTesting
    DeleteItem(@NotNull VirtualDevicePopUpMenuButtonTableCellEditor editor, @NotNull @NotNull Consumer<@NotNull Component> showCannotDeleteRunningAvdDialog, @NotNull @NotNull BiPredicate<@NotNull Object, @NotNull Component> showConfirmDeleteDialog) {
        super("Delete");
        this.setToolTipText("Delete this AVD");
        this.addActionListener(actionEvent -> {
            DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.VIRTUAL_DELETE_ACTION).build();
            DeviceManagerUsageTracker.log(deviceManagerEvent);
            VirtualDevice device2 = editor.getDevice();
            VirtualDeviceTable table2 = editor.getPanel().getTable();
            if (device2.isOnline()) {
                showCannotDeleteRunningAvdDialog.accept((Component)((Object)table2));
                return;
            }
            if (!showConfirmDeleteDialog.test(device2, (Component)((Object)table2))) {
                return;
            }
            DeviceManagerFutureCallback<Boolean> callback = new DeviceManagerFutureCallback<Boolean>(DeleteItem.class, deletionSuccessful -> {
                if (!deletionSuccessful.booleanValue()) {
                    table2.refreshAvds();
                    if (DeleteItem.showUnsuccessfulDeletionDialog((Component)((Object)table2)) == 0) {
                        RevealFileAction.openDirectory((Path)device2.getAvdInfo().getDataFolderPath());
                    }
                }
            });
            Futures.addCallback(table2.getModel().remove(device2), callback, (Executor)EdtExecutorService.getInstance());
        });
    }

    private static void showCannotDeleteRunningAvdDialog(@NotNull Component component2) {
        Messages.showErrorDialog((Component)component2, (String)"The selected AVD is currently running in the emulator. Please exit the emulator instance and try deleting again.", (String)"Cannot Delete a Running AVD");
    }

    private static boolean showConfirmDeleteDialog(@NotNull Object device2, @NotNull Component component2) {
        return MessageDialogBuilder.yesNo((String)"Confirm Deletion", (String)("Do you really want to delete " + device2 + "?")).ask(component2);
    }

    private static int showUnsuccessfulDeletionDialog(@NotNull Component component2) {
        return Messages.showOkCancelDialog((Component)component2, (String)"There may be additional files remaining in the AVD directory. Open the directory, manually delete the files, and refresh AVD list.", (String)"Could Not Delete All AVD Files", (String)"Open Directory", (String)"OK", (Icon)Messages.getInformationIcon());
    }
}

