/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.device.Resolution;
import com.android.tools.idea.devicemanager.AdbShellCommandExecutor;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceManagerAndroidDebugBridge;
import com.android.tools.idea.devicemanager.StorageDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AsyncVirtualDeviceDetailsBuilder {
    @Nullable
    private final Project myProject;
    @NotNull
    private final VirtualDevice myDevice;
    @NotNull
    private final DeviceManagerAndroidDebugBridge myBridge;
    @NotNull
    private final AdbShellCommandExecutor myAdbShellCommandExecutor;

    AsyncVirtualDeviceDetailsBuilder(@Nullable Project project, @NotNull VirtualDevice device2) {
        this(project, device2, new DeviceManagerAndroidDebugBridge(), new AdbShellCommandExecutor());
    }

    @VisibleForTesting
    AsyncVirtualDeviceDetailsBuilder(@Nullable Project project, @NotNull VirtualDevice device2, @NotNull DeviceManagerAndroidDebugBridge bridge, @NotNull AdbShellCommandExecutor adbShellCommandExecutor) {
        this.myProject = project;
        this.myDevice = device2;
        this.myBridge = bridge;
        this.myAdbShellCommandExecutor = adbShellCommandExecutor;
    }

    @NotNull
    @NotNull ListenableFuture<@NotNull Device> buildAsync() {
        return Futures.transform(this.myBridge.findDevice(this.myProject, this.myDevice.getKey()), this::build, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private Device build(@Nullable IDevice device2) {
        AvdInfo avd = this.myDevice.getAvdInfo();
        VirtualDevice.Builder builder2 = new VirtualDevice.Builder().setKey(this.myDevice.getKey()).setName(this.myDevice.getName()).setTarget(this.myDevice.getTarget()).setCpuArchitecture(this.myDevice.getCpuArchitecture()).setResolution(AsyncVirtualDeviceDetailsBuilder.getResolution(avd)).setDensity(AsyncVirtualDeviceDetailsBuilder.getProperty(avd, "hw.lcd.density").orElse(-1));
        if (device2 != null) {
            builder2.addAllAbis(device2.getAbis()).setStorageDevice(this.myAdbShellCommandExecutor.execute(device2, "df /data").flatMap(StorageDevice::newStorageDevice).orElse(null));
        }
        return builder2.setAvdInfo(avd).build();
    }

    @Nullable
    private static Resolution getResolution(@NotNull AvdInfo avd) {
        OptionalInt width = AsyncVirtualDeviceDetailsBuilder.getProperty(avd, "hw.lcd.width");
        OptionalInt height = AsyncVirtualDeviceDetailsBuilder.getProperty(avd, "hw.lcd.height");
        if (width.isEmpty() || height.isEmpty()) {
            return null;
        }
        return new Resolution(width.orElseThrow(), height.orElseThrow());
    }

    @NotNull
    private static OptionalInt getProperty(@NotNull AvdInfo avd, @NotNull String name) {
        String property2 = avd.getProperty(name);
        if (property2 == null) {
            return OptionalInt.empty();
        }
        try {
            return OptionalInt.of(Integer.parseInt(property2));
        }
        catch (NumberFormatException exception) {
            return OptionalInt.empty();
        }
    }

    @Nullable
    Project getProject() {
        return this.myProject;
    }
}

