/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.SerialNumber;
import com.android.tools.idea.devicemanager.physicaltab.AndroidVersionConverter;
import com.android.tools.idea.devicemanager.physicaltab.DomainName;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="deviceManagerPhysicalTab", storages={@Storage(value="deviceManagerPhysicalTab.xml")})
@Service
final class PhysicalTabPersistentStateComponent
implements PersistentStateComponent<PhysicalTabState> {
    @NotNull
    private PhysicalTabState myState = new PhysicalTabState();

    @VisibleForTesting
    PhysicalTabPersistentStateComponent() {
    }

    @NotNull
    static PhysicalTabPersistentStateComponent getInstance() {
        return (PhysicalTabPersistentStateComponent)ApplicationManager.getApplication().getService(PhysicalTabPersistentStateComponent.class);
    }

    @NotNull
    @NotNull Collection<@NotNull PhysicalDevice> get() {
        return this.myState.physicalDevices.stream().map(rec$ -> ((PhysicalDeviceState)rec$).asPhysicalDevice()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    void set(@NotNull @NotNull Collection<@NotNull PhysicalDevice> devices2) {
        this.myState.physicalDevices = devices2.stream().filter(device2 -> device2.getKey().isPersistent()).map(x$0 -> new PhysicalDeviceState((PhysicalDevice)x$0)).collect(Collectors.toList());
    }

    @NotNull
    public PhysicalTabState getState() {
        return this.myState;
    }

    public void loadState(@NotNull PhysicalTabState state2) {
        this.myState = state2;
    }

    private static enum KeyType {
        SERIAL_NUMBER{

            @Override
            @NotNull
            Key newKey(@NotNull String value2) {
                return new SerialNumber(value2);
            }
        }
        ,
        DOMAIN_NAME{

            @Override
            @NotNull
            Key newKey(@NotNull String value2) {
                return new DomainName(value2);
            }
        };


        @NotNull
        private static KeyType get(@NotNull Key key) {
            if (key instanceof SerialNumber) {
                return SERIAL_NUMBER;
            }
            if (key instanceof DomainName) {
                return DOMAIN_NAME;
            }
            throw new AssertionError(key);
        }

        @NotNull
        abstract Key newKey(@NotNull String var1);
    }

    @Tag(value="Key")
    private static final class KeyState {
        @OptionTag(tag="type", nameAttribute="")
        @Nullable
        private final KeyType type;
        @OptionTag(tag="value", nameAttribute="")
        @Nullable
        private final String value;

        private KeyState() {
            this.type = null;
            this.value = null;
        }

        private KeyState(@NotNull Key key) {
            this.type = KeyType.get(key);
            this.value = key.toString();
        }

        @Nullable
        private Key asKey() {
            if (this.type == null || this.value == null) {
                Logger.getInstance(PhysicalTabPersistentStateComponent.class).warn("type or value are null");
                return null;
            }
            return this.type.newKey(this.value);
        }

        public int hashCode() {
            return 31 * Objects.hashCode((Object)this.type) + Objects.hashCode(this.value);
        }

        public boolean equals(@Nullable Object object) {
            if (!(object instanceof KeyState)) {
                return false;
            }
            KeyState key = (KeyState)object;
            return Objects.equals((Object)this.type, (Object)key.type) && Objects.equals(this.value, key.value);
        }
    }

    @Tag(value="PhysicalDevice")
    private static final class PhysicalDeviceState {
        @OptionTag(tag="key", nameAttribute="")
        @Nullable
        private final KeyState key;
        @OptionTag(tag="type", nameAttribute="")
        @NotNull
        private final DeviceType type;
        @OptionTag(tag="name", nameAttribute="")
        @Nullable
        private final String name;
        @OptionTag(tag="nameOverride", nameAttribute="")
        @NotNull
        private final String nameOverride;
        @OptionTag(tag="target", nameAttribute="")
        @Nullable
        private final String target;
        @OptionTag(tag="api", nameAttribute="", converter=AndroidVersionConverter.class)
        @NotNull
        private final AndroidVersion androidVersion;

        private PhysicalDeviceState() {
            this.key = null;
            this.type = DeviceType.PHONE;
            this.name = null;
            this.nameOverride = "";
            this.target = null;
            this.androidVersion = AndroidVersion.DEFAULT;
        }

        private PhysicalDeviceState(@NotNull PhysicalDevice device2) {
            this.key = new KeyState(device2.getKey());
            this.type = device2.getType();
            this.name = device2.getName();
            this.nameOverride = "";
            this.target = device2.getTarget();
            this.androidVersion = device2.getAndroidVersion();
        }

        @Nullable
        private PhysicalDevice asPhysicalDevice() {
            if (this.key == null || this.name == null || this.target == null) {
                Logger.getInstance(PhysicalTabPersistentStateComponent.class).warn("key, name, or target are null");
                return null;
            }
            Key key = this.key.asKey();
            if (key == null) {
                Logger.getInstance(PhysicalTabPersistentStateComponent.class).warn("key is null");
                return null;
            }
            return new PhysicalDevice.Builder().setKey(key).setType(this.type).setName(this.name).setNameOverride(this.nameOverride).setTarget(this.target).setAndroidVersion(this.androidVersion).build();
        }

        public int hashCode() {
            int hashCode = Objects.hashCode(this.key);
            hashCode = 31 * hashCode + this.type.hashCode();
            hashCode = 31 * hashCode + Objects.hashCode(this.name);
            hashCode = 31 * hashCode + this.nameOverride.hashCode();
            hashCode = 31 * hashCode + Objects.hashCode(this.target);
            hashCode = 31 * hashCode + this.androidVersion.hashCode();
            return hashCode;
        }

        public boolean equals(@Nullable Object object) {
            if (!(object instanceof PhysicalDeviceState)) {
                return false;
            }
            PhysicalDeviceState device2 = (PhysicalDeviceState)object;
            return Objects.equals(this.key, device2.key) && this.type.equals((Object)device2.type) && Objects.equals(this.name, device2.name) && this.nameOverride.equals(device2.nameOverride) && Objects.equals(this.target, device2.target) && this.androidVersion.equals((Object)device2.androidVersion);
        }
    }

    static final class PhysicalTabState {
        @XCollection(style=XCollection.Style.v2)
        @NotNull
        private @NotNull Collection<@NotNull PhysicalDeviceState> physicalDevices = Collections.emptyList();

        PhysicalTabState() {
        }

        public int hashCode() {
            return this.physicalDevices.hashCode();
        }

        public boolean equals(@Nullable Object object) {
            return object instanceof PhysicalTabState && this.physicalDevices.equals(((PhysicalTabState)object).physicalDevices);
        }
    }
}

