/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.annotations.concurrency.UiThread;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowValue;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Devices;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.PopUpMenuValue;
import com.android.tools.idea.devicemanager.SerialNumber;
import com.android.tools.idea.devicemanager.physicaltab.DomainName;
import com.android.tools.idea.devicemanager.physicaltab.Ipv4Address;
import com.android.tools.idea.devicemanager.physicaltab.Localhost;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

@UiThread
final class PhysicalDeviceTableModel
extends AbstractTableModel {
    static final int DEVICE_ICON_MODEL_COLUMN_INDEX = 0;
    static final int DEVICE_MODEL_COLUMN_INDEX = 1;
    static final int API_MODEL_COLUMN_INDEX = 2;
    static final int TYPE_MODEL_COLUMN_INDEX = 3;
    static final int ACTIVATE_DEVICE_FILE_EXPLORER_WINDOW_MODEL_COLUMN_INDEX = 4;
    static final int REMOVE_MODEL_COLUMN_INDEX = 5;
    static final int POP_UP_MENU_MODEL_COLUMN_INDEX = 6;
    @NotNull
    private @NotNull List<@NotNull PhysicalDevice> myDevices;
    @NotNull
    private @NotNull List<@NotNull PhysicalDevice> myCombinedDevices;

    PhysicalDeviceTableModel() {
        this(List.of());
    }

    @VisibleForTesting
    PhysicalDeviceTableModel(@NotNull @NotNull Collection<@NotNull PhysicalDevice> devices2) {
        this.myDevices = new ArrayList<PhysicalDevice>(devices2);
        this.myCombinedDevices = List.of();
        this.combineDevices();
    }

    @NotNull
    @NotNull Collection<@NotNull PhysicalDevice> getDevices() {
        return this.myDevices;
    }

    void setDevices(@NotNull @NotNull List<@NotNull PhysicalDevice> devices2) {
        this.myDevices = devices2;
        this.combineDevices();
        this.fireTableDataChanged();
    }

    void addOrSet(@NotNull PhysicalDevice device2) {
        int modelRowIndex = Devices.indexOf(this.myDevices, device2.getKey());
        if (modelRowIndex == -1) {
            this.myDevices.add(device2);
        } else {
            this.myDevices.set(modelRowIndex, device2);
        }
        this.combineDevices();
        this.fireTableDataChanged();
    }

    void remove(@NotNull Key key) {
        this.myDevices.removeIf(device2 -> {
            Key k = device2.getKey();
            return k.equals(key) || k.getSerialNumber().equals(key);
        });
        this.combineDevices();
        this.fireTableDataChanged();
    }

    private void combineDevices() {
        Collection<PhysicalDevice> domainNameDevices = this.filterDevicesBy(DomainName.class);
        Collection<PhysicalDevice> serialNumberDevices = this.filterDevicesBy(SerialNumber.class);
        ArrayList<PhysicalDevice> combinedDevices = new ArrayList<PhysicalDevice>(this.myDevices.size());
        Iterator<PhysicalDevice> domainNameDeviceIterator = domainNameDevices.iterator();
        block0: while (domainNameDeviceIterator.hasNext()) {
            PhysicalDevice domainNameDevice = domainNameDeviceIterator.next();
            SerialNumber domainNameSerialNumber = domainNameDevice.getKey().getSerialNumber();
            Iterator<PhysicalDevice> serialNumberDeviceIterator = serialNumberDevices.iterator();
            while (serialNumberDeviceIterator.hasNext()) {
                PhysicalDevice serialNumberDevice = serialNumberDeviceIterator.next();
                if (!((Object)domainNameSerialNumber).equals(serialNumberDevice.getKey())) continue;
                combinedDevices.add(PhysicalDeviceTableModel.combine(domainNameDevice, serialNumberDevice));
                domainNameDeviceIterator.remove();
                serialNumberDeviceIterator.remove();
                continue block0;
            }
        }
        combinedDevices.addAll(domainNameDevices);
        combinedDevices.addAll(serialNumberDevices);
        combinedDevices.addAll(this.filterDevicesBy(Ipv4Address.class));
        combinedDevices.addAll(this.filterDevicesBy(Localhost.class));
        this.myCombinedDevices = combinedDevices;
    }

    @NotNull
    private @NotNull Collection<@NotNull PhysicalDevice> filterDevicesBy(@NotNull Class<? extends Key> keyClass) {
        return this.myDevices.stream().filter(device2 -> keyClass.isInstance(device2.getKey())).collect(Collectors.toCollection(() -> new ArrayList(this.myDevices.size())));
    }

    @NotNull
    private static PhysicalDevice combine(@NotNull PhysicalDevice domainNameDevice, @NotNull PhysicalDevice serialNumberDevice) {
        return new PhysicalDevice.Builder().setKey(serialNumberDevice.getKey()).setType(serialNumberDevice.getType()).setName(serialNumberDevice.getName()).setNameOverride(serialNumberDevice.getNameOverride()).setTarget(serialNumberDevice.getTarget()).setAndroidVersion(serialNumberDevice.getAndroidVersion()).addAllConnectionTypes(domainNameDevice.getConnectionTypes()).addAllConnectionTypes(serialNumberDevice.getConnectionTypes()).build();
    }

    @NotNull
    @NotNull List<@NotNull PhysicalDevice> getCombinedDevices() {
        return this.myCombinedDevices;
    }

    @Override
    public int getRowCount() {
        return this.myCombinedDevices.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Device";
            }
            case 2: {
                return "API";
            }
            case 3: {
                return "Type";
            }
            case 4: 
            case 5: 
            case 6: {
                return "";
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return DeviceType.class;
            }
            case 1: {
                return Device.class;
            }
            case 2: {
                return AndroidVersion.class;
            }
            case 3: {
                return Collection.class;
            }
            case 4: {
                return ActivateDeviceFileExplorerWindowValue.class;
            }
            case 5: {
                return RemoveValue.class;
            }
            case 6: {
                return PopUpMenuValue.class;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    public boolean isCellEditable(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                return this.myCombinedDevices.get(modelRowIndex).isOnline();
            }
            case 5: {
                return !this.myCombinedDevices.get(modelRowIndex).isOnline();
            }
            case 6: {
                return true;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Object getValueAt(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return this.myCombinedDevices.get(modelRowIndex).getType();
            }
            case 1: {
                return this.myCombinedDevices.get(modelRowIndex);
            }
            case 2: {
                return this.myCombinedDevices.get(modelRowIndex).getAndroidVersion();
            }
            case 3: {
                return this.myCombinedDevices.get(modelRowIndex).getConnectionTypes();
            }
            case 4: {
                return ActivateDeviceFileExplorerWindowValue.INSTANCE;
            }
            case 5: {
                return RemoveValue.INSTANCE;
            }
            case 6: {
                return PopUpMenuValue.INSTANCE;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    static final class RemoveValue {
        static final RemoveValue INSTANCE = new RemoveValue();

        private RemoveValue() {
        }
    }
}

