/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.adb.wireless.PairDevicesUsingWiFiService;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.devicemanager.DetailsPanel;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DevicePanel;
import com.android.tools.idea.devicemanager.Devices;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceAsyncSupplier;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceChangeListener;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceDetailsPanel;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTable;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDeviceTableModel;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalTabPersistentStateComponent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhysicalDevicePanel
extends DevicePanel {
    @NotNull
    private final Disposable myParent;
    @NotNull
    private final @NotNull Function<@NotNull Project, @NotNull PairDevicesUsingWiFiService> myPairDevicesUsingWiFiServiceGetInstance;
    @NotNull
    private final @NotNull Function<@NotNull PhysicalDevicePanel, @NotNull PhysicalDeviceTable> myNewPhysicalDeviceTable;
    @NotNull
    private final @NotNull Supplier<@NotNull PhysicalTabPersistentStateComponent> myPhysicalTabPersistentStateComponentGetInstance;
    @NotNull
    private final @NotNull Function<@NotNull PhysicalDeviceTableModel, @NotNull Disposable> myNewPhysicalDeviceChangeListener;
    @NotNull
    private final @NotNull BiFunction<@NotNull PhysicalDevice, @Nullable Project, @NotNull DetailsPanel> myNewPhysicalDeviceDetailsPanel;
    @Nullable
    private AbstractButton myPairUsingWiFiButton;
    @Nullable
    private Component mySeparator;
    @Nullable
    private AbstractButton myHelpButton;

    public PhysicalDevicePanel(@Nullable Project project, @NotNull Disposable parent2) {
        this(project, parent2, PairDevicesUsingWiFiService::getInstance, PhysicalDeviceTable::new, PhysicalTabPersistentStateComponent::getInstance, PhysicalDeviceChangeListener::new, new PhysicalDeviceAsyncSupplier(project), PhysicalDevicePanel::newSetDevices, PhysicalDeviceDetailsPanel::new);
    }

    @VisibleForTesting
    PhysicalDevicePanel(@Nullable Project project, @NotNull Disposable parent2, @NotNull @NotNull Function<@NotNull Project, @NotNull PairDevicesUsingWiFiService> pairDevicesUsingWiFiServiceGetInstance, @NotNull @NotNull Function<@NotNull PhysicalDevicePanel, @NotNull PhysicalDeviceTable> newPhysicalDeviceTable, @NotNull @NotNull Supplier<@NotNull PhysicalTabPersistentStateComponent> physicalTabPersistentStateComponentGetInstance, @NotNull @NotNull Function<@NotNull PhysicalDeviceTableModel, @NotNull Disposable> newPhysicalDeviceChangeListener, @NotNull PhysicalDeviceAsyncSupplier supplier2, @NotNull @NotNull Function<@NotNull PhysicalDevicePanel, @NotNull FutureCallback<@Nullable List<@NotNull PhysicalDevice>>> newSetDevices, @NotNull @NotNull BiFunction<@NotNull PhysicalDevice, @Nullable Project, @NotNull DetailsPanel> newPhysicalDeviceDetailsPanel) {
        super(project);
        this.myParent = parent2;
        this.myPairDevicesUsingWiFiServiceGetInstance = pairDevicesUsingWiFiServiceGetInstance;
        this.myNewPhysicalDeviceTable = newPhysicalDeviceTable;
        this.myPhysicalTabPersistentStateComponentGetInstance = physicalTabPersistentStateComponentGetInstance;
        this.myNewPhysicalDeviceChangeListener = newPhysicalDeviceChangeListener;
        this.myNewPhysicalDeviceDetailsPanel = newPhysicalDeviceDetailsPanel;
        this.initPairUsingWiFiButton();
        this.initSeparator();
        this.initHelpButton();
        this.initTable();
        this.initScrollPane();
        this.initDetailsPanelPanel();
        this.layOut();
        FutureUtils.addCallback(supplier2.get(), (Executor)EdtExecutorService.getInstance(), newSetDevices.apply(this));
        Disposer.register((Disposable)parent2, (Disposable)this);
    }

    @VisibleForTesting
    @NotNull
    static @NotNull FutureCallback<@Nullable List<@NotNull PhysicalDevice>> newSetDevices(@NotNull PhysicalDevicePanel panel2) {
        return new DeviceManagerFutureCallback<List<PhysicalDevice>>(PhysicalDevicePanel.class, devices2 -> {
            assert (devices2 != null);
            panel2.setDevices(panel2.addOfflineDevices((List<PhysicalDevice>)devices2));
        });
    }

    private void initPairUsingWiFiButton() {
        if (this.myProject == null) {
            return;
        }
        PairDevicesUsingWiFiService service = this.myPairDevicesUsingWiFiServiceGetInstance.apply(this.myProject);
        if (!service.isFeatureEnabled()) {
            return;
        }
        this.myPairUsingWiFiButton = new JButton("Pair using Wi-Fi");
        this.myPairUsingWiFiButton.addActionListener(event -> service.createPairingDialogController().showDialog());
    }

    private void initSeparator() {
        if (this.myPairUsingWiFiButton == null) {
            return;
        }
        JBDimension size = new JBDimension(3, 20);
        this.mySeparator = new JSeparator(1);
        this.mySeparator.setPreferredSize((Dimension)size);
        this.mySeparator.setMaximumSize((Dimension)size);
    }

    private void initHelpButton() {
        this.myHelpButton = new CommonButton(AllIcons.Actions.Help);
        this.myHelpButton.addActionListener(event -> BrowserUtil.browse((String)"https://d.android.com/r/studio-ui/device-manager/physical"));
    }

    @Override
    @NotNull
    protected JTable newTable() {
        return (JTable)((Object)this.myNewPhysicalDeviceTable.apply(this));
    }

    @NotNull
    private @NotNull List<@NotNull PhysicalDevice> addOfflineDevices(@NotNull @NotNull List<@NotNull PhysicalDevice> onlineDevices) {
        Collection<PhysicalDevice> persistedDevices = this.myPhysicalTabPersistentStateComponentGetInstance.get().get();
        ArrayList<PhysicalDevice> devices2 = new ArrayList<PhysicalDevice>(onlineDevices.size() + persistedDevices.size());
        devices2.addAll(onlineDevices);
        persistedDevices.stream().filter(persistedDevice -> Devices.indexOf(onlineDevices, persistedDevice.getKey()) == -1).forEach(devices2::add);
        return devices2;
    }

    private void setDevices(@NotNull @NotNull List<@NotNull PhysicalDevice> devices2) {
        PhysicalDeviceTableModel model2 = this.getTable().getModel();
        model2.addTableModelListener(event -> this.myPhysicalTabPersistentStateComponentGetInstance.get().set(model2.getDevices()));
        model2.setDevices(devices2);
        Disposer.register((Disposable)this.myParent, (Disposable)this.myNewPhysicalDeviceChangeListener.apply(model2));
    }

    @Override
    @NotNull
    protected DetailsPanel newDetailsPanel() {
        return this.myNewPhysicalDeviceDetailsPanel.apply(this.getTable().getSelectedDevice().orElseThrow(AssertionError::new), this.myProject);
    }

    @VisibleForTesting
    @Nullable
    AbstractButton getPairUsingWiFiButton() {
        return this.myPairUsingWiFiButton;
    }

    @NotNull
    PhysicalDeviceTable getTable() {
        return (PhysicalDeviceTable)((Object)this.myTable);
    }

    private void layOut() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        GroupLayout.SequentialGroup toolbarHorizontalGroup = layout.createSequentialGroup();
        if (this.myPairUsingWiFiButton != null) {
            ((GroupLayout.Group)toolbarHorizontalGroup).addGap(JBUIScale.scale((int)5)).addComponent(this.myPairUsingWiFiButton).addGap(JBUIScale.scale((int)4)).addComponent(this.mySeparator);
        }
        ((GroupLayout.Group)toolbarHorizontalGroup).addComponent(this.myHelpButton);
        GroupLayout.ParallelGroup toolbarVerticalGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER);
        if (this.myPairUsingWiFiButton != null) {
            ((GroupLayout.Group)toolbarVerticalGroup).addComponent(this.myPairUsingWiFiButton).addComponent(this.mySeparator);
        }
        ((GroupLayout.Group)toolbarVerticalGroup).addComponent(this.myHelpButton);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addGroup(toolbarHorizontalGroup).addComponent((Component)((Object)this.myDetailsPanelPanel));
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addGroup(toolbarVerticalGroup).addComponent((Component)((Object)this.myDetailsPanelPanel));
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.setLayout(layout);
    }
}

