/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.annotations.concurrency.UiThread;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.devicemanager.DeviceManagerAndroidDebugBridge;
import com.android.tools.idea.devicemanager.DeviceManagerFutures;
import com.android.tools.idea.devicemanager.physicaltab.BuilderService;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhysicalDeviceAsyncSupplier {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DeviceManagerAndroidDebugBridge myBridge;
    @NotNull
    private final @NotNull Supplier<@NotNull BuilderService> myBuilderServiceGetInstance;

    @UiThread
    PhysicalDeviceAsyncSupplier(@Nullable Project project) {
        this(project, new DeviceManagerAndroidDebugBridge(), BuilderService::getInstance);
    }

    @VisibleForTesting
    PhysicalDeviceAsyncSupplier(@Nullable Project project, @NotNull DeviceManagerAndroidDebugBridge bridge, @NotNull @NotNull Supplier<@NotNull BuilderService> builderServiceGetInstance) {
        this.myProject = project;
        this.myBridge = bridge;
        this.myBuilderServiceGetInstance = builderServiceGetInstance;
    }

    @UiThread
    @NotNull
    @NotNull ListenableFuture<@NotNull List<@NotNull PhysicalDevice>> get() {
        return Futures.transformAsync(this.myBridge.getDevices(this.myProject), this::collectToPhysicalDevices, (Executor)EdtExecutorService.getInstance());
    }

    @UiThread
    @NotNull
    private @NotNull ListenableFuture<@NotNull List<@NotNull PhysicalDevice>> collectToPhysicalDevices(@NotNull @NotNull Collection<@NotNull IDevice> devices2) {
        BuilderService service = this.myBuilderServiceGetInstance.get();
        Iterable futures2 = devices2.stream().filter(device2 -> !device2.isEmulator()).map(service::build).collect(Collectors.toList());
        return DeviceManagerFutures.successfulAsList(futures2, (Executor)EdtExecutorService.getInstance());
    }
}

