/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.tools.idea.devicemanager.ConnectionType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.SerialNumber;
import com.google.common.net.HostAndPort;
import java.util.Optional;
import org.apache.http.conn.util.InetAddressUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Ipv4Address
extends Key {
    @NotNull
    private final String myValue;

    private Ipv4Address(@NotNull String value2) {
        this.myValue = value2;
    }

    @NotNull
    static @NotNull Optional<@NotNull Key> parse(@NotNull String value2) {
        if (InetAddressUtils.isIPv4Address((String)HostAndPort.fromString((String)value2).getHost())) {
            return Optional.of(new Ipv4Address(value2));
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public ConnectionType getConnectionType() {
        return ConnectionType.UNKNOWN;
    }

    @Override
    @NotNull
    public SerialNumber getSerialNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    public int hashCode() {
        return this.myValue.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof Ipv4Address && this.myValue.equals(((Ipv4Address)object).myValue);
    }

    @NotNull
    public String toString() {
        return this.myValue;
    }
}

