/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditDeviceNameDialog
extends DialogWrapper {
    @Nullable
    private JBTextField myTextField;
    @Nullable
    private AbstractButton myLink;

    EditDeviceNameDialog(@Nullable Project project, @NotNull String nameOverride, @NotNull String name) {
        super(project);
        this.initTextField(nameOverride, name);
        this.initLink();
        this.init();
        this.setTitle("Edit Device Name");
        this.setOKButtonText("Save");
    }

    private void initTextField(@NotNull String nameOverride, @NotNull String name) {
        this.myTextField = new JBTextField(nameOverride, 16);
        this.myTextField.getEmptyText().setText(name);
        this.myTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                EditDeviceNameDialog.this.myTextField.selectAll();
            }
        });
    }

    private void initLink() {
        this.myLink = new ActionLink("Reset to default", event -> {
            assert (this.myTextField != null);
            this.myTextField.setText("");
        });
    }

    @NotNull
    String getNameOverride() {
        assert (this.myTextField != null);
        return this.myTextField.getText();
    }

    @VisibleForTesting
    @NotNull
    JTextComponent getTextField() {
        assert (this.myTextField != null);
        return this.myTextField;
    }

    @VisibleForTesting
    @NotNull
    AbstractButton getLink() {
        assert (this.myLink != null);
        return this.myLink;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBLabel label = new JBLabel("Name:");
        JBPanel panel2 = new JBPanel(null);
        GroupLayout layout = new GroupLayout((Container)panel2);
        layout.setAutoCreateGaps(true);
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup().addComponent((Component)label).addComponent((Component)this.myTextField).addComponent(this.myLink);
        GroupLayout.ParallelGroup verticalGroup = layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent((Component)label).addComponent((Component)this.myTextField).addComponent(this.myLink);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout);
        return panel2;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTextField;
    }
}

