/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.annotations.concurrency.UiThread;
import com.android.ddmlib.IDevice;
import com.android.ide.common.util.DeviceUtils;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.SerialNumber;
import com.android.tools.idea.devicemanager.physicaltab.AsyncPhysicalDeviceBuilder;
import com.android.tools.idea.devicemanager.physicaltab.DomainName;
import com.android.tools.idea.devicemanager.physicaltab.Ipv4Address;
import com.android.tools.idea.devicemanager.physicaltab.Localhost;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevice;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import org.jetbrains.annotations.NotNull;

@UiThread
@Service
final class BuilderService {
    @VisibleForTesting
    BuilderService() {
    }

    @NotNull
    static BuilderService getInstance() {
        return (BuilderService)ApplicationManager.getApplication().getService(BuilderService.class);
    }

    @NotNull
    @NotNull ListenableFuture<@NotNull PhysicalDevice> build(@NotNull IDevice device2) {
        return new AsyncPhysicalDeviceBuilder(device2, BuilderService.parse(device2.getSerialNumber())).buildAsync();
    }

    @NotNull
    private static Key parse(@NotNull String value2) {
        if (DeviceUtils.isMdnsAutoConnectTls((String)value2)) {
            return new DomainName(value2);
        }
        return Ipv4Address.parse(value2).or(() -> Localhost.parse(value2)).orElseGet(() -> new SerialNumber(value2));
    }
}

