/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.physicaltab;

import com.android.sdklib.AndroidVersion;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.xmlb.Converter;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AndroidVersionConverter
extends Converter<AndroidVersion> {
    @NotNull
    private static final Pattern PATTERN = Pattern.compile("androidversion:(.+):(.+):(.+):(.+)");

    @VisibleForTesting
    AndroidVersionConverter() {
    }

    @NotNull
    public AndroidVersion fromString(@NotNull String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (matcher.matches()) {
            return AndroidVersionConverter.fromMatchResult(matcher);
        }
        try {
            return new AndroidVersion(string);
        }
        catch (AndroidVersion.AndroidVersionException exception) {
            Logger.getInstance(AndroidVersionConverter.class).warn((Throwable)exception);
            return AndroidVersion.DEFAULT;
        }
    }

    @NotNull
    private static AndroidVersion fromMatchResult(@NotNull MatchResult result2) {
        try {
            return new AndroidVersion(Integer.parseInt(result2.group(1)), AndroidVersionConverter.parseString(result2.group(2)), AndroidVersionConverter.parseInteger(result2.group(3)), AndroidVersionConverter.parseBoolean(result2.group(4)));
        }
        catch (IllegalArgumentException exception) {
            Logger.getInstance(AndroidVersionConverter.class).warn((Throwable)exception);
            return AndroidVersion.DEFAULT;
        }
    }

    @Nullable
    private static String parseString(@NotNull String string) {
        if (string.equals("null")) {
            return null;
        }
        return string;
    }

    @Nullable
    private static Integer parseInteger(@NotNull String string) {
        if (string.equals("null")) {
            return null;
        }
        return Integer.parseInt(string);
    }

    private static boolean parseBoolean(@NotNull String string) {
        switch (string) {
            case "false": {
                return false;
            }
            case "true": {
                return true;
            }
        }
        throw new IllegalArgumentException(string);
    }

    @NotNull
    public String toString(@NotNull AndroidVersion version2) {
        return "androidversion:" + version2.getApiLevel() + ":" + version2.getCodename() + ":" + version2.getExtensionLevel() + ":" + version2.isBaseExtension();
    }
}

