/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Tables {
    private Tables() {
    }

    @NotNull
    public static Color getBackground(@NotNull JTable table2, boolean selected) {
        if (selected) {
            return table2.getSelectionBackground();
        }
        return table2.getBackground();
    }

    @Nullable
    public static Border getBorder(boolean selected, boolean focused) {
        return Tables.getBorder(selected, focused, UIManager::getBorder);
    }

    @VisibleForTesting
    @Nullable
    static Border getBorder(boolean selected, boolean focused, @NotNull @NotNull Function<@NotNull Object, @Nullable Border> getBorder) {
        if (!focused) {
            return getBorder.apply("Table.cellNoFocusBorder");
        }
        if (selected) {
            return getBorder.apply("Table.focusSelectedCellHighlightBorder");
        }
        return getBorder.apply("Table.focusCellHighlightBorder");
    }

    @NotNull
    public static Color getForeground(@NotNull JTable table2, boolean selected) {
        if (selected) {
            return table2.getSelectionForeground();
        }
        return table2.getForeground();
    }

    @NotNull
    static Icon getIcon(@NotNull JTable table2, boolean selected, @NotNull Icon icon2) {
        if (selected) {
            return ColoredIconGenerator.INSTANCE.generateColoredIcon(icon2, table2.getSelectionForeground());
        }
        return icon2;
    }

    public static void setWidths(@NotNull TableColumn column2, int width) {
        column2.setMinWidth(width);
        column2.setMaxWidth(width);
        column2.setPreferredWidth(width);
    }

    public static void setWidths(@NotNull TableColumn column2, int width, int minWidth) {
        column2.setMinWidth(minWidth);
        column2.setMaxWidth(width);
        column2.setPreferredWidth(width);
    }

    public static int getPreferredColumnWidth(@NotNull JTable table2, int viewColumnIndex, int minPreferredWidth) {
        OptionalInt width = IntStream.range(-1, table2.getRowCount()).map(viewRowIndex -> Tables.getPreferredCellWidth(table2, viewRowIndex, viewColumnIndex)).max();
        if (!width.isPresent()) {
            return minPreferredWidth;
        }
        return Math.max(width.getAsInt(), minPreferredWidth);
    }

    private static int getPreferredCellWidth(@NotNull JTable table2, int viewRowIndex, int viewColumnIndex) {
        Component component2;
        if (viewRowIndex == -1) {
            TableCellRenderer renderer2 = table2.getTableHeader().getDefaultRenderer();
            Object value2 = table2.getColumnModel().getColumn(viewColumnIndex).getHeaderValue();
            component2 = renderer2.getTableCellRendererComponent(table2, value2, false, false, -1, viewColumnIndex);
        } else {
            component2 = table2.prepareRenderer(table2.getCellRenderer(viewRowIndex, viewColumnIndex), viewRowIndex, viewColumnIndex);
        }
        return component2.getPreferredSize().width + JBUI.scale((int)8);
    }
}

