/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Pairing;
import com.android.tools.idea.devicemanager.Status;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

final class PairingTableModel
extends AbstractTableModel {
    static final int DEVICE_ICON_MODEL_COLUMN_INDEX = 0;
    static final int DEVICE_MODEL_COLUMN_INDEX = 1;
    static final int STATUS_MODEL_COLUMN_INDEX = 2;
    @NotNull
    private @NotNull List<@NotNull Pairing> myPairings = Collections.emptyList();

    PairingTableModel() {
    }

    @NotNull
    @NotNull List<@NotNull Pairing> getPairings() {
        return this.myPairings;
    }

    void setPairings(@NotNull @NotNull List<@NotNull Pairing> pairings) {
        this.myPairings = pairings;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.myPairings.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Device";
            }
            case 2: {
                return "Status";
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return DeviceType.class;
            }
            case 1: {
                return Device.class;
            }
            case 2: {
                return Status.class;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Object getValueAt(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return this.myPairings.get(modelRowIndex).getOtherDevice().getType();
            }
            case 1: {
                return this.myPairings.get(modelRowIndex).getOtherDevice();
            }
            case 2: {
                return this.myPairings.get(modelRowIndex).getOtherDevice().getStatus();
            }
        }
        throw new AssertionError(modelColumnIndex);
    }
}

