/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.devicemanager.DeviceManagerPairingDevice;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.SerialNumber;
import com.android.tools.idea.devicemanager.Status;
import com.android.tools.idea.devicemanager.Targets;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePath;
import com.android.tools.idea.wearpairing.PairingDevice;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.intellij.icons.AllIcons;
import org.jetbrains.annotations.NotNull;

final class Pairing {
    @NotNull
    private final WearPairingManager.PhoneWearPair myPair;
    @NotNull
    private final DeviceManagerPairingDevice myOtherDevice;

    Pairing(@NotNull WearPairingManager.PhoneWearPair pair, @NotNull Key key) {
        this.myPair = pair;
        this.myOtherDevice = this.toDeviceManagerPairingDevice(pair.getPeerDevice(key.toString()));
    }

    @NotNull
    private DeviceManagerPairingDevice toDeviceManagerPairingDevice(@NotNull PairingDevice device2) {
        boolean virtual = device2.isEmulator();
        DeviceType type = device2.isWearDevice() ? DeviceType.WEAR_OS : DeviceType.PHONE;
        AndroidVersion version2 = new AndroidVersion(device2.getApiLevel());
        return new DeviceManagerPairingDevice.Builder().setKey(virtual ? new VirtualDevicePath(device2.getDeviceID()) : new SerialNumber(device2.getDeviceID())).setType(type).setIcon(virtual ? type.getVirtualIcon() : type.getPhysicalIcon()).setName(device2.getDisplayName()).setOnline(device2.isOnline()).setTarget(Targets.toString(version2)).setStatus(this.newStatus(device2)).setAndroidVersion(version2).build();
    }

    @NotNull
    private Status newStatus(@NotNull PairingDevice device2) {
        if (!device2.isEmulator() && this.myPair.getPairingStatus().equals((Object)WearPairingManager.PairingState.OFFLINE)) {
            return new Status("Unavailable", AllIcons.General.ShowInfos, "<html>Connect device to begin<br>communication between devices</html>");
        }
        return new Status(this.getPairingStatus());
    }

    @NotNull
    private String getPairingStatus() {
        switch (this.myPair.getPairingStatus()) {
            case UNKNOWN: {
                return "Unknown";
            }
            case OFFLINE: {
                return "Offline";
            }
            case CONNECTING: {
                return "Connecting";
            }
            case CONNECTED: {
                return "Connected";
            }
            case PAIRING_FAILED: {
                return "Error pairing";
            }
        }
        throw new AssertionError((Object)this.myPair.getPairingStatus());
    }

    @NotNull
    WearPairingManager.PhoneWearPair getPair() {
        return this.myPair;
    }

    @NotNull
    DeviceManagerPairingDevice getOtherDevice() {
        return this.myOtherDevice;
    }
}

