/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.Pairing;
import com.android.tools.idea.devicemanager.PairingTable;
import com.android.tools.idea.wearpairing.PairingDevice;
import com.android.tools.idea.wearpairing.WearDevicePairingWizard;
import com.android.tools.idea.wearpairing.WearPairingManager;
import com.android.tools.idea.wearpairing.WearPairingManagerKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PairedDevicesPanel
extends JBPanel<PairedDevicesPanel>
implements Disposable,
WearPairingManager.PairingStatusChangedListener {
    @NotNull
    private final Key myKey;
    @Nullable
    private final Project myProject;
    @NotNull
    private final WearPairingManager myManager;
    @Nullable
    private AbstractButton myAddButton;
    private AbstractButton myRemoveButton;
    private PairingTable myTable;
    @Nullable
    private JComponent myScrollPane;

    @UiThread
    public PairedDevicesPanel(@NotNull Key key, @NotNull Disposable parent2, @Nullable Project project) {
        this(key, parent2, project, WearPairingManager.getInstance());
    }

    @UiThread
    @VisibleForTesting
    PairedDevicesPanel(@NotNull Key key, @NotNull Disposable parent2, @Nullable Project project, @NotNull WearPairingManager manager) {
        super(null);
        this.myKey = key;
        this.myProject = project;
        this.myManager = manager;
        this.initAddButton();
        this.initRemoveButton();
        this.initTable();
        this.initScrollPane();
        this.layOut();
        this.myManager.addDevicePairingStatusChangedListener(this);
        Disposer.register((Disposable)parent2, (Disposable)this);
    }

    @UiThread
    public void dispose() {
        this.myManager.removeDevicePairingStatusChangedListener(this);
    }

    @UiThread
    private void initAddButton() {
        this.myAddButton = new CommonButton(AllIcons.General.Add);
        this.myAddButton.setToolTipText("Add");
        this.myAddButton.addActionListener(event -> new WearDevicePairingWizard().show(this.myProject, this.myKey.toString()));
    }

    @UiThread
    private void initRemoveButton() {
        this.myRemoveButton = new CommonButton(AllIcons.General.Remove);
        this.myRemoveButton.setEnabled(false);
        this.myRemoveButton.setToolTipText("Remove");
        this.myRemoveButton.addActionListener(event -> this.remove());
    }

    @UiThread
    private void remove() {
        WearPairingManager.PhoneWearPair pair = this.myTable.getSelectedPairing().orElseThrow(AssertionError::new).getPair();
        PairingDevice wearOs = pair.getWear();
        PairingDevice phone = pair.getPhone();
        String message2 = "This will disconnect " + wearOs + " from " + phone + ". To completely unpair the two devices, remove " + wearOs + " from the list of devices in the Wear OS app on " + phone + " and wipe data from " + wearOs + ".";
        boolean disconnect2 = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.okCancel((String)("Disconnect " + wearOs + " from " + phone + "?"), (String)message2).asWarning()).yesText("Disconnect")).ask((Component)((Object)this));
        if (disconnect2) {
            WearPairingManagerKt.removePairedDevicesAsync(this.myManager, pair, true);
        }
    }

    @UiThread
    private void initTable() {
        this.myTable = new PairingTable(this.myKey, this.myProject);
        this.myTable.getSelectionModel().addListSelectionListener(event -> {
            if (event.getValueIsAdjusting()) {
                return;
            }
            this.myRemoveButton.setEnabled(this.myTable.getSelectedRowCount() != 0);
        });
        this.reloadPairings();
        if (this.myTable.isEmpty()) {
            return;
        }
        this.myTable.setRowSelectionInterval(0, 0);
    }

    @UiThread
    private void initScrollPane() {
        this.myScrollPane = new JBScrollPane((Component)((Object)this.myTable));
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
    }

    @UiThread
    private void layOut() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.myAddButton).addComponent(this.myRemoveButton)).addComponent(this.myScrollPane);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.myAddButton).addComponent(this.myRemoveButton)).addComponent(this.myScrollPane);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.setLayout(layout);
    }

    @Override
    @AnyThread
    public void pairingStatusChanged(@NotNull WearPairingManager.PhoneWearPair pair) {
        this.reloadPairingsIfPairContainsKey(pair);
    }

    @Override
    @WorkerThread
    public void pairingDeviceRemoved(@NotNull WearPairingManager.PhoneWearPair pair) {
        this.reloadPairingsIfPairContainsKey(pair);
    }

    @AnyThread
    private void reloadPairingsIfPairContainsKey(@NotNull WearPairingManager.PhoneWearPair pair) {
        if (pair.contains(this.myKey.toString())) {
            ApplicationManager.getApplication().invokeLater(this::reloadPairings, ModalityState.any());
        }
    }

    @UiThread
    @VisibleForTesting
    void reloadPairings() {
        List<WearPairingManager.PhoneWearPair> pairs = this.myManager.getPairsForDevice(this.myKey.toString());
        if (pairs.isEmpty()) {
            Logger.getInstance(PairedDevicesPanel.class).info("No pairs");
        } else {
            Logger logger2 = Logger.getInstance(PairedDevicesPanel.class);
            int i = 1;
            for (Object e : pairs) {
                logger2.info(i++ + " " + e);
            }
        }
        List<Pairing> pairings = pairs.stream().map(pair -> new Pairing((WearPairingManager.PhoneWearPair)pair, this.myKey)).collect(Collectors.toList());
        this.myTable.getModel().setPairings(pairings);
    }

    @VisibleForTesting
    @NotNull
    AbstractButton getRemoveButton() {
        return this.myRemoveButton;
    }

    @NotNull
    JTable getTable() {
        return this.myTable;
    }
}

