/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.android.tools.idea.devicemanager.DeviceManagerWelcomeScreenFrame;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.serviceContainer.NonInjectable;
import java.util.function.BooleanSupplier;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

final class DeviceManagerWelcomeScreenAction
extends DumbAwareAction {
    @NotNull
    private final BooleanSupplier myIsChromeOSAndIsNotHWAccelerated;
    @NotNull
    private final BooleanSupplier myIsAndroidSdkAvailable;
    @Nullable
    private DeviceManagerWelcomeScreenFrame myDeviceManagerWelcomeScreenFrame;

    private DeviceManagerWelcomeScreenAction() {
        this(HardwareAccelerationCheck::isChromeOSAndIsNotHWAccelerated, AndroidSdkUtils::isAndroidSdkAvailable);
    }

    @NonInjectable
    @VisibleForTesting
    DeviceManagerWelcomeScreenAction(@NotNull BooleanSupplier isChromeOSAndIsNotHWAccelerated, @NotNull BooleanSupplier isAndroidSdkAvailable) {
        this.myIsChromeOSAndIsNotHWAccelerated = isChromeOSAndIsNotHWAccelerated;
        this.myIsAndroidSdkAvailable = isAndroidSdkAvailable;
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (this.myIsChromeOSAndIsNotHWAccelerated.getAsBoolean() || event.getProject() != null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(this.myIsAndroidSdkAvailable.getAsBoolean());
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (this.myDeviceManagerWelcomeScreenFrame == null) {
            this.myDeviceManagerWelcomeScreenFrame = new DeviceManagerWelcomeScreenFrame(event.getProject());
            Disposer.register((Disposable)this.myDeviceManagerWelcomeScreenFrame, () -> {
                this.myDeviceManagerWelcomeScreenFrame = null;
            });
            this.myDeviceManagerWelcomeScreenFrame.show();
        } else {
            this.myDeviceManagerWelcomeScreenFrame.getFrame().toFront();
        }
    }
}

