/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.AndroidEnvironmentUtils;
import com.android.tools.idea.devicemanager.DeviceManagerTab;
import com.android.tools.idea.devicemanager.physicaltab.PhysicalDevicePanel;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Insets;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class DeviceManagerToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final String ID = "Device Manager";
    @NotNull
    private final @NotNull BiFunction<@Nullable Project, @NotNull Disposable, @NotNull Component> myNewVirtualDevicePanel;

    private DeviceManagerToolWindowFactory() {
        this(VirtualDevicePanel::new);
    }

    @NonInjectable
    @VisibleForTesting
    DeviceManagerToolWindowFactory(@NotNull @NotNull BiFunction<@Nullable Project, @NotNull Disposable, @NotNull Component> newVirtualDevicePanel) {
        this.myNewVirtualDevicePanel = newVirtualDevicePanel;
    }

    public boolean isApplicable(@NotNull Project project) {
        return AndroidEnvironmentUtils.isAndroidEnvironment((Project)project);
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow window2) {
        Disposable parent2 = Disposer.newDisposable((String)"Device Manager parent");
        JComponent pane = this.newJBTabbedPane(project, parent2);
        Content content2 = ContentFactory.getInstance().createContent(pane, null, false);
        content2.setDisposer(parent2);
        window2.getContentManager().addContent(content2);
    }

    @NotNull
    private JComponent newJBTabbedPane(@NotNull Project project, @NotNull Disposable parent2) {
        JBTabbedPane pane = new JBTabbedPane();
        pane.setTabComponentInsets((Insets)JBUI.emptyInsets());
        pane.addTab("Virtual", this.myNewVirtualDevicePanel.apply(project, parent2));
        pane.addTab("Physical", (Component)((Object)new PhysicalDevicePanel(project, parent2)));
        for (DeviceManagerTab tab : (DeviceManagerTab[])DeviceManagerTab.EP_NAME.getExtensions()) {
            if (!tab.isApplicable()) continue;
            int index2 = pane.getTabCount();
            pane.addTab(tab.getName(), DeviceManagerToolWindowFactory.createTabContent(project, parent2, tab));
            tab.setRecreateCallback(() -> pane.setComponentAt(index2, DeviceManagerToolWindowFactory.createTabContent(project, parent2, tab)), parent2);
        }
        return pane;
    }

    @NotNull
    private static Component createTabContent(@NotNull Project project, @NotNull Disposable parent2, DeviceManagerTab tab) {
        Object content2;
        try {
            content2 = tab.getPanel(project, parent2);
        }
        catch (Throwable throwable) {
            content2 = tab.getErrorComponent(throwable);
        }
        return content2;
    }
}

