/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceManagerFutures {
    private DeviceManagerFutures() {
    }

    public static <V> @NotNull ListenableFuture<@Nullable V> appExecutorServiceSubmit(@NotNull Callable<@Nullable V> callable) {
        return Futures.submit(callable, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    public static @NotNull ListenableFuture<@Nullable Void> appExecutorServiceSubmit(@NotNull Runnable runnable2) {
        return Futures.submit((Runnable)runnable2, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public static <V> V getDoneOrElse(@NotNull @NotNull Future<@NotNull V> future2, @NotNull V defaultValue) {
        assert (future2.isDone());
        try {
            return future2.get();
        }
        catch (CancellationException | ExecutionException exception) {
            return defaultValue;
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new AssertionError((Object)exception);
        }
    }

    @NotNull
    public static <V> @NotNull ListenableFuture<@NotNull List<@NotNull V>> successfulAsList(@NotNull @NotNull Iterable<@NotNull ListenableFuture<@NotNull V>> futures2, @NotNull Executor executor2) {
        return Futures.transform((ListenableFuture)Futures.successfulAsList(futures2), DeviceManagerFutures::filterSuccessful, (Executor)executor2);
    }

    @NotNull
    private static <V> @NotNull List<@NotNull V> filterSuccessful(@NotNull Collection<@Nullable V> values) {
        List nonnullValues = values.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (nonnullValues.size() != values.size()) {
            Logger.getInstance(DeviceManagerFutures.class).warn("Some of the input futures failed");
        }
        return nonnullValues;
    }
}

