/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.resources.Density;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.device.Resolution;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.StorageDevice;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Device {
    @NotNull
    protected final Key myKey;
    @NotNull
    protected final DeviceType myType;
    @NotNull
    protected final String myName;
    @NotNull
    protected final String myTarget;
    @NotNull
    protected final AndroidVersion myAndroidVersion;
    @Nullable
    protected final Resolution myResolution;
    protected final int myDensity;
    @NotNull
    protected final @NotNull ImmutableCollection<@NotNull String> myAbis;
    @Nullable
    protected final StorageDevice myStorageDevice;

    protected Device(@NotNull Builder builder2) {
        assert (builder2.myKey != null);
        this.myKey = builder2.myKey;
        this.myType = builder2.myType;
        assert (builder2.myName != null);
        this.myName = builder2.myName;
        assert (builder2.myTarget != null);
        this.myTarget = builder2.myTarget;
        this.myAndroidVersion = builder2.myAndroidVersion;
        this.myResolution = builder2.myResolution;
        this.myDensity = builder2.myDensity;
        this.myAbis = ImmutableList.copyOf(builder2.myAbis);
        this.myStorageDevice = builder2.myStorageDevice;
    }

    @NotNull
    public final Key getKey() {
        return this.myKey;
    }

    @NotNull
    public final DeviceType getType() {
        return this.myType;
    }

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public final String getName() {
        return this.myName;
    }

    public abstract boolean isOnline();

    @NotNull
    public final String getTarget() {
        return this.myTarget;
    }

    @NotNull
    public final AndroidVersion getAndroidVersion() {
        return this.myAndroidVersion;
    }

    @Nullable
    public final Resolution getResolution() {
        return this.myResolution;
    }

    @Nullable
    public final Resolution getDp() {
        if (this.myDensity == -1) {
            return null;
        }
        if (this.myResolution == null) {
            return null;
        }
        int width = (int)Math.ceil((double)Density.DEFAULT_DENSITY * (double)this.myResolution.getWidth() / (double)this.myDensity);
        int height = (int)Math.ceil((double)Density.DEFAULT_DENSITY * (double)this.myResolution.getHeight() / (double)this.myDensity);
        return new Resolution(width, height);
    }

    @NotNull
    public final @NotNull Iterable<@NotNull String> getAbis() {
        return this.myAbis;
    }

    @Nullable
    public final StorageDevice getStorageDevice() {
        return this.myStorageDevice;
    }

    @NotNull
    public final String toString() {
        return this.myName;
    }

    protected static abstract class Builder {
        @Nullable
        protected Key myKey;
        @NotNull
        protected DeviceType myType = DeviceType.PHONE;
        @Nullable
        protected String myName;
        @Nullable
        protected String myTarget;
        @NotNull
        protected AndroidVersion myAndroidVersion = AndroidVersion.DEFAULT;
        @Nullable
        protected Resolution myResolution;
        protected int myDensity = -1;
        @NotNull
        protected final @NotNull Collection<@NotNull String> myAbis = new ArrayList<String>();
        @Nullable
        protected StorageDevice myStorageDevice;

        protected Builder() {
        }

        @NotNull
        protected abstract Device build();
    }
}

