/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.idea.devicemanager.DetailsPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Optional;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DetailsPanelPanel
extends JBPanel<DetailsPanelPanel>
implements Disposable {
    @NotNull
    private final JComponent myScrollPane;
    @Nullable
    private Disposable myDetailsPanel;
    @Nullable
    private Splitter mySplitter;

    DetailsPanelPanel(@NotNull JComponent scrollPane) {
        super((LayoutManager)new BorderLayout());
        this.myScrollPane = scrollPane;
        this.add(scrollPane);
    }

    public void dispose() {
        if (this.myDetailsPanel != null) {
            Disposer.dispose((Disposable)this.myDetailsPanel);
        }
    }

    void viewDetails(@NotNull DetailsPanel detailsPanel2) {
        if (this.mySplitter != null) {
            assert (this.myDetailsPanel != null);
            Disposer.dispose((Disposable)this.myDetailsPanel);
            this.myDetailsPanel = detailsPanel2;
            this.mySplitter.setSecondComponent((JComponent)((Object)detailsPanel2));
            return;
        }
        this.myDetailsPanel = detailsPanel2;
        this.remove(this.myScrollPane);
        this.mySplitter = new JBSplitter(true);
        this.mySplitter.setFirstComponent(this.myScrollPane);
        this.mySplitter.setSecondComponent((JComponent)((Object)detailsPanel2));
        this.add((Component)this.mySplitter);
        this.revalidate();
    }

    public void removeSplitter() {
        this.remove((Component)this.mySplitter);
        this.mySplitter = null;
        assert (this.myDetailsPanel != null);
        Disposer.dispose((Disposable)this.myDetailsPanel);
        this.myDetailsPanel = null;
        this.add(this.myScrollPane);
        this.revalidate();
    }

    @VisibleForTesting
    @NotNull
    @NotNull Optional<@NotNull Object> getDetailsPanel() {
        return Optional.ofNullable(this.myDetailsPanel);
    }

    @NotNull
    @NotNull Optional<@NotNull Splitter> getSplitter() {
        return Optional.ofNullable(this.mySplitter);
    }
}

