/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.idea.devicemanager.IconButton;
import com.android.tools.idea.devicemanager.PairedDevicesPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailsPanel
extends JBPanel<DetailsPanel>
implements Disposable {
    static final int DEVICE_INFO_TAB_INDEX = 0;
    public static final int PAIRED_DEVICES_TAB_INDEX = 1;
    @NotNull
    private final Component myHeadingLabel;
    @NotNull
    private final AbstractButton myCloseButton;
    @Nullable
    protected Component mySummarySection;
    @Nullable
    protected Component myScreenDiagram;
    @Nullable
    private AbstractButton myCopyPropertiesToClipboardButton;
    @NotNull
    protected final @NotNull List<@NotNull Component> myInfoSections;
    @NotNull
    protected final Container myInfoSectionPanel;
    @NotNull
    private final Component myScrollPane;
    @Nullable
    protected PairedDevicesPanel myPairedDevicesPanel;
    @Nullable
    private JBTabbedPane myTabbedPane;
    @NotNull
    private final @NotNull Supplier<@NotNull Toolkit> myGetDefaultToolkit;

    protected DetailsPanel(@NotNull String heading) {
        this(heading, Toolkit::getDefaultToolkit);
    }

    @VisibleForTesting
    DetailsPanel(@NotNull String heading, @NotNull @NotNull Supplier<@NotNull Toolkit> getDefaultToolkit) {
        super(null);
        this.myHeadingLabel = DetailsPanel.newHeadingLabel(heading);
        this.myCloseButton = new IconButton(StudioIcons.Common.CLOSE);
        this.myInfoSections = new ArrayList<Component>();
        this.myInfoSectionPanel = new JBPanel(null);
        this.myInfoSectionPanel.setBackground(JBUI.CurrentTheme.Table.BACKGROUND);
        this.myScrollPane = new JBScrollPane((Component)this.myInfoSectionPanel);
        this.myGetDefaultToolkit = getDefaultToolkit;
    }

    public void dispose() {
    }

    @NotNull
    static JLabel newHeadingLabel(@NotNull String heading) {
        JBLabel label = new JBLabel(heading);
        label.setFont(label.getFont().deriveFont(1));
        return label;
    }

    protected final void init() {
        this.initSummarySection();
        this.initCopyPropertiesToClipboardButton();
        this.setInfoSectionPanelLayout();
        this.initTabbedPane();
        this.setLayout();
    }

    protected void initSummarySection() {
    }

    private void initCopyPropertiesToClipboardButton() {
        if (this.myInfoSections.isEmpty()) {
            return;
        }
        Color foreground = JBUI.CurrentTheme.Label.disabledForeground();
        Icon icon2 = ColoredIconGenerator.INSTANCE.generateColoredIcon(AllIcons.Actions.Copy, foreground);
        this.myCopyPropertiesToClipboardButton = new JButton("Copy properties to clipboard", icon2);
        this.myCopyPropertiesToClipboardButton.setBorder(null);
        this.myCopyPropertiesToClipboardButton.setContentAreaFilled(false);
        this.myCopyPropertiesToClipboardButton.setCursor(Cursor.getPredefinedCursor(12));
        this.myCopyPropertiesToClipboardButton.setForeground(foreground);
        int gap = this.myCopyPropertiesToClipboardButton.getIconTextGap();
        Dimension size = BasicGraphicsUtils.getPreferredButtonSize(this.myCopyPropertiesToClipboardButton, gap);
        this.myCopyPropertiesToClipboardButton.setMaximumSize(size);
        this.myCopyPropertiesToClipboardButton.setMinimumSize(size);
        this.myCopyPropertiesToClipboardButton.setPreferredSize(size);
        this.myCopyPropertiesToClipboardButton.addActionListener(event -> this.copyPropertiesToClipboard());
    }

    private void copyPropertiesToClipboard() {
        StringBuilder builder2 = new StringBuilder(this.myInfoSections.get(0).toString());
        String separator = System.lineSeparator();
        this.myInfoSections.subList(1, this.myInfoSections.size()).forEach(section -> builder2.append(separator).append(section));
        this.myGetDefaultToolkit.get().getSystemClipboard().setContents(new StringSelection(builder2.toString()), null);
    }

    protected void setInfoSectionPanelLayout() {
        GroupLayout layout = new GroupLayout(this.myInfoSectionPanel);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup();
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        if (this.myScreenDiagram == null) {
            ((GroupLayout.Group)horizontalGroup).addComponent(this.mySummarySection);
            verticalGroup.addComponent(this.mySummarySection);
        } else {
            ((GroupLayout.Group)horizontalGroup).addGroup(layout.createSequentialGroup().addComponent(this.mySummarySection).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myScreenDiagram));
            verticalGroup.addGroup(layout.createParallelGroup().addComponent(this.mySummarySection).addComponent(this.myScreenDiagram));
        }
        if (!this.myInfoSections.isEmpty()) {
            ((GroupLayout.Group)horizontalGroup).addComponent(this.myCopyPropertiesToClipboardButton);
            verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.myCopyPropertiesToClipboardButton);
        }
        this.myInfoSections.forEach(section -> {
            horizontalGroup.addComponent((Component)section);
            verticalGroup.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)section);
        });
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.myInfoSectionPanel.setLayout(layout);
    }

    private void initTabbedPane() {
        if (this.myPairedDevicesPanel == null) {
            return;
        }
        this.myTabbedPane = new JBTabbedPane();
        this.myTabbedPane.setTabComponentInsets((Insets)JBUI.emptyInsets());
        this.myTabbedPane.insertTab("Device Info", null, this.myScrollPane, null, 0);
        this.myTabbedPane.insertTab("Paired Devices", null, (Component)((Object)this.myPairedDevicesPanel), null, 1);
    }

    private void setLayout() {
        Component component2 = this.myPairedDevicesPanel == null ? this.myScrollPane : this.myTabbedPane;
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.myHeadingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.myCloseButton).addContainerGap()).addComponent(component2);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myHeadingLabel).addComponent(this.myCloseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(component2);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.setLayout(layout);
    }

    @NotNull
    public final AbstractButton getCloseButton() {
        return this.myCloseButton;
    }

    @VisibleForTesting
    @NotNull
    final AbstractButton getCopyPropertiesToClipboardButton() {
        assert (this.myCopyPropertiesToClipboardButton != null);
        return this.myCopyPropertiesToClipboardButton;
    }

    @VisibleForTesting
    @NotNull
    public final Container getInfoSectionPanel() {
        return this.myInfoSectionPanel;
    }

    @NotNull
    final @NotNull Optional<@NotNull PairedDevicesPanel> getPairedDevicesPanel() {
        return Optional.ofNullable(this.myPairedDevicesPanel);
    }

    @NotNull
    final @NotNull Optional<@NotNull JTabbedPane> getTabbedPane() {
        return Optional.ofNullable(this.myTabbedPane);
    }
}

