/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.adb.AdbShellCommandResult;
import com.android.tools.idea.adb.AdbShellCommandsUtil;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class AdbShellCommandExecutor {
    @NotNull
    public @NotNull Optional<@NotNull List<@NotNull String>> execute(@NotNull IDevice device2, @NotNull String command2) {
        try {
            return AdbShellCommandExecutor.getOutput(AdbShellCommandsUtil.create(device2).executeCommandBlocking(command2));
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException exception) {
            Logger.getInstance(AdbShellCommandExecutor.class).warn(exception);
            return Optional.empty();
        }
    }

    @NotNull
    private static @NotNull Optional<@NotNull List<@NotNull String>> getOutput(@NotNull AdbShellCommandResult result2) {
        List<String> output = result2.getOutput();
        if (result2.isError()) {
            String separator = System.lineSeparator();
            StringBuilder builder2 = new StringBuilder("Command failed:").append(separator);
            output.forEach(line2 -> builder2.append((String)line2).append(separator));
            Logger.getInstance(AdbShellCommandExecutor.class).warn(builder2.toString());
            return Optional.empty();
        }
        return Optional.of(output);
    }
}

