/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.monitor.ui;

import com.android.ddmlib.ClientData;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.device.monitor.ProcessInfoTreeNode;
import com.android.tools.idea.device.monitor.processes.ProcessInfoKt;
import com.android.tools.idea.device.monitor.ui.ProcessListTreeBuilder;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0007\u0007\b\t\n\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ProcessListTreeBuilder;", "", "()V", "build", "Ljavax/swing/JComponent;", "myTree", "Lcom/intellij/ui/treeStructure/Tree;", "AbiRenderer", "NameRenderer", "PidRenderer", "StatusRenderer", "SupportsNativeDebuggingRenderer", "UserIdRenderer", "VmIdentifierRenderer", "intellij.android.device-monitor-toolwindow"})
public final class ProcessListTreeBuilder {
    @NotNull
    public final JComponent build(@NotNull Tree myTree) {
        Intrinsics.checkNotNullParameter((Object)myTree, (String)"myTree");
        TreeSpeedSearch treeSpeedSearch2 = new TreeSpeedSearch(myTree, (Convertor)build.treeSpeedSearch.1.INSTANCE, true);
        ColumnTreeBuilder columnTreeBuilder = new ColumnTreeBuilder((JTree)myTree).setBackground(UIUtil.getTreeBackground()).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Process Name").setPreferredWidth(JBUI.scale((int)600)).setHeaderAlignment(0).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new NameRenderer(treeSpeedSearch2))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("PID").setPreferredWidth(JBUI.scale((int)150)).setHeaderAlignment(0).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new PidRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("ABI").setPreferredWidth(JBUI.scale((int)200)).setHeaderAlignment(0).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new AbiRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("VM").setPreferredWidth(JBUI.scale((int)200)).setHeaderAlignment(0).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new VmIdentifierRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("User ID").setPreferredWidth(JBUI.scale((int)100)).setHeaderAlignment(0).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new UserIdRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Debugger").setPreferredWidth(JBUI.scale((int)100)).setHeaderAlignment(0).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new StatusRenderer())).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Native").setPreferredWidth(JBUI.scale((int)100)).setHeaderAlignment(0).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SupportsNativeDebuggingRenderer()));
        Intrinsics.checkNotNullExpressionValue((Object)columnTreeBuilder, (String)"ColumnTreeBuilder(myTree\u2026uggingRenderer())\n      )");
        ColumnTreeBuilder builder2 = columnTreeBuilder;
        JComponent jComponent = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"builder.build()");
        return jComponent;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ProcessListTreeBuilder$NameRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "mySpeedSearch", "Lcom/intellij/ui/TreeSpeedSearch;", "(Lcom/intellij/ui/TreeSpeedSearch;)V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "Companion", "intellij.android.device-monitor-toolwindow"})
    public static final class NameRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final TreeSpeedSearch mySpeedSearch;

        public NameRenderer(@NotNull TreeSpeedSearch mySpeedSearch) {
            Intrinsics.checkNotNullParameter((Object)mySpeedSearch, (String)"mySpeedSearch");
            this.mySpeedSearch = mySpeedSearch;
        }

        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
                this.setToolTipText(null);
                this.setIcon(null);
                this.setIpad((Insets)JBUI.insets((int)0, (int)0, (int)0, (int)6));
                ProcessInfoTreeNode processInfoTreeNode = ProcessInfoTreeNode.Companion.fromNode(value2);
                if (processInfoTreeNode == null) break block2;
                ProcessInfoTreeNode node = processInfoTreeNode;
                boolean bl = false;
                this.setIcon(NameRenderer.Companion.getIconFor(node));
                if (ProcessInfoKt.isPidOnly(node.getProcessInfo())) {
                    this.append(ProcessInfoKt.getSafeProcessName(node.getProcessInfo()), SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)node.getProcessInfo().getProcessName(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)((SimpleColoredComponent)this));
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ProcessListTreeBuilder$NameRenderer$Companion;", "", "()V", "getIconFor", "Ljavax/swing/Icon;", "node", "Lcom/android/tools/idea/device/monitor/ProcessInfoTreeNode;", "intellij.android.device-monitor-toolwindow"})
        public static final class Companion {
            private Companion() {
            }

            private final Icon getIconFor(ProcessInfoTreeNode node) {
                Icon icon2 = StudioIcons.Shell.Filetree.ACTIVITY;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ACTIVITY");
                return icon2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ProcessListTreeBuilder$PidRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.android.device-monitor-toolwindow"})
    public static final class PidRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            ProcessInfoTreeNode processInfoTreeNode = ProcessInfoTreeNode.Companion.fromNode(value2);
            if (processInfoTreeNode != null) {
                ProcessInfoTreeNode it = processInfoTreeNode;
                boolean bl = false;
                this.append(String.valueOf(it.getProcessInfo().getPid()));
                this.setTextAlign(11);
            }
            this.setIpad((Insets)JBUI.insets((int)0, (int)6, (int)0, (int)6));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ProcessListTreeBuilder$AbiRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.android.device-monitor-toolwindow"})
    public static final class AbiRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            SimpleColoredComponent simpleColoredComponent;
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            ProcessInfoTreeNode processInfoTreeNode = ProcessInfoTreeNode.Companion.fromNode(value2);
            if (processInfoTreeNode != null) {
                ProcessInfoTreeNode it = processInfoTreeNode;
                boolean bl = false;
                if (ProcessInfoKt.isPidOnly(it.getProcessInfo())) {
                    simpleColoredComponent = this.append("-");
                } else {
                    String string = it.getProcessInfo().getAbi();
                    if (string == null) {
                        string = "-";
                    }
                    simpleColoredComponent = this.append(string);
                }
            } else {
                simpleColoredComponent = null;
            }
            this.setIpad((Insets)JBUI.insets((int)0, (int)6, (int)0, (int)6));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ProcessListTreeBuilder$StatusRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.android.device-monitor-toolwindow"})
    public static final class StatusRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            SimpleColoredComponent simpleColoredComponent;
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            ProcessInfoTreeNode processInfoTreeNode = ProcessInfoTreeNode.Companion.fromNode(value2);
            if (processInfoTreeNode != null) {
                ProcessInfoTreeNode it = processInfoTreeNode;
                boolean bl = false;
                if (ProcessInfoKt.isPidOnly(it.getProcessInfo())) {
                    simpleColoredComponent = this.append("-");
                } else {
                    String string;
                    switch (WhenMappings.$EnumSwitchMapping$0[it.getProcessInfo().getDebuggerStatus().ordinal()]) {
                        case 1: {
                            string = "No";
                            break;
                        }
                        case 2: {
                            string = "Waiting";
                            break;
                        }
                        case 3: {
                            string = "Attached";
                            break;
                        }
                        case 4: {
                            string = "<Error>";
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    String status2 = string;
                    simpleColoredComponent = this.append(status2);
                }
            } else {
                simpleColoredComponent = null;
            }
            this.setIpad((Insets)JBUI.insets((int)0, (int)6, (int)0, (int)6));
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ClientData.DebuggerStatus.values().length];
                nArray[ClientData.DebuggerStatus.DEFAULT.ordinal()] = 1;
                nArray[ClientData.DebuggerStatus.WAITING.ordinal()] = 2;
                nArray[ClientData.DebuggerStatus.ATTACHED.ordinal()] = 3;
                nArray[ClientData.DebuggerStatus.ERROR.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ProcessListTreeBuilder$SupportsNativeDebuggingRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.android.device-monitor-toolwindow"})
    public static final class SupportsNativeDebuggingRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            ProcessInfoTreeNode processInfoTreeNode = ProcessInfoTreeNode.Companion.fromNode(value2);
            if (processInfoTreeNode != null) {
                ProcessInfoTreeNode it = processInfoTreeNode;
                boolean bl = false;
                if (ProcessInfoKt.isPidOnly(it.getProcessInfo())) {
                    this.append("-");
                } else {
                    this.append(it.getProcessInfo().getSupportsNativeDebugging() ? "Yes" : "No");
                }
                this.setTextAlign(0);
            }
            this.setIpad((Insets)JBUI.insets((int)0, (int)6, (int)0, (int)6));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ProcessListTreeBuilder$UserIdRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.android.device-monitor-toolwindow"})
    public static final class UserIdRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            ProcessInfoTreeNode processInfoTreeNode = ProcessInfoTreeNode.Companion.fromNode(value2);
            if (processInfoTreeNode != null) {
                ProcessInfoTreeNode it = processInfoTreeNode;
                boolean bl = false;
                if (ProcessInfoKt.isPidOnly(it.getProcessInfo())) {
                    this.append("-");
                } else {
                    Object object = it.getProcessInfo().getUserId();
                    if (object == null || (object = ((Integer)object).toString()) == null) {
                        object = "n/a";
                    }
                    this.append((String)object);
                }
                this.setTextAlign(11);
            }
            this.setIpad((Insets)JBUI.insets((int)0, (int)6, (int)0, (int)6));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ProcessListTreeBuilder$VmIdentifierRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.android.device-monitor-toolwindow"})
    public static final class VmIdentifierRenderer
    extends ColoredTreeCellRenderer {
        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            SimpleColoredComponent simpleColoredComponent;
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            ProcessInfoTreeNode processInfoTreeNode = ProcessInfoTreeNode.Companion.fromNode(value2);
            if (processInfoTreeNode != null) {
                ProcessInfoTreeNode it = processInfoTreeNode;
                boolean bl = false;
                if (ProcessInfoKt.isPidOnly(it.getProcessInfo())) {
                    simpleColoredComponent = this.append("-");
                } else {
                    String string = it.getProcessInfo().getVmIdentifier();
                    if (string == null) {
                        string = "-";
                    }
                    simpleColoredComponent = this.append(string);
                }
            } else {
                simpleColoredComponent = null;
            }
            this.setIpad((Insets)JBUI.insets((int)0, (int)6, (int)0, (int)6));
        }
    }
}

