/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.monitor.ui;

import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.device.monitor.DeviceMonitorModel;
import com.android.tools.idea.device.monitor.DeviceMonitorModelListener;
import com.android.tools.idea.device.monitor.DeviceMonitorProgressListener;
import com.android.tools.idea.device.monitor.DeviceMonitorView;
import com.android.tools.idea.device.monitor.DeviceMonitorViewListener;
import com.android.tools.idea.device.monitor.DeviceNameRendererFactory;
import com.android.tools.idea.device.monitor.ProcessTreeNode;
import com.android.tools.idea.device.monitor.processes.Device;
import com.android.tools.idea.device.monitor.processes.DeviceListService;
import com.android.tools.idea.device.monitor.processes.DeviceRenderer;
import com.android.tools.idea.device.monitor.ui.ComponentPopupMenu;
import com.android.tools.idea.device.monitor.ui.DeviceMonitorActionsListener;
import com.android.tools.idea.device.monitor.ui.DeviceMonitorPanel;
import com.android.tools.idea.device.monitor.ui.DeviceMonitorViewImpl;
import com.android.tools.idea.device.monitor.ui.menu.item.ForceStopMenuItem;
import com.android.tools.idea.device.monitor.ui.menu.item.KillMenuItem;
import com.android.tools.idea.device.monitor.ui.menu.item.MenuContext;
import com.android.tools.idea.device.monitor.ui.menu.item.RefreshMenuItem;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.treeStructure.Tree;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 H2\u00020\u00012\u00020\u0002:\u0002HIB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020!H\u0002J\u0018\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020!H\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\u001dH\u0016J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u001dH\u0002J\u0016\u0010.\u001a\u00020!2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0010\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010201H\u0007J\b\u00103\u001a\u000204H\u0007J\u0016\u00105\u001a\u00020!2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0016\u00106\u001a\u00020!2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0010\u00107\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0018\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020;H\u0016J \u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020>2\u0006\u00109\u001a\u00020(2\u0006\u0010:\u001a\u00020;H\u0016J\u0018\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u0002022\u0006\u00109\u001a\u00020(H\u0016J\b\u0010A\u001a\u00020!H\u0016J\b\u0010B\u001a\u00020!H\u0002J\b\u0010C\u001a\u00020!H\u0016J\b\u0010D\u001a\u00020!H\u0016J\u0010\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020(H\u0016J\b\u0010G\u001a\u00020!H\u0016R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006J"}, d2={"Lcom/android/tools/idea/device/monitor/ui/DeviceMonitorViewImpl;", "Lcom/android/tools/idea/device/monitor/DeviceMonitorView;", "Lcom/android/tools/idea/device/monitor/ui/DeviceMonitorActionsListener;", "project", "Lcom/intellij/openapi/project/Project;", "rendererFactory", "Lcom/android/tools/idea/device/monitor/DeviceNameRendererFactory;", "model", "Lcom/android/tools/idea/device/monitor/DeviceMonitorModel;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/device/monitor/DeviceNameRendererFactory;Lcom/android/tools/idea/device/monitor/DeviceMonitorModel;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "getLoadingPanel", "()Lcom/intellij/ui/components/JBLoadingPanel;", "myDeviceRenderer", "Lcom/android/tools/idea/device/monitor/processes/DeviceRenderer;", "myListeners", "", "Lcom/android/tools/idea/device/monitor/DeviceMonitorViewListener;", "myPanel", "Lcom/android/tools/idea/device/monitor/ui/DeviceMonitorPanel;", "myProgressListeners", "Lcom/android/tools/idea/device/monitor/DeviceMonitorProgressListener;", "selectedNodes", "", "Lcom/android/tools/idea/device/monitor/ProcessTreeNode;", "getSelectedNodes", "()Ljava/util/List;", "addListener", "", "listener", "createToolbar", "createToolbarSubSection", "group", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "layoutPosition", "", "createTreePopupMenu", "expandNode", "treeNode", "expandTreeNode", "node", "forceStopNodes", "treeNodes", "getDeviceCombo", "Ljavax/swing/JComboBox;", "Lcom/android/tools/idea/device/monitor/processes/Device;", "getTree", "Lcom/intellij/ui/treeStructure/Tree;", "killNodes", "refreshNodes", "removeListener", "reportErrorGeneric", "message", "t", "", "reportErrorRelatedToService", "service", "Lcom/android/tools/idea/device/monitor/processes/DeviceListService;", "reportMessageRelatedToDevice", "fileSystem", "setup", "setupPanel", "showActiveDeviceScreen", "showNoDeviceScreen", "startRefresh", "text", "stopRefresh", "Companion", "ModelListener", "intellij.android.device-monitor-toolwindow"})
public final class DeviceMonitorViewImpl
implements DeviceMonitorView,
DeviceMonitorActionsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DeviceMonitorViewListener> myListeners;
    @NotNull
    private final List<DeviceMonitorProgressListener> myProgressListeners;
    @NotNull
    private final DeviceRenderer myDeviceRenderer;
    @NotNull
    private final DeviceMonitorPanel myPanel;
    @NotNull
    private final JBLoadingPanel loadingPanel;

    public DeviceMonitorViewImpl(@NotNull Project project, @NotNull DeviceNameRendererFactory rendererFactory, @NotNull DeviceMonitorModel model2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rendererFactory, (String)"rendererFactory");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.myListeners = new ArrayList();
        this.myProgressListeners = new ArrayList();
        this.myPanel = new DeviceMonitorPanel();
        model2.addListener(new ModelListener());
        this.myDeviceRenderer = rendererFactory.create(new DeviceNamePropertiesFetcher((Disposable)project, (FutureCallback<DeviceNameProperties>)((FutureCallback)new FutureCallback<DeviceNameProperties>(){

            public void onSuccess(@NotNull DeviceNameProperties result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                myPanel.getDeviceCombo().updateUI();
            }

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                logger2.warn("Error retrieving device name properties", t);
            }
        })));
        this.myPanel.setCancelActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = myProgressListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DeviceMonitorProgressListener it2 = (DeviceMonitorProgressListener)element$iv;
                    boolean bl = false;
                    it2.cancellationRequested();
                }
            }
        });
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
    }

    @TestOnly
    @NotNull
    public final JBLoadingPanel getLoadingPanel() {
        return this.loadingPanel;
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.loadingPanel;
    }

    @TestOnly
    @NotNull
    public final JComboBox<Device> getDeviceCombo() {
        JComboBox<Device> jComboBox = this.myPanel.getDeviceCombo();
        Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"myPanel.deviceCombo");
        return jComboBox;
    }

    @TestOnly
    @NotNull
    public final Tree getTree() {
        Tree tree2 = this.myPanel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"myPanel.tree");
        return tree2;
    }

    @Override
    public void addListener(@NotNull DeviceMonitorViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myListeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceMonitorViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.myListeners.remove(listener2);
    }

    @Override
    public void setup() {
        this.setupPanel();
    }

    @Override
    public void reportErrorRelatedToService(@NotNull DeviceListService service, @NotNull String message2, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Object errorMessage = message2;
        if (t.getMessage() != null) {
            errorMessage = (String)errorMessage + ": " + t.getMessage();
        }
        this.myPanel.showErrorMessageLayer((String)errorMessage, false);
    }

    @Override
    public void reportErrorGeneric(@NotNull String message2, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        DeviceMonitorViewImpl.Companion.reportError(message2, t);
    }

    @Override
    public void reportMessageRelatedToDevice(@NotNull Device fileSystem, @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        this.myPanel.showMessageLayer(message2, true);
    }

    @Override
    public void refreshNodes(@NotNull List<? extends ProcessTreeNode> treeNodes) {
        Intrinsics.checkNotNullParameter(treeNodes, (String)"treeNodes");
        this.myListeners.forEach(refreshNodes.1.INSTANCE);
    }

    @Override
    public void killNodes(@NotNull List<? extends ProcessTreeNode> treeNodes) {
        Intrinsics.checkNotNullParameter(treeNodes, (String)"treeNodes");
        this.myListeners.forEach(new Consumer(treeNodes){
            final /* synthetic */ List<ProcessTreeNode> $treeNodes;
            {
                this.$treeNodes = $treeNodes;
            }

            public final void accept(@NotNull DeviceMonitorViewListener x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                x.killNodesInvoked(this.$treeNodes);
            }
        });
    }

    @Override
    public void forceStopNodes(@NotNull List<? extends ProcessTreeNode> treeNodes) {
        Intrinsics.checkNotNullParameter(treeNodes, (String)"treeNodes");
        this.myListeners.forEach(new Consumer(treeNodes){
            final /* synthetic */ List<ProcessTreeNode> $treeNodes;
            {
                this.$treeNodes = $treeNodes;
            }

            public final void accept(@NotNull DeviceMonitorViewListener x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                x.forceStopNodesInvoked(this.$treeNodes);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<ProcessTreeNode> getSelectedNodes() {
        Collection collection2;
        void $this$mapNotNullTo$iv$iv;
        TreePath[] paths;
        TreePath[] treePathArray = this.myPanel.getTree().getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        TreePath[] $this$mapNotNull$iv = paths = treePathArray;
        boolean $i$f$mapNotNull = false;
        TreePath[] treePathArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            ProcessTreeNode it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void path2 = element$iv$iv;
            boolean bl2 = false;
            if (ProcessTreeNode.Companion.fromNode(path2.getLastPathComponent()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nodes = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Collection collection3 = nodes;
        if (collection3.isEmpty()) {
            boolean bl = false;
            collection2 = null;
        } else {
            collection2 = collection3;
        }
        return (List)collection2;
    }

    private final void setupPanel() {
        this.loadingPanel.add((Component)this.myPanel.getComponent(), (Object)"Center");
        this.myPanel.getDeviceCombo().setRenderer(this.myDeviceRenderer.getNameRenderer());
        this.myPanel.getDeviceCombo().addActionListener(new ActionListener(this){
            final /* synthetic */ DeviceMonitorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                Object sel = DeviceMonitorViewImpl.access$getMyPanel$p(this.this$0).getDeviceCombo().getSelectedItem();
                if (sel instanceof Device) {
                    DeviceMonitorViewImpl.access$getMyListeners$p(this.this$0).forEach(new Consumer(sel){
                        final /* synthetic */ Object $sel;
                        {
                            this.$sel = $sel;
                        }

                        public final void accept(@NotNull DeviceMonitorViewListener x) {
                            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                            Object object = this.$sel;
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sel");
                            x.deviceSelected((Device)object);
                        }
                    });
                } else {
                    DeviceMonitorViewImpl.access$getMyListeners$p(this.this$0).forEach((Consumer)setupPanel.2.INSTANCE);
                }
            }
        });
        Tree tree2 = this.myPanel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"myPanel.tree");
        Tree tree3 = tree2;
        tree3.addTreeWillExpandListener(new TreeWillExpandListener(this){
            final /* synthetic */ DeviceMonitorViewImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void treeWillExpand(@NotNull TreeExpansionEvent event) throws ExpandVetoException {
                block0: {
                    ProcessTreeNode node;
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    ProcessTreeNode processTreeNode = node = ProcessTreeNode.Companion.fromNode(event.getPath().getLastPathComponent());
                    if (processTreeNode == null) break block0;
                    ProcessTreeNode processTreeNode2 = processTreeNode;
                    DeviceMonitorViewImpl deviceMonitorViewImpl = this.this$0;
                    ProcessTreeNode it = processTreeNode2;
                    boolean bl = false;
                    DeviceMonitorViewImpl.access$expandTreeNode(deviceMonitorViewImpl, it);
                }
            }

            public void treeWillCollapse(@NotNull TreeExpansionEvent event) throws ExpandVetoException {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }
        });
        this.createTreePopupMenu();
        this.createToolbar();
        this.loadingPanel.setLoadingText("Initializing ADB");
        this.loadingPanel.startLoading();
    }

    private final void createTreePopupMenu() {
        ComponentPopupMenu componentPopupMenu;
        Tree tree2 = this.myPanel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"myPanel.tree");
        ComponentPopupMenu $this$createTreePopupMenu_u24lambda_u2d2 = componentPopupMenu = new ComponentPopupMenu((JComponent)tree2);
        boolean bl = false;
        $this$createTreePopupMenu_u24lambda_u2d2.addItem(new ForceStopMenuItem(this, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u2d2.addItem(new KillMenuItem(this, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u2d2.install();
    }

    /*
     * WARNING - void declaration
     */
    private final void createToolbar() {
        void $this$createToolbar_u24lambda_u2d4;
        DefaultActionGroup $this$createToolbar_u24lambda_u2d3;
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup = new DefaultActionGroup();
        DeviceMonitorViewImpl deviceMonitorViewImpl = this;
        boolean bl = false;
        $this$createToolbar_u24lambda_u2d3.add(new ForceStopMenuItem(this, MenuContext.Toolbar).getAction());
        $this$createToolbar_u24lambda_u2d3.add(new KillMenuItem(this, MenuContext.Toolbar).getAction());
        deviceMonitorViewImpl.createToolbarSubSection(defaultActionGroup, "West");
        $this$createToolbar_u24lambda_u2d3 = defaultActionGroup = new DefaultActionGroup();
        deviceMonitorViewImpl = this;
        boolean bl2 = false;
        $this$createToolbar_u24lambda_u2d4.add(new RefreshMenuItem(this).getAction());
        deviceMonitorViewImpl.createToolbarSubSection(defaultActionGroup, "East");
    }

    private final void createToolbarSubSection(DefaultActionGroup group2, String layoutPosition) {
        ActionToolbar actionToolbar;
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar $this$createToolbarSubSection_u24lambda_u2d5 = actionToolbar = actionManager.createActionToolbar("Device Monitor Toolbar", (ActionGroup)group2, true);
        boolean bl = false;
        $this$createToolbarSubSection_u24lambda_u2d5.setTargetComponent((JComponent)this.myPanel.getTree());
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"actionManager.createActi\u2026nent = myPanel.tree\n    }");
        ActionToolbar actionToolbar3 = actionToolbar2;
        this.myPanel.getToolbarPanel().add((Component)actionToolbar3.getComponent(), layoutPosition);
    }

    @Override
    public void startRefresh(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.myPanel.showMessageLayer("", false);
        this.loadingPanel.setLoadingText(text2);
        this.loadingPanel.startLoading();
    }

    @Override
    public void stopRefresh() {
        this.loadingPanel.stopLoading();
    }

    @Override
    public void showNoDeviceScreen() {
        this.myPanel.showMessageLayer("Connect a device via USB cable or run an Android Virtual Device", AndroidIcons.DeviceExplorer.DevicesLineup, false);
    }

    @Override
    public void showActiveDeviceScreen() {
        this.myPanel.showTree();
    }

    @Override
    public void expandNode(@NotNull ProcessTreeNode treeNode) {
        Intrinsics.checkNotNullParameter((Object)treeNode, (String)"treeNode");
        this.myPanel.getTree().expandPath(new TreePath(treeNode.getPath()));
    }

    private final void expandTreeNode(ProcessTreeNode node) {
        this.myListeners.forEach(new Consumer(node){
            final /* synthetic */ ProcessTreeNode $node;
            {
                this.$node = $node;
            }

            public final void accept(@NotNull DeviceMonitorViewListener x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                x.treeNodeExpanding(this.$node);
            }
        });
    }

    public static final /* synthetic */ List access$getMyListeners$p(DeviceMonitorViewImpl $this) {
        return $this.myListeners;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u001c\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/device/monitor/ui/DeviceMonitorViewImpl$ModelListener;", "Lcom/android/tools/idea/device/monitor/DeviceMonitorModelListener;", "(Lcom/android/tools/idea/device/monitor/ui/DeviceMonitorViewImpl;)V", "activeDeviceChanged", "", "newActiveDevice", "Lcom/android/tools/idea/device/monitor/processes/Device;", "allDevicesRemoved", "deviceAdded", "device", "deviceRemoved", "deviceUpdated", "setRootFolder", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "treeSelectionModel", "Ljavax/swing/tree/DefaultTreeSelectionModel;", "treeModelChanged", "newTreeModel", "newTreeSelectionModel", "intellij.android.device-monitor-toolwindow"})
    private final class ModelListener
    implements DeviceMonitorModelListener {
        @Override
        public void allDevicesRemoved() {
            DeviceMonitorViewImpl.this.myPanel.getDeviceCombo().removeAllItems();
        }

        @Override
        public void deviceAdded(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            DeviceMonitorViewImpl.this.myPanel.getDeviceCombo().addItem(device2);
        }

        @Override
        public void deviceRemoved(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            DeviceMonitorViewImpl.this.myPanel.getDeviceCombo().removeItem(device2);
        }

        @Override
        public void deviceUpdated(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            if (DeviceMonitorViewImpl.this.myPanel.getDeviceCombo().getSelectedItem() == device2) {
                DeviceMonitorViewImpl.this.myPanel.getDeviceCombo().repaint();
            }
        }

        @Override
        public void activeDeviceChanged(@Nullable Device newActiveDevice) {
            if (newActiveDevice != null && !Intrinsics.areEqual((Object)newActiveDevice, (Object)DeviceMonitorViewImpl.this.myPanel.getDeviceCombo().getSelectedItem())) {
                DeviceMonitorViewImpl.this.myPanel.getDeviceCombo().setSelectedItem(newActiveDevice);
            }
        }

        @Override
        public void treeModelChanged(@Nullable DefaultTreeModel newTreeModel, @Nullable DefaultTreeSelectionModel newTreeSelectionModel) {
            this.setRootFolder(newTreeModel, newTreeSelectionModel);
        }

        private final void setRootFolder(DefaultTreeModel treeModel, DefaultTreeSelectionModel treeSelectionModel) {
            Tree tree2 = DeviceMonitorViewImpl.this.myPanel.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"myPanel.tree");
            Tree tree3 = tree2;
            tree3.setModel((TreeModel)treeModel);
            tree3.setSelectionModel((TreeSelectionModel)treeSelectionModel);
            if (treeModel != null) {
                DeviceMonitorViewImpl.this.myPanel.showTree();
                ProcessTreeNode rootNode = ProcessTreeNode.Companion.fromNode(treeModel.getRoot());
                if (rootNode != null) {
                    tree3.setRootVisible(false);
                    DeviceMonitorViewImpl.this.expandTreeNode(rootNode);
                } else {
                    tree3.setRootVisible(true);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/monitor/ui/DeviceMonitorViewImpl$Companion;", "", "()V", "reportError", "", "message", "", "t", "", "intellij.android.device-monitor-toolwindow"})
    public static final class Companion {
        private Companion() {
        }

        private final void reportError(String message2, Throwable t) {
            if (t instanceof CancellationException) {
                return;
            }
            Object errorMessage = message2;
            if (t.getMessage() != null) {
                errorMessage = (String)errorMessage + ": " + t.getMessage();
            }
            Notification notification = new Notification("Device Monitor", "Device Monitor", (String)errorMessage, NotificationType.WARNING);
            ApplicationManager.getApplication().invokeLater(new Runnable(notification){
                final /* synthetic */ Notification $notification;
                {
                    this.$notification = $notification;
                }

                public final void run() {
                    Notifications.Bus.notify((Notification)this.$notification);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

