/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.monitor.ui;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.device.monitor.processes.Device;
import com.android.tools.idea.device.monitor.ui.ProcessListTreeBuilder;
import com.android.tools.idea.device.monitor.ui.ProgressPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceMonitorPanel {
    static final int TEXT_RENDERER_HORIZ_PADDING = 6;
    static final int TEXT_RENDERER_VERT_PADDING = 4;
    private JComboBox myDeviceCombo;
    private JComponent myColumnTreePane;
    private JPanel myComponent;
    private JPanel myToolbarPanel;
    private ProgressPanel myProgressPanel;
    private JPanel myErrorPanel;
    private JBLabel myErrorText;
    private Tree myTree;

    public DeviceMonitorPanel() {
        this.$$$setupUI$$$();
        this.myErrorPanel.setBackground(UIUtil.getTreeBackground());
        this.myErrorText.setFont((Font)AdtUiUtils.EMPTY_TOOL_WINDOW_FONT);
        this.myErrorText.setForeground(UIUtil.getInactiveTextColor());
    }

    @NotNull
    public JPanel getComponent() {
        return this.myComponent;
    }

    @NotNull
    public JComboBox<Device> getDeviceCombo() {
        return this.myDeviceCombo;
    }

    @NotNull
    public JPanel getToolbarPanel() {
        return this.myToolbarPanel;
    }

    public void showMessageLayer(@NotNull String message2, boolean showDeviceList) {
        this.showMessageLayerWorker(message2, UIUtil.getInactiveTextColor(), null, showDeviceList);
    }

    public void showMessageLayer(@NotNull String message2, @NotNull Icon messageIcon, boolean showDeviceList) {
        this.showMessageLayerWorker(message2, UIUtil.getInactiveTextColor(), messageIcon, showDeviceList);
    }

    public void showErrorMessageLayer(@NotNull String errorMessage, boolean showDeviceList) {
        this.showMessageLayerWorker(errorMessage, (Color)JBColor.RED, null, showDeviceList);
    }

    private void showMessageLayerWorker(@NotNull String message2, @NotNull Color color, @Nullable Icon icon2, boolean showDeviceList) {
        this.myErrorText.setForeground(color);
        this.myErrorText.setIcon(icon2);
        this.myDeviceCombo.setVisible(showDeviceList);
        this.myToolbarPanel.setVisible(showDeviceList);
        this.myColumnTreePane.setVisible(false);
        String htmlText = String.format("<html><div style='text-align: center;'>%s</div></html>", StringUtil.escapeXml((String)message2));
        this.myErrorText.setText(htmlText);
        this.myErrorPanel.setVisible(true);
    }

    public void showTree() {
        this.myErrorPanel.setVisible(false);
        this.myDeviceCombo.setVisible(true);
        this.myToolbarPanel.setVisible(true);
        this.myColumnTreePane.setVisible(true);
        this.myErrorText.setText("");
    }

    public void setCancelActionListener(@Nullable ActionListener cancelActionListener) {
        this.myProgressPanel.setCancelActionListener(cancelActionListener);
    }

    private void createUIComponents() {
        this.createTree();
    }

    private void createTree() {
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree(treeModel){

            protected boolean shouldShowBusyIconIfNeeded() {
                return true;
            }
        };
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.getEmptyText().setText("No debuggable process on device");
        this.myColumnTreePane = new ProcessListTreeBuilder().build(this.myTree);
    }

    @NotNull
    public Tree getTree() {
        return this.myTree;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ProgressPanel progressPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JComboBox jComboBox;
        JPanel jPanel3;
        this.createUIComponents();
        this.myComponent = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), 1, 1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myDeviceCombo = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 7, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JComponent jComponent = this.myColumnTreePane;
        jPanel5.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myErrorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel2).setVisible(false);
        jPanel5.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(120, 10, 0, 10), null, 0, 0, null, null));
        this.myErrorText = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(0);
        jBLabel.setHorizontalTextPosition(0);
        jBLabel.setVerticalAlignment(1);
        jBLabel.setVerticalTextPosition(3);
        jPanel2.add((Component)jBLabel, "Center");
        this.myProgressPanel = progressPanel = new ProgressPanel();
        ((Component)progressPanel).setVisible(false);
        jPanel3.add((Component)progressPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }
}

