/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.monitor.ui;

import com.android.tools.idea.device.monitor.ui.menu.item.PopupMenuItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PopupHandler;
import java.util.Arrays;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/device/monitor/ui/ComponentPopupMenu;", "", "myComponent", "Ljavax/swing/JComponent;", "(Ljavax/swing/JComponent;)V", "myGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "addItem", "", "popupMenuItem", "Lcom/android/tools/idea/device/monitor/ui/menu/item/PopupMenuItem;", "addSeparator", "install", "intellij.android.device-monitor-toolwindow"})
public final class ComponentPopupMenu {
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final DefaultActionGroup myGroup;

    public ComponentPopupMenu(@NotNull JComponent myComponent) {
        Intrinsics.checkNotNullParameter((Object)myComponent, (String)"myComponent");
        this.myComponent = myComponent;
        this.myGroup = new DefaultActionGroup();
    }

    public final void install() {
        PopupHandler.installPopupMenu((JComponent)this.myComponent, (ActionGroup)((ActionGroup)this.myGroup), (String)"Device Monitor Toolbar");
    }

    public final void addSeparator() {
        this.myGroup.addSeparator();
    }

    public final void addItem(@NotNull PopupMenuItem popupMenuItem) {
        Shortcut[] shortcuts;
        Intrinsics.checkNotNullParameter((Object)popupMenuItem, (String)"popupMenuItem");
        AnAction action2 = popupMenuItem.getAction();
        String shortcutId = popupMenuItem.getShortcutId();
        if (!StringUtil.isEmpty((String)shortcutId)) {
            Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
            Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getInstance().activeKeymap");
            Keymap active = keymap;
            Shortcut[] shortcuts2 = active.getShortcuts(shortcutId);
            action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcuts2, shortcuts2.length)), this.myComponent);
        }
        if ((shortcuts = popupMenuItem.getShortcuts()) != null && !(shortcuts.length == 0)) {
            action2.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(Arrays.copyOf(shortcuts, shortcuts.length)), this.myComponent);
        }
        this.myGroup.add(action2);
    }
}

