/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.monitor.adbimpl;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbFileProvider;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.device.monitor.adbimpl.AdbDevice;
import com.android.tools.idea.device.monitor.adbimpl.AdbDeviceListService;
import com.android.tools.idea.device.monitor.processes.Device;
import com.android.tools.idea.device.monitor.processes.DeviceListService;
import com.android.tools.idea.device.monitor.processes.DeviceListServiceListener;
import com.android.tools.idea.device.monitor.processes.ProcessInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.guava.ListenableFutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0005FGHIJB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0007\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001bH\u0016J\u0012\u0010&\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0003J\b\u0010.\u001a\u00020$H\u0016J\u001f\u0010/\u001a\b\u0012\u0004\u0012\u00020*0\u00152\u0006\u0010+\u001a\u000200H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u0004\u0018\u00010\u00162\u0006\u0010+\u001a\u000203H\u0002J\u0019\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020*H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J-\u00107\u001a\u00020$2\u0006\u00108\u001a\u00020\u001e2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020$0:H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?H\u0002J\u0019\u0010A\u001a\u00020$2\u0006\u00105\u001a\u00020*H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0010\u0010B\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001bH\u0016J\u0011\u0010C\u001a\u00020$H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DJ\u0011\u0010E\u001a\u00020$H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DR\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00160\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2={"Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService;", "Lcom/intellij/openapi/Disposable;", "Lcom/android/tools/idea/device/monitor/processes/DeviceListService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "adbSupplier", "Ljava/util/function/Supplier;", "Ljava/io/File;", "(Ljava/util/function/Supplier;)V", "bridge", "Lcom/android/ddmlib/AndroidDebugBridge;", "clientChangeListener", "Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService$DeviceClientListener;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "debugBridgeChangeListener", "Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService$DebugBridgeChangeListener;", "deviceChangeListener", "Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService$DeviceChangeListener;", "devices", "", "Lcom/android/tools/idea/device/monitor/adbimpl/AdbDevice;", "getDevices", "()Ljava/util/List;", "listeners", "", "Lcom/android/tools/idea/device/monitor/processes/DeviceListServiceListener;", "myDevices", "", "", "state", "Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService$State;", "workerThreadDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "addListener", "", "listener", "bridgeChangedWorker", "newBridge", "checkState", "createProcessInfo", "Lcom/android/tools/idea/device/monitor/processes/ProcessInfo;", "device", "client", "Lcom/android/ddmlib/Client;", "dispose", "fetchProcessList", "Lcom/android/tools/idea/device/monitor/processes/Device;", "(Lcom/android/tools/idea/device/monitor/processes/Device;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findDevice", "Lcom/android/ddmlib/IDevice;", "forceStopProcess", "process", "(Lcom/android/tools/idea/device/monitor/processes/ProcessInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invokeOnDevice", "serialNumber", "block", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isMaskBitSet", "", "value", "", "mask", "killProcess", "removeListener", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startWorker", "Companion", "DebugBridgeChangeListener", "DeviceChangeListener", "DeviceClientListener", "State", "intellij.android.device-monitor-toolwindow"})
public final class AdbDeviceListService
implements Disposable,
DeviceListService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Supplier<File> adbSupplier;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CoroutineDispatcher workerThreadDispatcher;
    @NotNull
    private final Map<String, AdbDevice> myDevices;
    @NotNull
    private final List<DeviceListServiceListener> listeners;
    @NotNull
    private State state;
    @Nullable
    private AndroidDebugBridge bridge;
    @NotNull
    private final DeviceClientListener clientChangeListener;
    @NotNull
    private final DeviceChangeListener deviceChangeListener;
    @NotNull
    private final DebugBridgeChangeListener debugBridgeChangeListener;
    @NotNull
    private static Logger LOGGER;

    @NonInjectable
    public AdbDeviceListService(@NotNull Supplier<File> adbSupplier) {
        Intrinsics.checkNotNullParameter(adbSupplier, (String)"adbSupplier");
        this.adbSupplier = adbSupplier;
        this.coroutineScope = CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
        this.workerThreadDispatcher = AndroidDispatchers.INSTANCE.getWorkerThread();
        this.myDevices = new HashMap();
        this.listeners = new ArrayList();
        this.state = State.Initial;
        this.clientChangeListener = new DeviceClientListener();
        this.deviceChangeListener = new DeviceChangeListener();
        this.debugBridgeChangeListener = new DebugBridgeChangeListener();
    }

    public AdbDeviceListService(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(new Supplier(){

            @Nullable
            public final File get() {
                return AdbFileProvider.Companion.fromProject(project).get();
            }
        });
    }

    public void dispose() {
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.clientChangeListener);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.deviceChangeListener);
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.debugBridgeChangeListener);
        this.bridge = null;
        this.myDevices.clear();
        this.listeners.clear();
    }

    @Override
    public void addListener(@NotNull DeviceListServiceListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ApplicationManagerEx.getApplication().assertIsDispatchThread();
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceListServiceListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ApplicationManagerEx.getApplication().assertIsDispatchThread();
        this.listeners.remove(listener2);
    }

    @Override
    @UiThread
    @Nullable
    public Object start(@NotNull Continuation<? super Unit> $completion) {
        ApplicationManagerEx.getApplication().assertIsDispatchThread();
        Object object = BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AdbDeviceListService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = AdbDeviceListService.access$startWorker(this.this$0, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null).await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public List<AdbDevice> getDevices() {
        List list2;
        ApplicationManagerEx.getApplication().assertIsDispatchThread();
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: 
            case 2: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            case 3: {
                list2 = CollectionsKt.toList((Iterable)this.myDevices.values());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    @Override
    @Nullable
    public Object fetchProcessList(@NotNull Device device2, @NotNull Continuation<? super List<ProcessInfo>> $completion) {
        Client[] clientArray;
        ApplicationManagerEx.getApplication().assertIsDispatchThread();
        this.checkState(State.SetupDone);
        AdbDevice adbDevice = this.myDevices.get(device2.getSerialNumber());
        if (adbDevice == null) {
            return CollectionsKt.emptyList();
        }
        AdbDevice adbDevice2 = adbDevice;
        Client[] clientArray2 = adbDevice2.getDevice().getClients();
        if (clientArray2 == null) {
            boolean $i$f$emptyArray = false;
            clientArray = (Client[])((Object[])new Client[0]);
        } else {
            clientArray = clientArray2;
        }
        Client[] clients = clientArray;
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.workerThreadDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ProcessInfo>>, Object>(clients, this, adbDevice2, null){
            int label;
            final /* synthetic */ Client[] $clients;
            final /* synthetic */ AdbDeviceListService this$0;
            final /* synthetic */ AdbDevice $adbDevice;
            {
                this.$clients = $clients;
                this.this$0 = $receiver;
                this.$adbDevice = $adbDevice;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])this.$clients), (Function1)((Function1)new Function1<Client, ProcessInfo>(this.this$0, this.$adbDevice){
                            final /* synthetic */ AdbDeviceListService this$0;
                            final /* synthetic */ AdbDevice $adbDevice;
                            {
                                this.this$0 = $receiver;
                                this.$adbDevice = $adbDevice;
                                super(1);
                            }

                            @Nullable
                            public final ProcessInfo invoke(Client client2) {
                                Intrinsics.checkNotNullExpressionValue((Object)client2, (String)"client");
                                return AdbDeviceListService.access$createProcessInfo(this.this$0, this.$adbDevice, client2);
                            }
                        })));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<ProcessInfo>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object killProcess(@NotNull ProcessInfo process2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.invokeOnDevice(process2.getDevice().getSerialNumber(), (Function1<? super IDevice, Unit>)((Function1)new Function1<IDevice, Unit>(process2){
            final /* synthetic */ ProcessInfo $process;
            {
                this.$process = $process;
                super(1);
            }

            public final void invoke(@NotNull IDevice it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.kill(this.$process.getProcessName());
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object forceStopProcess(@NotNull ProcessInfo process2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.invokeOnDevice(process2.getDevice().getSerialNumber(), (Function1<? super IDevice, Unit>)((Function1)new Function1<IDevice, Unit>(process2){
            final /* synthetic */ ProcessInfo $process;
            {
                this.$process = $process;
                super(1);
            }

            public final void invoke(@NotNull IDevice it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.forceStop(this.$process.getProcessName());
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object invokeOnDevice(String var1_1, Function1<? super IDevice, Unit> var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof invokeOnDevice.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ AdbDeviceListService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AdbDeviceListService.access$invokeOnDevice(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ApplicationManagerEx.getApplication().assertIsDispatchThread();
                this.checkState(State.SetupDone);
                v0 = this.myDevices.get(serialNumber);
                if (v0 == null || (v0 = v0.getDevice()) == null) break;
                device = v0;
                $i$a$-let-AdbDeviceListService$invokeOnDevice$2 = false;
                $continuation.label = 1;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.workerThreadDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super IDevice, Unit>)block, (IDevice)device, null){
                    int label;
                    final /* synthetic */ Function1<IDevice, Unit> $block;
                    final /* synthetic */ IDevice $device;
                    {
                        this.$block = $block;
                        this.$device = $device;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$block.invoke((Object)this.$device);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var8_6) {
                    return var8_6;
                }
                break;
            }
            case 1: {
                $i$a$-let-AdbDeviceListService$invokeOnDevice$2 = false;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object startWorker(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof startWorker.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AdbDeviceListService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AdbDeviceListService.access$startWorker(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ApplicationManagerEx.getApplication().assertIsDispatchThread();
                if (this.state == State.SetupRunning || this.state == State.SetupDone) {
                    return Unit.INSTANCE;
                }
                adb = this.adbSupplier.get();
                if (adb == null) {
                    AdbDeviceListService.LOGGER.warn("ADB not found");
                    throw new FileNotFoundException("Android Debug Bridge not found.");
                }
                AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this.clientChangeListener);
                AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.deviceChangeListener);
                AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.debugBridgeChangeListener);
                this.state = State.SetupRunning;
                v0 = AdbService.getInstance().getDebugBridge(adb);
                Intrinsics.checkNotNullExpressionValue(v0, (String)"getInstance().getDebugBridge(adb)");
                $continuation.L$0 = this;
                $continuation.L$1 = adb;
                $continuation.label = 1;
                v1 = ListenableFutureKt.await(v0, (Continuation)$continuation);
                ** if (v1 != var6_4) goto lbl33
lbl32:
                // 1 sources

                return var6_4;
lbl33:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                adb = (File)$continuation.L$1;
                this = (AdbDeviceListService)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl41:
                    // 2 sources

                    bridge = (AndroidDebugBridge)v1;
                    AdbDeviceListService.LOGGER.debug("Successfully obtained debug bridge");
                    this.bridgeChangedWorker(bridge);
                    this.state = State.SetupDone;
                }
                catch (Throwable t) {
                    AdbDeviceListService.LOGGER.warn("Unable to obtain debug bridge", t);
                    this.state = State.Initial;
                    if (t.getMessage() != null) {
                        throw t;
                    }
                    throw new RuntimeException(AdbService.getDebugBridgeDiagnosticErrorMessage(t, adb), t);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void bridgeChangedWorker(AndroidDebugBridge newBridge) {
        ApplicationManagerEx.getApplication().assertIsDispatchThread();
        if (this.bridge != null) {
            this.myDevices.clear();
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DeviceListServiceListener it = (DeviceListServiceListener)element$iv;
                boolean bl = false;
                it.serviceRestarted();
            }
        }
        this.bridge = newBridge;
        if (newBridge != null && newBridge.hasInitialDeviceList()) {
            IDevice[] iDeviceArray = newBridge.getDevices();
            Intrinsics.checkNotNullExpressionValue((Object)iDeviceArray, (String)"newBridge.devices");
            for (IDevice device2 : iDeviceArray) {
                String string;
                Map<String, AdbDevice> map2 = this.myDevices;
                Intrinsics.checkNotNullExpressionValue((Object)device2.getSerialNumber(), (String)"device.serialNumber");
                Intrinsics.checkNotNullExpressionValue((Object)device2, (String)"device");
                AdbDevice adbDevice = new AdbDevice(device2);
                map2.put(string, adbDevice);
            }
        }
    }

    @WorkerThread
    private final ProcessInfo createProcessInfo(AdbDevice device2, Client client2) {
        try {
            ProcessInfo processInfo;
            String processName = client2.getClientData().getClientDescription();
            if (processName == null) {
                AdbDeviceListService $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(AdbDeviceListService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                logger2.debug("Process " + client2.getClientData().getPid() + " was skipped because the process name is not initialized. Is another instance of Studio running?");
                processInfo = new ProcessInfo(device2, client2.getClientData().getPid(), null, null, null, null, null, false, 252, null);
            } else {
                Integer userId = client2.getClientData().getUserId() == -1 ? null : Integer.valueOf(client2.getClientData().getUserId());
                Device device3 = device2;
                int n = client2.getClientData().getPid();
                String string = client2.getClientData().getVmIdentifier();
                String string2 = client2.getClientData().getAbi();
                ClientData.DebuggerStatus debuggerStatus = client2.getClientData().getDebuggerConnectionStatus();
                Intrinsics.checkNotNullExpressionValue((Object)debuggerStatus, (String)"client.clientData.debuggerConnectionStatus");
                processInfo = new ProcessInfo(device3, n, processName, userId, string, string2, debuggerStatus, client2.getClientData().isNativeDebuggable());
            }
            return processInfo;
        }
        catch (Throwable e) {
            AdbDeviceListService $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(AdbDeviceListService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"Logger.getInstance(T::class.java)");
            logger3.warn("Error retrieving process info from `Client`", e);
            return null;
        }
    }

    private final void checkState(State state2) {
        if (!(this.state == state2)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final boolean isMaskBitSet(int value2, int mask) {
        return (value2 & mask) != 0;
    }

    private final AdbDevice findDevice(IDevice device2) {
        return this.myDevices.get(device2.getSerialNumber());
    }

    public static final /* synthetic */ Object access$startWorker(AdbDeviceListService $this, Continuation $completion) {
        return $this.startWorker((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ ProcessInfo access$createProcessInfo(AdbDeviceListService $this, AdbDevice device2, Client client2) {
        return $this.createProcessInfo(device2, client2);
    }

    public static final /* synthetic */ Object access$invokeOnDevice(AdbDeviceListService $this, String serialNumber, Function1 block, Continuation $completion) {
        return $this.invokeOnDevice(serialNumber, (Function1<? super IDevice, Unit>)block, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$bridgeChangedWorker(AdbDeviceListService $this, AndroidDebugBridge newBridge) {
        $this.bridgeChangedWorker(newBridge);
    }

    public static final /* synthetic */ AdbDevice access$findDevice(AdbDeviceListService $this, IDevice device2) {
        return $this.findDevice(device2);
    }

    public static final /* synthetic */ Map access$getMyDevices$p(AdbDeviceListService $this) {
        return $this.myDevices;
    }

    public static final /* synthetic */ List access$getListeners$p(AdbDeviceListService $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ boolean access$isMaskBitSet(AdbDeviceListService $this, int value2, int mask) {
        return $this.isMaskBitSet(value2, mask);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(AdbDeviceListService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        LOGGER = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001f\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService$Companion;", "", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOGGER", "()Lcom/intellij/openapi/diagnostic/Logger;", "setLOGGER", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "getInstance", "Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.device-monitor-toolwindow"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AdbDeviceListService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            return (AdbDeviceListService)$this$service$iv.getService(AdbDeviceListService.class);
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public final void setLOGGER(@NotNull Logger logger2) {
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"<set-?>");
            LOGGER = logger2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService$State;", "", "(Ljava/lang/String;I)V", "Initial", "SetupRunning", "SetupDone", "intellij.android.device-monitor-toolwindow"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Initial = new State();
        public static final /* enum */ State SetupRunning = new State();
        public static final /* enum */ State SetupDone = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.Initial, State.SetupRunning, State.SetupDone};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService$DebugBridgeChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDebugBridgeChangeListener;", "(Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService;)V", "bridgeChanged", "", "bridge", "Lcom/android/ddmlib/AndroidDebugBridge;", "intellij.android.device-monitor-toolwindow"})
    private final class DebugBridgeChangeListener
    implements AndroidDebugBridge.IDebugBridgeChangeListener {
        public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
            Companion.getLOGGER().debug("Debug bridge changed");
            BuildersKt.launch$default((CoroutineScope)AdbDeviceListService.this.coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(AdbDeviceListService.this, bridge, null){
                int label;
                final /* synthetic */ AdbDeviceListService this$0;
                final /* synthetic */ AndroidDebugBridge $bridge;
                {
                    this.this$0 = $receiver;
                    this.$bridge = $bridge;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            AdbDeviceListService.access$bridgeChangedWorker(this.this$0, this.$bridge);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService$DeviceChangeListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IDeviceChangeListener;", "(Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService;)V", "deviceChanged", "", "device", "Lcom/android/ddmlib/IDevice;", "changeMask", "", "deviceConnected", "deviceDisconnected", "intellij.android.device-monitor-toolwindow"})
    private final class DeviceChangeListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        public void deviceConnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            Logger logger2 = Companion.getLOGGER();
            String string = "Device connected: %s";
            Object[] objectArray = new Object[]{device2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            logger2.debug(string2);
            BuildersKt.launch$default((CoroutineScope)AdbDeviceListService.this.coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(AdbDeviceListService.this, device2, null){
                int label;
                final /* synthetic */ AdbDeviceListService this$0;
                final /* synthetic */ IDevice $device;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (AdbDeviceListService.access$findDevice(this.this$0, this.$device) == null) {
                                AdbDevice newDevice = new AdbDevice(this.$device);
                                AdbDeviceListService.access$getMyDevices$p(this.this$0).put(newDevice.getSerialNumber(), newDevice);
                                Iterable $this$forEach$iv = AdbDeviceListService.access$getListeners$p(this.this$0);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    DeviceListServiceListener it = (DeviceListServiceListener)element$iv;
                                    boolean bl = false;
                                    it.deviceAdded(newDevice);
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public void deviceDisconnected(@NotNull IDevice device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            Logger logger2 = Companion.getLOGGER();
            String string = "Device disconnected: %s";
            Object[] objectArray = new Object[]{device2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            logger2.debug(string2);
            BuildersKt.launch$default((CoroutineScope)AdbDeviceListService.this.coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(AdbDeviceListService.this, device2, null){
                int label;
                final /* synthetic */ AdbDeviceListService this$0;
                final /* synthetic */ IDevice $device;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            AdbDevice adbDevice = AdbDeviceListService.access$findDevice(this.this$0, this.$device);
                            if (adbDevice != null) {
                                AdbDevice adbDevice2 = adbDevice;
                                AdbDeviceListService adbDeviceListService = this.this$0;
                                AdbDevice it = adbDevice2;
                                boolean bl = false;
                                Iterable $this$forEach$iv = AdbDeviceListService.access$getListeners$p(adbDeviceListService);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    DeviceListServiceListener l = (DeviceListServiceListener)element$iv;
                                    boolean bl2 = false;
                                    l.deviceRemoved(it);
                                }
                                AdbDeviceListService.access$getMyDevices$p(adbDeviceListService).remove(it.getSerialNumber());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public void deviceChanged(@NotNull IDevice device2, int changeMask) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            Logger logger2 = Companion.getLOGGER();
            String string = "Device changed: %s";
            Object[] objectArray = new Object[]{device2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            logger2.debug(string2);
            BuildersKt.launch$default((CoroutineScope)AdbDeviceListService.this.coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(AdbDeviceListService.this, device2, changeMask, null){
                int label;
                final /* synthetic */ AdbDeviceListService this$0;
                final /* synthetic */ IDevice $device;
                final /* synthetic */ int $changeMask;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    this.$changeMask = $changeMask;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            AdbDevice adbDevice = AdbDeviceListService.access$findDevice(this.this$0, this.$device);
                            if (adbDevice != null) {
                                DeviceListServiceListener l;
                                boolean $i$f$forEach;
                                Iterable $this$forEach$iv;
                                AdbDevice adbDevice2 = adbDevice;
                                AdbDeviceListService adbDeviceListService = this.this$0;
                                int n = this.$changeMask;
                                AdbDevice it = adbDevice2;
                                boolean bl = false;
                                if (AdbDeviceListService.access$isMaskBitSet(adbDeviceListService, n, 1)) {
                                    $this$forEach$iv = AdbDeviceListService.access$getListeners$p(adbDeviceListService);
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        l = (DeviceListServiceListener)element$iv;
                                        boolean bl2 = false;
                                        l.deviceUpdated(it);
                                    }
                                }
                                if (AdbDeviceListService.access$isMaskBitSet(adbDeviceListService, n, 2)) {
                                    $this$forEach$iv = AdbDeviceListService.access$getListeners$p(adbDeviceListService);
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        l = (DeviceListServiceListener)element$iv;
                                        boolean bl3 = false;
                                        l.deviceProcessListUpdated(it);
                                    }
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService$DeviceClientListener;", "Lcom/android/ddmlib/AndroidDebugBridge$IClientChangeListener;", "(Lcom/android/tools/idea/device/monitor/adbimpl/AdbDeviceListService;)V", "clientChanged", "", "client", "Lcom/android/ddmlib/Client;", "changeMask", "", "intellij.android.device-monitor-toolwindow"})
    private final class DeviceClientListener
    implements AndroidDebugBridge.IClientChangeListener {
        public void clientChanged(@NotNull Client client2, int changeMask) {
            Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
            IDevice device2 = client2.getDevice();
            Logger logger2 = Companion.getLOGGER();
            String string = "Client changed: %s";
            Object[] objectArray = new Object[]{device2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            logger2.debug(string2);
            BuildersKt.launch$default((CoroutineScope)AdbDeviceListService.this.coroutineScope, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(AdbDeviceListService.this, device2, changeMask, null){
                int label;
                final /* synthetic */ AdbDeviceListService this$0;
                final /* synthetic */ IDevice $device;
                final /* synthetic */ int $changeMask;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    this.$changeMask = $changeMask;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            IDevice iDevice = this.$device;
                            Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"device");
                            AdbDevice adbDevice = AdbDeviceListService.access$findDevice(this.this$0, iDevice);
                            if (adbDevice != null) {
                                AdbDevice adbDevice2 = adbDevice;
                                AdbDeviceListService adbDeviceListService = this.this$0;
                                int n = this.$changeMask;
                                AdbDevice it = adbDevice2;
                                boolean bl = false;
                                if (AdbDeviceListService.access$isMaskBitSet(adbDeviceListService, n, 7)) {
                                    Iterable $this$forEach$iv = AdbDeviceListService.access$getListeners$p(adbDeviceListService);
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        DeviceListServiceListener l = (DeviceListServiceListener)element$iv;
                                        boolean bl2 = false;
                                        l.deviceProcessListUpdated(it);
                                    }
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            nArray[State.Initial.ordinal()] = 1;
            nArray[State.SetupRunning.ordinal()] = 2;
            nArray[State.SetupDone.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

