/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.monitor;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.device.monitor.DeviceMonitorController;
import com.android.tools.idea.device.monitor.DeviceMonitorModel;
import com.android.tools.idea.device.monitor.DeviceMonitorView;
import com.android.tools.idea.device.monitor.DeviceMonitorViewListener;
import com.android.tools.idea.device.monitor.DeviceTreeNode;
import com.android.tools.idea.device.monitor.ProcessInfoTreeNode;
import com.android.tools.idea.device.monitor.ProcessTreeNode;
import com.android.tools.idea.device.monitor.processes.Device;
import com.android.tools.idea.device.monitor.processes.DeviceListService;
import com.android.tools.idea.device.monitor.processes.DeviceListServiceListener;
import com.android.tools.idea.device.monitor.processes.DeviceState;
import com.android.tools.idea.device.monitor.processes.ProcessInfo;
import com.android.tools.idea.device.monitor.processes.ProcessInfoKt;
import com.android.tools.idea.device.monitor.ui.TreeUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@UiThread
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 52\u00020\u0001:\u00045678B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001b\u0010\u001f\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u001e\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020!H\u0002J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020!H\u0007J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010.\u001a\u00020\u000fH\u0002J\u0006\u0010/\u001a\u00020\u000fJ,\u00100\u001a\b\u0012\u0004\u0012\u0002010'2\u0006\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020%2\f\u00104\u001a\b\u0012\u0004\u0012\u00020(0'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00069"}, d2={"Lcom/android/tools/idea/device/monitor/DeviceMonitorController;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/device/monitor/DeviceMonitorModel;", "view", "Lcom/android/tools/idea/device/monitor/DeviceMonitorView;", "service", "Lcom/android/tools/idea/device/monitor/processes/DeviceListService;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/device/monitor/DeviceMonitorModel;Lcom/android/tools/idea/device/monitor/DeviceMonitorView;Lcom/android/tools/idea/device/monitor/processes/DeviceListService;)V", "serviceListener", "Lcom/android/tools/idea/device/monitor/DeviceMonitorController$ServiceListener;", "setupJob", "Lkotlinx/coroutines/CompletableDeferred;", "", "uiThreadScope", "Lkotlinx/coroutines/CoroutineScope;", "viewListener", "Lcom/android/tools/idea/device/monitor/DeviceMonitorController$ViewListener;", "deviceStateUpdated", "device", "Lcom/android/tools/idea/device/monitor/processes/Device;", "dispose", "getTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "getTreeSelectionModel", "Ljavax/swing/tree/DefaultTreeSelectionModel;", "hasActiveDevice", "", "refreshActiveDevice", "refreshDeviceList", "serialNumberToSelect", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshProcessList", "deviceNode", "Lcom/android/tools/idea/device/monitor/DeviceTreeNode;", "processList", "", "Lcom/android/tools/idea/device/monitor/processes/ProcessInfo;", "reportErrorFindingDevice", "message", "selectActiveDevice", "serialNumber", "setActiveDevice", "setNoActiveDevice", "setup", "updateChildrenNodes", "Lcom/android/tools/idea/device/monitor/ProcessTreeNode;", "treeModel", "parentNode", "newEntries", "Companion", "ProcessInfoNameComparator", "ServiceListener", "ViewListener", "intellij.android.device-monitor-toolwindow"})
public final class DeviceMonitorController
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceMonitorModel model;
    @NotNull
    private final DeviceMonitorView view;
    @NotNull
    private final DeviceListService service;
    @NotNull
    private final CoroutineScope uiThreadScope;
    @NotNull
    private final CompletableDeferred<Unit> setupJob;
    @NotNull
    private final ServiceListener serviceListener;
    @NotNull
    private final ViewListener viewListener;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final Key<DeviceMonitorController> KEY;
    @NotNull
    private static final String DEVICE_MONITOR_BUSY_MESSAGE = "Device Monitor is busy, please retry later or cancel current operation";

    public DeviceMonitorController(@NotNull Project project, @NotNull DeviceMonitorModel model2, @NotNull DeviceMonitorView view, @NotNull DeviceListService service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.model = model2;
        this.view = view;
        this.service = service;
        this.uiThreadScope = CoroutinesUtilsKt.AndroidCoroutineScope((Disposable)this, (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()));
        this.setupJob = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.serviceListener = new ServiceListener();
        this.viewListener = new ViewListener();
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
        this.service.addListener(this.serviceListener);
        this.view.addListener(this.viewListener);
        project.putUserData(KEY, (Object)this);
    }

    public void dispose() {
        this.view.removeListener(this.viewListener);
        this.service.removeListener(this.serviceListener);
        CoroutineScopeKt.cancel$default((CoroutineScope)this.uiThreadScope, (String)(this.getClass().getSimpleName() + " has been disposed"), null, (int)2, null);
    }

    private final DefaultTreeModel getTreeModel() {
        return this.model.getTreeModel();
    }

    private final DefaultTreeSelectionModel getTreeSelectionModel() {
        return this.model.getTreeSelectionModel();
    }

    public final void setup() {
        BuildersKt.launch$default((CoroutineScope)this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DeviceMonitorController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        DeviceMonitorController.access$getView$p(this.this$0).setup();
                        DeviceMonitorController.access$getView$p(this.this$0).startRefresh("Initializing ADB");
                        this.label = 1;
                        v0 = DeviceMonitorController.access$getService$p(this.this$0).start((Continuation<? super Unit>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl13
lbl12:
                        // 1 sources

                        return var3_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        DeviceMonitorController.access$getSetupJob$p(this.this$0).complete((Object)Unit.INSTANCE);
                        this.label = 2;
                        v1 = DeviceMonitorController.access$refreshDeviceList(this.this$0, null, (Continuation)this);
                        ** if (v1 != var3_2) goto lbl25
lbl24:
                        // 1 sources

                        return var3_2;
lbl25:
                        // 1 sources

                        ** GOTO lbl42
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl42
                        }
                        catch (Throwable t) {
                            DeviceMonitorController.access$getView$p(this.this$0).reportErrorRelatedToService(DeviceMonitorController.access$getService$p(this.this$0), "Error initializing ADB", t);
                            DeviceMonitorController.access$getSetupJob$p(this.this$0).completeExceptionally(t);
                            ** GOTO lbl42
                        }
                    }
                    catch (Throwable var2_4) {
                        throw var2_4;
                    }
                    {
                        finally {
                            DeviceMonitorController.access$getView$p(this.this$0).stopRefresh();
                        }
lbl42:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void reportErrorFindingDevice(String message2) {
        this.view.reportErrorGeneric(message2, new IllegalStateException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object refreshDeviceList(String serialNumberToSelect, Continuation<? super Unit> $completion) {
        block10: {
            this.view.startRefresh("Refreshing list of devices");
            try {
                Object v0;
                block11: {
                    List<Device> devices2 = this.service.getDevices();
                    this.model.removeAllDevices();
                    Iterable $this$forEach$iv = devices2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Device it = (Device)element$iv;
                        boolean bl = false;
                        this.model.addDevice(it);
                    }
                    if (devices2.isEmpty()) {
                        this.view.showNoDeviceScreen();
                        break block10;
                    }
                    if (serialNumberToSelect == null) break block10;
                    Iterable iterable = this.model.getDevices();
                    Iterator iterator2 = iterable.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        Device it = (Device)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSerialNumber(), (Object)serialNumberToSelect)) continue;
                        v0 = t;
                        break block11;
                    }
                    v0 = null;
                }
                Device device2 = v0;
                if (device2 == null) {
                    this.reportErrorFindingDevice("Unable to find device with serial number " + serialNumberToSelect + ". Please retry.");
                } else {
                    this.setActiveDevice(device2);
                }
            }
            catch (Throwable t) {
                this.model.removeAllDevices();
                this.view.reportErrorRelatedToService(this.service, "Error refreshing list of devices", t);
            }
            finally {
                this.view.stopRefresh();
            }
        }
        return Unit.INSTANCE;
    }

    private final void setNoActiveDevice() {
        this.model.setActiveDevice(null);
        this.model.setActiveDeviceTreeModel(null, null, null);
        this.view.showNoDeviceScreen();
    }

    private final void setActiveDevice(Device device2) {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
        this.model.setActiveDevice(device2);
        DefaultTreeModel treeModel = new DefaultTreeModel(new DeviceTreeNode(device2));
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        this.model.setActiveDeviceTreeModel(device2, treeModel, treeSelectionModel);
        this.refreshActiveDevice(device2);
    }

    private final void deviceStateUpdated(Device device2) {
        DeviceState lastKnownState;
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
        if (!Intrinsics.areEqual((Object)device2, (Object)this.model.getActiveDevice())) {
            return;
        }
        DeviceState newState = device2.getState();
        if (newState == (lastKnownState = this.model.getActiveDeviceLastKnownState(device2))) {
            return;
        }
        this.model.setActiveDeviceLastKnownState(device2);
        this.refreshActiveDevice(device2);
    }

    private final void refreshActiveDevice(Device device2) {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
        if (!Intrinsics.areEqual((Object)device2, (Object)this.model.getActiveDevice())) {
            return;
        }
        if (device2.getState() != DeviceState.ONLINE) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[device2.getState().ordinal()]) {
                case 1: {
                    string = "Device is pending authentication: please accept debugging session on the device";
                    break;
                }
                case 2: {
                    string = "Device is offline or booting: please restart device or wait until boot completes";
                    break;
                }
                default: {
                    String string2 = "Device is not online (%s)";
                    Object[] objectArray = new Object[]{device2.getState()};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                }
            }
            String message2 = string;
            this.view.reportMessageRelatedToDevice(device2, message2);
        } else {
            this.view.showActiveDeviceScreen();
        }
    }

    private final void refreshProcessList(DeviceTreeNode deviceNode, List<ProcessInfo> processList) {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
        DefaultTreeModel defaultTreeModel = this.getTreeModel();
        if (defaultTreeModel == null) {
            return;
        }
        DefaultTreeModel treeModel = defaultTreeModel;
        Device activeDevice2 = this.model.getActiveDevice();
        if (!Intrinsics.areEqual((Object)activeDevice2, (Object)deviceNode.getDevice())) {
            return;
        }
        this.updateChildrenNodes(treeModel, deviceNode, CollectionsKt.sortedWith((Iterable)processList, (Comparator)ProcessInfoNameComparator.INSTANCE));
    }

    private final List<ProcessTreeNode> updateChildrenNodes(DefaultTreeModel treeModel, DeviceTreeNode parentNode, List<ProcessInfo> newEntries) {
        TreeUtil.UpdateChildrenOps updateChildrenOps2 = new TreeUtil.UpdateChildrenOps<ProcessInfoTreeNode, ProcessInfo>(){

            @Nullable
            public ProcessInfoTreeNode getChildNode(@NotNull MutableTreeNode parentNode, int index2) {
                Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
                return ProcessInfoTreeNode.Companion.fromNode(parentNode.getChildAt(index2));
            }

            @NotNull
            public ProcessInfoTreeNode mapEntry(@NotNull ProcessInfo entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                return new ProcessInfoTreeNode(entry);
            }

            public int compareNodesForSorting(@NotNull ProcessInfoTreeNode node, @NotNull ProcessInfo entry) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                return ProcessInfoNameComparator.INSTANCE.compare(node.getProcessInfo(), entry);
            }

            public boolean equals(@NotNull ProcessInfoTreeNode node, @NotNull ProcessInfo entry) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                return Intrinsics.areEqual((Object)node.getProcessInfo(), (Object)entry);
            }

            public void updateNode(@NotNull ProcessInfoTreeNode node, @NotNull ProcessInfo entry) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                node.setProcessInfo(entry);
            }
        };
        List<ProcessTreeNode> addedNodes = TreeUtil.INSTANCE.updateChildrenNodes(treeModel, parentNode, newEntries, updateChildrenOps2);
        parentNode.setAllowsChildren(parentNode.getChildCount() > 0);
        this.view.expandNode(parentNode);
        DeviceMonitorController $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(DeviceMonitorController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        logger2.debug(parentNode.getDevice() + ": Process list updated to " + newEntries.size() + " processes");
        return addedNodes;
    }

    @TestOnly
    public final boolean hasActiveDevice() {
        return this.model.getActiveDevice() != null;
    }

    @TestOnly
    public final void selectActiveDevice(@NotNull String serialNumber) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        BuildersKt.launch$default((CoroutineScope)this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, serialNumber, null){
            int label;
            final /* synthetic */ DeviceMonitorController this$0;
            final /* synthetic */ String $serialNumber;
            {
                this.this$0 = $receiver;
                this.$serialNumber = $serialNumber;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block8: {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DeviceMonitorController.access$getSetupJob$p(this.this$0).await((Continuation)this);
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            var3_3 = DeviceMonitorController.access$getModel$p(this.this$0).getDevices();
                            var4_4 = this.$serialNumber;
                            var5_5 = var3_3;
                            for (T var7_7 : var5_5) {
                                it = (Device)var7_7;
                                $i$a$-find-DeviceMonitorController$selectActiveDevice$1$device$1 = false;
                                if (!Intrinsics.areEqual((Object)it.getSerialNumber(), (Object)var4_4)) continue;
                                v1 = var7_7;
                                ** GOTO lbl23
                            }
                            v1 = null;
lbl23:
                            // 2 sources

                            device = v1;
                            if (device != null) break;
                            this.label = 2;
                            v2 = DeviceMonitorController.access$refreshDeviceList(this.this$0, this.$serialNumber, (Continuation)this);
                            if (v2 == var10_2) {
                                return var10_2;
                            }
                            break block8;
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            break block8;
                        }
                    }
                    DeviceMonitorController.access$setActiveDevice(this.this$0, device);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @JvmStatic
    @Nullable
    public static final DeviceMonitorController getProjectController(@Nullable Project project) {
        return Companion.getProjectController(project);
    }

    public static final /* synthetic */ DeviceMonitorView access$getView$p(DeviceMonitorController $this) {
        return $this.view;
    }

    public static final /* synthetic */ DeviceListService access$getService$p(DeviceMonitorController $this) {
        return $this.service;
    }

    public static final /* synthetic */ CompletableDeferred access$getSetupJob$p(DeviceMonitorController $this) {
        return $this.setupJob;
    }

    public static final /* synthetic */ Object access$refreshDeviceList(DeviceMonitorController $this, String serialNumberToSelect, Continuation $completion) {
        return $this.refreshDeviceList(serialNumberToSelect, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$deviceStateUpdated(DeviceMonitorController $this, Device device2) {
        $this.deviceStateUpdated(device2);
    }

    public static final /* synthetic */ void access$refreshProcessList(DeviceMonitorController $this, DeviceTreeNode deviceNode, List processList) {
        $this.refreshProcessList(deviceNode, processList);
    }

    public static final /* synthetic */ void access$setActiveDevice(DeviceMonitorController $this, Device device2) {
        $this.setActiveDevice(device2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(DeviceMonitorController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        LOGGER = logger2;
        Key key = Key.create((String)DeviceMonitorController.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<DeviceMonitorCont\u2026er::class.java.name\n    )");
        KEY = key;
    }

    @UiThread
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/device/monitor/DeviceMonitorController$ServiceListener;", "Lcom/android/tools/idea/device/monitor/processes/DeviceListServiceListener;", "(Lcom/android/tools/idea/device/monitor/DeviceMonitorController;)V", "deviceAdded", "", "device", "Lcom/android/tools/idea/device/monitor/processes/Device;", "deviceProcessListUpdated", "deviceRemoved", "deviceUpdated", "serviceRestarted", "intellij.android.device-monitor-toolwindow"})
    private final class ServiceListener
    implements DeviceListServiceListener {
        @Override
        public void serviceRestarted() {
            BuildersKt.launch$default((CoroutineScope)DeviceMonitorController.this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DeviceMonitorController.this, null){
                int label;
                final /* synthetic */ DeviceMonitorController this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = DeviceMonitorController.access$refreshDeviceList(this.this$0, null, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Override
        public void deviceAdded(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            DeviceMonitorController.this.model.addDevice(device2);
        }

        @Override
        public void deviceRemoved(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            DeviceMonitorController.this.model.removeDevice(device2);
        }

        @Override
        public void deviceUpdated(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            BuildersKt.launch$default((CoroutineScope)DeviceMonitorController.this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DeviceMonitorController.this, device2, null){
                int label;
                final /* synthetic */ DeviceMonitorController this$0;
                final /* synthetic */ Device $device;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            DeviceMonitorController.access$getModel$p(this.this$0).updateDevice(this.$device);
                            DeviceMonitorController.access$deviceStateUpdated(this.this$0, this.$device);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Override
        public void deviceProcessListUpdated(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            BuildersKt.launch$default((CoroutineScope)DeviceMonitorController.this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DeviceMonitorController.this, device2, null){
                int label;
                final /* synthetic */ DeviceMonitorController this$0;
                final /* synthetic */ Device $device;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DeviceMonitorController.access$getService$p(this.this$0).fetchProcessList(this.$device, (Continuation<? super List<ProcessInfo>>)((Continuation)this));
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            newProcessList = (List)v0;
                            if (!Intrinsics.areEqual((Object)DeviceMonitorController.access$getModel$p(this.this$0).getActiveDevice(), (Object)this.$device)) {
                                return Unit.INSTANCE;
                            }
                            v1 = DeviceMonitorController.access$getModel$p(this.this$0).getTreeModel();
                            v2 = DeviceTreeNode.Companion.fromNode(v1 != null ? v1.getRoot() : null);
                            if (v2 == null) {
                                return Unit.INSTANCE;
                            }
                            deviceNode = v2;
                            DeviceMonitorController.access$refreshProcessList(this.this$0, deviceNode, newProcessList);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @UiThread
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016JB\u0010\u000b\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\"\u0010\f\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\rH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0019\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\nH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/device/monitor/DeviceMonitorController$ViewListener;", "Lcom/android/tools/idea/device/monitor/DeviceMonitorViewListener;", "(Lcom/android/tools/idea/device/monitor/DeviceMonitorController;)V", "deviceSelected", "", "device", "Lcom/android/tools/idea/device/monitor/processes/Device;", "forceStopNodesInvoked", "nodes", "", "Lcom/android/tools/idea/device/monitor/ProcessTreeNode;", "invokeOnProcessInfo", "block", "Lkotlin/Function2;", "Lcom/android/tools/idea/device/monitor/processes/ProcessInfo;", "Lkotlin/coroutines/Continuation;", "", "(Ljava/util/List;Lkotlin/jvm/functions/Function2;)V", "killNodesInvoked", "loadNodeChildren", "node", "(Lcom/android/tools/idea/device/monitor/ProcessTreeNode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "noDeviceSelected", "refreshInvoked", "treeNodeExpanding", "treeNode", "intellij.android.device-monitor-toolwindow"})
    private final class ViewListener
    implements DeviceMonitorViewListener {
        @Override
        public void noDeviceSelected() {
            DeviceMonitorController.this.setNoActiveDevice();
        }

        @Override
        public void deviceSelected(@NotNull Device device2) {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            BuildersKt.launch$default((CoroutineScope)DeviceMonitorController.this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DeviceMonitorController.this, device2, null){
                int label;
                final /* synthetic */ DeviceMonitorController this$0;
                final /* synthetic */ Device $device;
                {
                    this.this$0 = $receiver;
                    this.$device = $device;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            DeviceMonitorController.access$setActiveDevice(this.this$0, this.$device);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Override
        public void treeNodeExpanding(@NotNull ProcessTreeNode treeNode) {
            Intrinsics.checkNotNullParameter((Object)treeNode, (String)"treeNode");
            BuildersKt.launch$default((CoroutineScope)DeviceMonitorController.this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, treeNode, null){
                int label;
                final /* synthetic */ ViewListener this$0;
                final /* synthetic */ ProcessTreeNode $treeNode;
                {
                    this.this$0 = $receiver;
                    this.$treeNode = $treeNode;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = ViewListener.access$loadNodeChildren(this.this$0, this.$treeNode, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Override
        public void refreshInvoked() {
            BuildersKt.launch$default((CoroutineScope)DeviceMonitorController.this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DeviceMonitorController.this, null){
                Object L$0;
                int label;
                final /* synthetic */ DeviceMonitorController this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            v0 = DeviceMonitorController.access$getModel$p(this.this$0).getTreeModel();
                            v1 = DeviceTreeNode.Companion.fromNode(v0 != null ? v0.getRoot() : null);
                            if (v1 == null) {
                                return Unit.INSTANCE;
                            }
                            rootNode = v1;
                            this.L$0 = rootNode;
                            this.label = 1;
                            v2 = DeviceMonitorController.access$getService$p(this.this$0).fetchProcessList(rootNode.getDevice(), (Continuation<? super List<ProcessInfo>>)((Continuation)this));
                            if (v2 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl20
                        }
                        case 1: {
                            rootNode = (DeviceTreeNode)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl20:
                            // 2 sources

                            processList = (List)v2;
                            if (Intrinsics.areEqual((Object)DeviceMonitorController.access$getModel$p(this.this$0).getActiveDevice(), (Object)rootNode.getDevice())) {
                                DeviceMonitorController.access$refreshProcessList(this.this$0, rootNode, processList);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Override
        public void killNodesInvoked(@NotNull List<? extends ProcessTreeNode> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            this.invokeOnProcessInfo(nodes, (Function2<? super ProcessInfo, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ProcessInfo, Continuation<? super Unit>, Object>(DeviceMonitorController.this, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ DeviceMonitorController this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProcessInfo processInfo = (ProcessInfo)this.L$0;
                            this.label = 1;
                            Object object3 = DeviceMonitorController.access$getService$p(this.this$0).killProcess(processInfo, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull ProcessInfo p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @Override
        public void forceStopNodesInvoked(@NotNull List<? extends ProcessTreeNode> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            this.invokeOnProcessInfo(nodes, (Function2<? super ProcessInfo, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ProcessInfo, Continuation<? super Unit>, Object>(DeviceMonitorController.this, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ DeviceMonitorController this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProcessInfo processInfo = (ProcessInfo)this.L$0;
                            this.label = 1;
                            Object object3 = DeviceMonitorController.access$getService$p(this.this$0).forceStopProcess(processInfo, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull ProcessInfo p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final void invokeOnProcessInfo(List<? extends ProcessTreeNode> nodes, Function2<? super ProcessInfo, ? super Continuation<? super Unit>, ? extends Object> block) {
            BuildersKt.launch$default((CoroutineScope)DeviceMonitorController.this.uiThreadScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(DeviceMonitorController.this, nodes, block, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int label;
                final /* synthetic */ DeviceMonitorController this$0;
                final /* synthetic */ List<ProcessTreeNode> $nodes;
                final /* synthetic */ Function2<ProcessInfo, Continuation<? super Unit>, Object> $block;
                {
                    this.this$0 = $receiver;
                    this.$nodes = $nodes;
                    this.$block = $block;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2;
                    boolean bl;
                    Iterator<T> iterator2;
                    Function2<ProcessInfo, Continuation<? super Unit>, Object> function2;
                    DeviceMonitorController deviceMonitorController;
                    DeviceTreeNode rootNode;
                    Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$forEach$iv;
                            ResultKt.throwOnFailure((Object)object);
                            DefaultTreeModel defaultTreeModel = DeviceMonitorController.access$getModel$p(this.this$0).getTreeModel();
                            DeviceTreeNode deviceTreeNode = DeviceTreeNode.Companion.fromNode(defaultTreeModel != null ? defaultTreeModel.getRoot() : null);
                            if (deviceTreeNode == null) {
                                return Unit.INSTANCE;
                            }
                            rootNode = deviceTreeNode;
                            Iterable iterable = this.$nodes;
                            deviceMonitorController = this.this$0;
                            function2 = this.$block;
                            boolean $i$f$forEach = false;
                            iterator2 = $this$forEach$iv.iterator();
                            break;
                        }
                        case 1: {
                            void $result;
                            boolean $i$f$forEach = false;
                            bl = false;
                            iterator2 = (Iterator<T>)this.L$3;
                            function2 = (Function2<ProcessInfo, Continuation<? super Unit>, Object>)this.L$2;
                            deviceMonitorController = (DeviceMonitorController)this.L$1;
                            rootNode = (DeviceTreeNode)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
                    while (iterator2.hasNext()) {
                        ProcessInfoTreeNode processInfoNode;
                        T element$iv = iterator2.next();
                        ProcessTreeNode node = (ProcessTreeNode)element$iv;
                        bl = false;
                        if (ProcessInfoTreeNode.Companion.fromNode(node) == null || !Intrinsics.areEqual((Object)DeviceMonitorController.access$getModel$p(deviceMonitorController).getActiveDevice(), (Object)rootNode.getDevice())) continue;
                        this.L$0 = rootNode;
                        this.L$1 = deviceMonitorController;
                        this.L$2 = function2;
                        this.L$3 = iterator2;
                        this.label = 1;
                        object2 = function2.invoke((Object)processInfoNode.getProcessInfo(), (Object)((Object)this));
                        if (object2 != object3) continue;
                        return object3;
                    }
                    return Unit.INSTANCE;
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * Unable to fully structure code
         */
        private final Object loadNodeChildren(ProcessTreeNode var1_1, Continuation<? super Unit> var2_2) {
            if (!(var2_2 instanceof loadNodeChildren.1)) ** GOTO lbl-1000
            var6_3 = var2_2;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ ViewListener this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return ViewListener.access$loadNodeChildren(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (node.isLoaded()) {
                        return Unit.INSTANCE;
                    }
                    node.setLoaded(true);
                    v0 = node instanceof DeviceTreeNode != false ? (DeviceTreeNode)node : null;
                    if (v0 == null) {
                        return Unit.INSTANCE;
                    }
                    rootNode = v0;
                    $continuation.L$0 = this;
                    $continuation.L$1 = rootNode;
                    $continuation.label = 1;
                    v1 = DeviceMonitorController.access$getService$p(DeviceMonitorController.this).fetchProcessList(rootNode.getDevice(), (Continuation<? super List<ProcessInfo>>)$continuation);
                    if (v1 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl31
                }
                case 1: {
                    rootNode = (DeviceTreeNode)$continuation.L$1;
                    this = (ViewListener)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl31:
                    // 2 sources

                    processList = (List)v1;
                    if (Intrinsics.areEqual((Object)DeviceMonitorController.access$getModel$p(DeviceMonitorController.this).getActiveDevice(), (Object)rootNode.getDevice())) {
                        DeviceMonitorController.access$refreshProcessList(DeviceMonitorController.this, rootNode, processList);
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static final /* synthetic */ Object access$loadNodeChildren(ViewListener $this, ProcessTreeNode node, Continuation $completion) {
            return $this.loadNodeChildren(node, (Continuation<? super Unit>)$completion);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u0002H\u0096\u0001\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/device/monitor/DeviceMonitorController$ProcessInfoNameComparator;", "Ljava/util/Comparator;", "Lcom/android/tools/idea/device/monitor/processes/ProcessInfo;", "Lkotlin/Comparator;", "()V", "compare", "", "p0", "p1", "ProcessInfoNonNullComparator", "intellij.android.device-monitor-toolwindow"})
    public static final class ProcessInfoNameComparator
    implements Comparator<ProcessInfo> {
        @NotNull
        public static final ProcessInfoNameComparator INSTANCE = new ProcessInfoNameComparator();
        private final /* synthetic */ Comparator<ProcessInfo> $$delegate_0;

        private ProcessInfoNameComparator() {
            this.$$delegate_0 = ComparisonsKt.nullsFirst((Comparator)new ProcessInfoNonNullComparator());
        }

        @Override
        public int compare(@Nullable ProcessInfo p0, @Nullable ProcessInfo p1) {
            return this.$$delegate_0.compare(p0, p1);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/monitor/DeviceMonitorController$ProcessInfoNameComparator$ProcessInfoNonNullComparator;", "Ljava/util/Comparator;", "Lcom/android/tools/idea/device/monitor/processes/ProcessInfo;", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "intellij.android.device-monitor-toolwindow"})
        private static final class ProcessInfoNonNullComparator
        implements Comparator<ProcessInfo> {
            @Override
            public int compare(@NotNull ProcessInfo o1, @NotNull ProcessInfo o2) {
                Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                return ProcessInfoKt.isPidOnly(o1) && ProcessInfoKt.isPidOnly(o2) ? Intrinsics.compare((int)o1.getPid(), (int)o2.getPid()) : (ProcessInfoKt.isPidOnly(o1) ? 1 : (ProcessInfoKt.isPidOnly(o2) ? -1 : ProcessInfoKt.getSafeProcessName(o1).compareTo(ProcessInfoKt.getSafeProcessName(o2))));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/device/monitor/DeviceMonitorController$Companion;", "", "()V", "DEVICE_MONITOR_BUSY_MESSAGE", "", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/device/monitor/DeviceMonitorController;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "getProjectController", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.device-monitor-toolwindow"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final DeviceMonitorController getProjectController(@Nullable Project project) {
            Project project2 = project;
            return project2 != null ? (DeviceMonitorController)project2.getUserData(KEY) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeviceState.values().length];
            nArray[DeviceState.UNAUTHORIZED.ordinal()] = 1;
            nArray[DeviceState.OFFLINE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

