/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.monitor.ui;

import com.android.tools.idea.device.explorer.monitor.DeviceMonitorModel;
import com.android.tools.idea.device.explorer.monitor.DeviceMonitorModelListener;
import com.android.tools.idea.device.explorer.monitor.DeviceMonitorViewListener;
import com.android.tools.idea.device.explorer.monitor.ProcessTreeNode;
import com.android.tools.idea.device.explorer.monitor.ui.ComponentPopupMenu;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorActionsListener;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorPanel;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorView;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorViewImpl;
import com.android.tools.idea.device.explorer.monitor.ui.menu.item.ForceStopMenuItem;
import com.android.tools.idea.device.explorer.monitor.ui.menu.item.KillMenuItem;
import com.android.tools.idea.device.explorer.monitor.ui.menu.item.MenuContext;
import com.android.tools.idea.device.explorer.monitor.ui.menu.item.RefreshMenuItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\u0001$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\u0016\u0010\u001e\u001a\u00020\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0016\u0010 \u001a\u00020\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0016\u0010!\u001a\u00020\u00172\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\u0017H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorViewImpl;", "Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorView;", "Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorActionsListener;", "model", "Lcom/android/tools/idea/device/explorer/monitor/DeviceMonitorModel;", "(Lcom/android/tools/idea/device/explorer/monitor/DeviceMonitorModel;)V", "listeners", "", "Lcom/android/tools/idea/device/explorer/monitor/DeviceMonitorViewListener;", "modelListener", "Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorViewImpl$ModelListener;", "panel", "Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorPanel;", "panelComponent", "Ljavax/swing/JComponent;", "getPanelComponent", "()Ljavax/swing/JComponent;", "selectedNodes", "", "Lcom/android/tools/idea/device/explorer/monitor/ProcessTreeNode;", "getSelectedNodes", "()Ljava/util/List;", "addListener", "", "listener", "createToolbar", "createToolbarSubSection", "group", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createTreePopupMenu", "forceStopNodes", "treeNodes", "killNodes", "refreshNodes", "removeListener", "setup", "ModelListener", "intellij.android.device-explorer-monitor"})
public final class DeviceMonitorViewImpl
implements DeviceMonitorView,
DeviceMonitorActionsListener {
    @NotNull
    private final DeviceMonitorPanel panel;
    @NotNull
    private final List<DeviceMonitorViewListener> listeners;
    @NotNull
    private final ModelListener modelListener;

    public DeviceMonitorViewImpl(@NotNull DeviceMonitorModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.panel = new DeviceMonitorPanel();
        this.listeners = new ArrayList();
        this.modelListener = new ModelListener();
        model2.addListener(this.modelListener);
    }

    @Override
    @NotNull
    public JComponent getPanelComponent() {
        JPanel jPanel = this.panel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"panel.component");
        return jPanel;
    }

    @Override
    public void setup() {
        this.createTreePopupMenu();
        this.createToolbar();
    }

    @Override
    public void addListener(@NotNull DeviceMonitorViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceMonitorViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<ProcessTreeNode> getSelectedNodes() {
        Collection collection2;
        void $this$mapNotNullTo$iv$iv;
        TreePath[] paths;
        TreePath[] treePathArray = this.panel.getTree().getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        TreePath[] $this$mapNotNull$iv = paths = treePathArray;
        boolean $i$f$mapNotNull = false;
        TreePath[] treePathArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            ProcessTreeNode it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void path2 = element$iv$iv;
            boolean bl2 = false;
            if (ProcessTreeNode.Companion.fromNode(path2.getLastPathComponent()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nodes = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Collection collection3 = nodes;
        if (collection3.isEmpty()) {
            boolean bl = false;
            collection2 = null;
        } else {
            collection2 = collection3;
        }
        return (List)collection2;
    }

    @Override
    public void refreshNodes(@NotNull List<? extends ProcessTreeNode> treeNodes) {
        Intrinsics.checkNotNullParameter(treeNodes, (String)"treeNodes");
        this.listeners.forEach(refreshNodes.1.INSTANCE);
    }

    @Override
    public void killNodes(@NotNull List<? extends ProcessTreeNode> treeNodes) {
        Intrinsics.checkNotNullParameter(treeNodes, (String)"treeNodes");
        this.listeners.forEach(new Consumer(treeNodes){
            final /* synthetic */ List<ProcessTreeNode> $treeNodes;
            {
                this.$treeNodes = $treeNodes;
            }

            public final void accept(DeviceMonitorViewListener it) {
                it.killNodesInvoked(this.$treeNodes);
            }
        });
    }

    @Override
    public void forceStopNodes(@NotNull List<? extends ProcessTreeNode> treeNodes) {
        Intrinsics.checkNotNullParameter(treeNodes, (String)"treeNodes");
        this.listeners.forEach(new Consumer(treeNodes){
            final /* synthetic */ List<ProcessTreeNode> $treeNodes;
            {
                this.$treeNodes = $treeNodes;
            }

            public final void accept(DeviceMonitorViewListener it) {
                it.forceStopNodesInvoked(this.$treeNodes);
            }
        });
    }

    private final void createTreePopupMenu() {
        ComponentPopupMenu componentPopupMenu;
        Tree tree2 = this.panel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"panel.tree");
        ComponentPopupMenu $this$createTreePopupMenu_u24lambda_u2d2 = componentPopupMenu = new ComponentPopupMenu((JComponent)tree2);
        boolean bl = false;
        $this$createTreePopupMenu_u24lambda_u2d2.addItem(new ForceStopMenuItem(this, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u2d2.addItem(new KillMenuItem(this, MenuContext.Popup));
        $this$createTreePopupMenu_u24lambda_u2d2.install();
    }

    /*
     * WARNING - void declaration
     */
    private final void createToolbar() {
        void $this$createToolbar_u24lambda_u2d3;
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup = new DefaultActionGroup();
        DeviceMonitorViewImpl deviceMonitorViewImpl = this;
        boolean bl = false;
        $this$createToolbar_u24lambda_u2d3.add(new ForceStopMenuItem(this, MenuContext.Toolbar).getAction());
        $this$createToolbar_u24lambda_u2d3.add(new KillMenuItem(this, MenuContext.Toolbar).getAction());
        $this$createToolbar_u24lambda_u2d3.add(new RefreshMenuItem(this).getAction());
        deviceMonitorViewImpl.createToolbarSubSection(defaultActionGroup);
    }

    private final void createToolbarSubSection(DefaultActionGroup group2) {
        ActionToolbar actionToolbar;
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar $this$createToolbarSubSection_u24lambda_u2d4 = actionToolbar = actionManager.createActionToolbar("Device Monitor Toolbar", (ActionGroup)group2, true);
        boolean bl = false;
        $this$createToolbarSubSection_u24lambda_u2d4.setTargetComponent((JComponent)this.panel.getTree());
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"actionManager.createActi\u2026ponent = panel.tree\n    }");
        ActionToolbar actionToolbar3 = actionToolbar2;
        this.panel.getToolbar().add((Component)actionToolbar3.getComponent(), "West");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorViewImpl$ModelListener;", "Lcom/android/tools/idea/device/explorer/monitor/DeviceMonitorModelListener;", "(Lcom/android/tools/idea/device/explorer/monitor/ui/DeviceMonitorViewImpl;)V", "treeModelChanged", "", "newTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "newTreeSelectionModel", "Ljavax/swing/tree/DefaultTreeSelectionModel;", "intellij.android.device-explorer-monitor"})
    public final class ModelListener
    implements DeviceMonitorModelListener {
        @Override
        public void treeModelChanged(@Nullable DefaultTreeModel newTreeModel, @Nullable DefaultTreeSelectionModel newTreeSelectionModel) {
            Tree tree2 = DeviceMonitorViewImpl.this.panel.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)tree2, (String)"panel.tree");
            Tree tree3 = tree2;
            tree3.setModel((TreeModel)newTreeModel);
            tree3.setSelectionModel((TreeSelectionModel)newTreeSelectionModel);
            if (newTreeModel != null) {
                ProcessTreeNode rootNode = ProcessTreeNode.Companion.fromNode(newTreeModel.getRoot());
                if (rootNode != null) {
                    tree3.setRootVisible(false);
                    tree3.expandPath(new TreePath(rootNode.getPath()));
                } else {
                    tree3.setRootVisible(true);
                }
            }
        }
    }
}

