/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.monitor;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JO\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0006\"\u0004\b\u0001\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u0002H\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002JN\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\"\b\b\u0000\u0010\u0005*\u00020\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\r\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/TreeUtil;", "", "()V", "findIndexOfNextEntry", "", "T", "Ljavax/swing/tree/MutableTreeNode;", "U", "entries", "", "beginIndex", "treeNode", "ops", "Lcom/android/tools/idea/device/explorer/monitor/TreeUtil$UpdateChildrenOps;", "(Ljava/util/List;ILjavax/swing/tree/MutableTreeNode;Lcom/android/tools/idea/device/explorer/monitor/TreeUtil$UpdateChildrenOps;)I", "removeAllChildren", "", "node", "setAllowsChildren", "updateChildrenNodes", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "parentNode", "newEntries", "UpdateChildrenOps", "intellij.android.device-explorer-monitor"})
public final class TreeUtil {
    @NotNull
    public static final TreeUtil INSTANCE = new TreeUtil();

    private TreeUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends MutableTreeNode, U> List<T> updateChildrenNodes(@NotNull DefaultTreeModel treeModel, @NotNull MutableTreeNode parentNode, @NotNull List<? extends U> newEntries, @NotNull UpdateChildrenOps<T, U> ops) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)treeModel, (String)"treeModel");
        Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
        Intrinsics.checkNotNullParameter(newEntries, (String)"newEntries");
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        TreeUtil $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(TreeUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        logger2.debug("updateChildrenNodes(" + treeModel + ", " + parentNode + ", " + newEntries.size() + " nodes)");
        if (newEntries.isEmpty()) {
            this.removeAllChildren(parentNode);
            treeModel.nodeStructureChanged(parentNode);
            list2 = CollectionsKt.emptyList();
        } else if (parentNode.getChildCount() == 0) {
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv = newEntries;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void entry2;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator2.next();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(ops.mapEntry(entry2));
            }
            List nodes = (List)destination$iv$iv;
            this.removeAllChildren(parentNode);
            this.setAllowsChildren(parentNode);
            Iterable $this$forEach$iv = nodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MutableTreeNode x = (MutableTreeNode)element$iv;
                boolean bl3 = false;
                parentNode.insert(x, parentNode.getChildCount());
            }
            treeModel.nodeStructureChanged(parentNode);
            list2 = nodes;
        } else {
            boolean bl;
            List addedNodes = new ArrayList();
            int childIndex = 0;
            int childCount = parentNode.getChildCount();
            int newEntryIndex = 0;
            int newEntryCount = newEntries.size();
            while (newEntryIndex < newEntries.size() || childIndex < parentNode.getChildCount()) {
                boolean entry2;
                boolean item$iv$iv;
                boolean x;
                boolean bl2 = x = childIndex == newEntryIndex;
                if (_Assertions.ENABLED && !x) {
                    String bl3 = "Assertion failed";
                    throw new AssertionError((Object)bl3);
                }
                if (newEntryIndex >= newEntryCount) {
                    TreeNode treeNode = parentNode.getChildAt(childIndex);
                    Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.MutableTreeNode");
                    treeModel.removeNodeFromParent((MutableTreeNode)treeNode);
                    --childCount;
                    continue;
                }
                if (childIndex >= childCount) {
                    T newEntryNode = ops.mapEntry((void)newEntries.get(newEntryIndex));
                    addedNodes.add(newEntryNode);
                    this.setAllowsChildren(parentNode);
                    treeModel.insertNodeInto((MutableTreeNode)newEntryNode, parentNode, childIndex);
                    ++newEntryIndex;
                    ++childIndex;
                    ++childCount;
                    continue;
                }
                T childNode = ops.getChildNode(parentNode, childIndex);
                if (childNode == null) {
                    TreeNode treeNode = parentNode.getChildAt(childIndex);
                    Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.MutableTreeNode");
                    treeModel.removeNodeFromParent((MutableTreeNode)treeNode);
                    --childCount;
                    continue;
                }
                int compareResult = ops.compareNodesForSorting(childNode, (void)newEntries.get(newEntryIndex));
                if (compareResult == 0) {
                    if (!ops.equals(childNode, (void)newEntries.get(newEntryIndex))) {
                        treeModel.nodeChanged((TreeNode)childNode);
                    }
                    ops.updateNode(childNode, (void)newEntries.get(newEntryIndex));
                    ++childIndex;
                    ++newEntryIndex;
                    continue;
                }
                if (compareResult < 0) {
                    TreeNode treeNode = parentNode.getChildAt(childIndex);
                    Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type javax.swing.tree.MutableTreeNode");
                    treeModel.removeNodeFromParent((MutableTreeNode)treeNode);
                    --childCount;
                    continue;
                }
                boolean bl4 = item$iv$iv = compareResult > 0;
                if (_Assertions.ENABLED && !item$iv$iv) {
                    String entry2 = "Assertion failed";
                    throw new AssertionError((Object)entry2);
                }
                int nextIndex = this.findIndexOfNextEntry((List<? extends U>)newEntries, newEntryIndex + 1, childNode, ops);
                boolean bl5 = entry2 = nextIndex >= newEntryIndex + 1;
                if (_Assertions.ENABLED && !entry2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                boolean bl6 = entry2 = nextIndex <= newEntries.size();
                if (_Assertions.ENABLED && !entry2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                while (newEntryIndex < nextIndex) {
                    T newChildNode = ops.mapEntry((void)newEntries.get(newEntryIndex));
                    addedNodes.add(newChildNode);
                    treeModel.insertNodeInto((MutableTreeNode)newChildNode, parentNode, childIndex);
                    ++childIndex;
                    ++childCount;
                    ++newEntryIndex;
                }
            }
            boolean bl7 = bl = childIndex == newEntryIndex;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl8 = bl = childCount == newEntryCount;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            list2 = addedNodes;
        }
        return list2;
    }

    private final <T extends MutableTreeNode, U> int findIndexOfNextEntry(List<? extends U> entries2, int beginIndex, T treeNode, UpdateChildrenOps<T, U> ops) {
        int n = entries2.size();
        for (int i = beginIndex; i < n; ++i) {
            if (ops.compareNodesForSorting(treeNode, entries2.get(i)) > 0) continue;
            return i;
        }
        return entries2.size();
    }

    private final void removeAllChildren(MutableTreeNode node) {
        for (int i = node.getChildCount() - 1; -1 < i; --i) {
            node.remove(i);
        }
    }

    private final void setAllowsChildren(MutableTreeNode node) {
        if (node instanceof DefaultMutableTreeNode) {
            ((DefaultMutableTreeNode)node).setAllowsChildren(true);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/device/explorer/monitor/TreeUtil$UpdateChildrenOps;", "T", "Ljavax/swing/tree/MutableTreeNode;", "U", "", "compareNodesForSorting", "", "node", "entry", "(Ljavax/swing/tree/MutableTreeNode;Ljava/lang/Object;)I", "equals", "", "(Ljavax/swing/tree/MutableTreeNode;Ljava/lang/Object;)Z", "getChildNode", "parentNode", "index", "(Ljavax/swing/tree/MutableTreeNode;I)Ljavax/swing/tree/MutableTreeNode;", "mapEntry", "(Ljava/lang/Object;)Ljavax/swing/tree/MutableTreeNode;", "updateNode", "", "(Ljavax/swing/tree/MutableTreeNode;Ljava/lang/Object;)V", "intellij.android.device-explorer-monitor"})
    public static interface UpdateChildrenOps<T extends MutableTreeNode, U> {
        @Nullable
        public T getChildNode(@NotNull MutableTreeNode var1, int var2);

        @NotNull
        public T mapEntry(U var1);

        public int compareNodesForSorting(@NotNull T var1, U var2);

        public boolean equals(@NotNull T var1, U var2);

        public void updateNode(@NotNull T var1, U var2);
    }
}

