/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files.adbimpl;

import com.android.tools.idea.device.explorer.files.adbimpl.AdbPathUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbFileListingEntry {
    @NotNull
    private static Logger LOGGER = Logger.getInstance(AdbFileListingEntry.class);
    @NotNull
    private final String myPath;
    @NotNull
    private final EntryKind myKind;
    @Nullable
    private final String myPermissions;
    @Nullable
    private final String myOwner;
    @Nullable
    private final String myGroup;
    @Nullable
    private final String myDate;
    @Nullable
    private final String myTime;
    @Nullable
    private final String mySize;
    @Nullable
    private final String myExtraInfo;

    public AdbFileListingEntry(@NotNull String path2, @NotNull EntryKind kind, @Nullable String permissions, @Nullable String owner, @Nullable String group2, @Nullable String date, @Nullable String time2, @Nullable String size, @Nullable String extraInfo) {
        this.myPath = path2;
        this.myKind = kind;
        this.myPermissions = permissions;
        this.myOwner = owner;
        this.myGroup = group2;
        this.myDate = date;
        this.myTime = time2;
        this.mySize = size;
        this.myExtraInfo = extraInfo;
    }

    public String toString() {
        return String.format("%s: %s", new Object[]{this.myKind, this.myPath});
    }

    @NotNull
    public String getFullPath() {
        return this.myPath;
    }

    @NotNull
    public String getName() {
        return AdbPathUtil.getFileName(this.myPath);
    }

    @NotNull
    public EntryKind getKind() {
        return this.myKind;
    }

    @Nullable
    public String getPermissions() {
        return this.myPermissions;
    }

    @Nullable
    public String getOwner() {
        return this.myOwner;
    }

    @Nullable
    public String getGroup() {
        return this.myGroup;
    }

    @Nullable
    public String getDate() {
        return this.myDate;
    }

    @Nullable
    public String getTime() {
        return this.myTime;
    }

    public long getSize() {
        String size = this.mySize;
        if (StringUtil.isEmpty((String)size)) {
            return -1L;
        }
        int index2 = size.indexOf(44);
        if (index2 >= 0) {
            return -1L;
        }
        try {
            return Long.parseLong(size);
        }
        catch (NumberFormatException e) {
            LOGGER.warn(String.format("Error paring size string \"%s\"", size), (Throwable)e);
            return -1L;
        }
    }

    @Nullable
    public String getInfo() {
        return this.myExtraInfo;
    }

    public boolean isDirectory() {
        return this.myKind == EntryKind.DIRECTORY;
    }

    public boolean isFile() {
        return this.myKind == EntryKind.FILE;
    }

    public boolean isSymbolicLink() {
        return this.myKind == EntryKind.SYMBOLIC_LINK;
    }

    public static enum EntryKind {
        FILE,
        DIRECTORY,
        SYMBOLIC_LINK,
        BLOCK,
        CHARACTER,
        SOCKET,
        FIFO,
        OTHER;

    }
}

