/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.files;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.device.explorer.files.CoroutineContextUtilKt;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFileManager;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFileManagerImpl;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFilesUtils;
import com.android.tools.idea.device.explorer.files.fs.DeviceFileEntry;
import com.android.tools.idea.device.explorer.files.fs.DeviceFileSystem;
import com.android.tools.idea.device.explorer.files.fs.DownloadProgress;
import com.android.tools.idea.device.explorer.files.fs.FileTransferProgress;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.PathUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001+B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J)\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ)\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0007H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\u0019\u0010)\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManagerImpl;", "Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultDownloadPathSupplier", "Lkotlin/Function0;", "Ljava/nio/file/Path;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "temporaryEditorFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "createFileTransferProgress", "Lcom/android/tools/idea/device/explorer/files/fs/FileTransferProgress;", "entry", "Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileEntry;", "progress", "Lcom/android/tools/idea/device/explorer/files/fs/DownloadProgress;", "deleteFile", "", "virtualFile", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteTemporaryFile", "localPath", "deleteVirtualFile", "downloadFile", "(Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileEntry;Ljava/nio/file/Path;Lcom/android/tools/idea/device/explorer/files/fs/DownloadProgress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadFileEntry", "getDefaultLocalPathForDevice", "device", "Lcom/android/tools/idea/device/explorer/files/fs/DeviceFileSystem;", "getDefaultLocalPathForEntry", "getPathForEntry", "file", "destinationPath", "mapName", "", "name", "openFile", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MyFileEditorManagerAdapter", "intellij.android.device-explorer-files"})
public final class DeviceExplorerFileManagerImpl
implements DeviceExplorerFileManager {
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<Path> defaultDownloadPathSupplier;
    @NotNull
    private final Logger LOGGER;
    @NotNull
    private final List<VirtualFile> temporaryEditorFiles;

    @NonInjectable
    @VisibleForTesting
    public DeviceExplorerFileManagerImpl(@NotNull Project project, @NotNull Function0<? extends Path> defaultDownloadPathSupplier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(defaultDownloadPathSupplier, (String)"defaultDownloadPathSupplier");
        this.project = project;
        this.defaultDownloadPathSupplier = defaultDownloadPathSupplier;
        DeviceExplorerFileManagerImpl $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(DeviceExplorerFileManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        this.LOGGER = logger2;
        this.temporaryEditorFiles = new ArrayList();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new MyFileEditorManagerAdapter());
    }

    private DeviceExplorerFileManagerImpl(Project project) {
        this(project, (Function0<? extends Path>)((Function0)1.INSTANCE));
    }

    @NotNull
    public final Path getDefaultLocalPathForDevice(@NotNull DeviceFileSystem device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Path rootPath = (Path)this.defaultDownloadPathSupplier.invoke();
        Path path2 = rootPath.resolve(this.mapName(device2.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"rootPath.resolve(mapName(device.name))");
        return path2;
    }

    @Override
    @NotNull
    public Path getDefaultLocalPathForEntry(@NotNull DeviceFileEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Path devicePath = this.getDefaultLocalPathForDevice(entry.getFileSystem());
        return this.getPathForEntry(entry, devicePath);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object downloadFileEntry(@NotNull DeviceFileEntry var1_1, @NotNull Path var2_2, @NotNull DownloadProgress var3_3, @NotNull Continuation<? super VirtualFile> var4_4) {
        if (!(var4_4 instanceof downloadFileEntry.1)) ** GOTO lbl-1000
        var6_5 = var4_4;
        if ((var6_5.label & -2147483648) != 0) {
            var6_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadFileEntry(null, null, null, (Continuation<? super VirtualFile>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = entry;
                $continuation.L$2 = localPath;
                $continuation.L$3 = progress;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getDiskIoThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super File>, Object>(localPath, null){
                    int label;
                    final /* synthetic */ Path $localPath;
                    {
                        this.$localPath = $localPath;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return FileUtils.mkdirs((File)this.$localPath.getParent().toFile());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super File> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var7_7) {
                    return var7_7;
                }
                ** GOTO lbl28
            }
            case 1: {
                progress = (DownloadProgress)$continuation.L$3;
                localPath = (Path)$continuation.L$2;
                entry = (DeviceFileEntry)$continuation.L$1;
                this = (DeviceExplorerFileManagerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v1 = CoroutineContextUtilKt.withWriteSafeContextWithCurrentModality((Function2)new Function2<CoroutineScope, Continuation<? super VirtualFile>, Object>(localPath, this, entry, progress, null){
                    int label;
                    final /* synthetic */ Path $localPath;
                    final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                    final /* synthetic */ DeviceFileEntry $entry;
                    final /* synthetic */ DownloadProgress $progress;
                    {
                        this.$localPath = $localPath;
                        this.this$0 = $receiver;
                        this.$entry = $entry;
                        this.$progress = $progress;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                v0 = VfsUtil.findFileByIoFile((File)this.$localPath.toFile(), (boolean)true);
                                if (v0 != null) {
                                    var2_3 = v0;
                                    var3_4 = this.this$0;
                                    it = var2_3;
                                    $i$a$-let-DeviceExplorerFileManagerImpl$downloadFileEntry$3$1 = false;
                                    this.label = 1;
                                    v1 = CoroutinesUtilsKt.runWriteActionAndWait((Computable)new Computable(var3_4, it){
                                        final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                                        final /* synthetic */ VirtualFile $it;
                                        {
                                            this.this$0 = $receiver;
                                            this.$it = $it;
                                        }

                                        public final void compute() {
                                            VirtualFile virtualFile = this.$it;
                                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                                            DeviceExplorerFileManagerImpl.access$deleteVirtualFile(this.this$0, virtualFile);
                                        }
                                    }, (Continuation)this);
                                    if (v1 == var6_2) {
                                        return var6_2;
                                    }
                                }
                                ** GOTO lbl21
                            }
                            case 1: {
                                $i$a$-let-DeviceExplorerFileManagerImpl$downloadFileEntry$3$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                this.label = 2;
                                v2 = DeviceExplorerFileManagerImpl.access$downloadFile(this.this$0, this.$entry, this.$localPath, this.$progress, (Continuation)this);
                                if (v2 == var6_2) {
                                    return var6_2;
                                }
                                ** GOTO lbl29
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl29:
                                // 2 sources

                                return v2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super VirtualFile> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                if (v1 == var7_7) {
                    return var7_7;
                }
                ** GOTO lbl40
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object deleteFile(@NotNull VirtualFile virtualFile, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineContextUtilKt.withWriteSafeContextWithCurrentModality((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, virtualFile, null){
            int label;
            final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ApplicationManager.getApplication().runWriteAction(new Runnable(this.this$0, this.$virtualFile){
                            final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                            final /* synthetic */ VirtualFile $virtualFile;
                            {
                                this.this$0 = $receiver;
                                this.$virtualFile = $virtualFile;
                            }

                            public final void run() {
                                DeviceExplorerFileManagerImpl.access$deleteVirtualFile(this.this$0, this.$virtualFile);
                            }
                        });
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void deleteVirtualFile(VirtualFile virtualFile) throws IOException {
        TransactionGuard transactionGuard = TransactionGuard.getInstance();
        Intrinsics.checkNotNull((Object)transactionGuard, (String)"null cannot be cast to non-null type com.intellij.openapi.application.TransactionGuardImpl");
        ((TransactionGuardImpl)transactionGuard).assertWriteActionAllowed();
        virtualFile.delete((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @UiThread
    private final Object downloadFile(DeviceFileEntry var1_1, Path var2_2, DownloadProgress var3_3, Continuation<? super VirtualFile> var4_4) {
        if (!(var4_4 instanceof downloadFile.1)) ** GOTO lbl-1000
        var8_5 = var4_4;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DeviceExplorerFileManagerImpl.access$downloadFile(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                fileTransferProgress = this.createFileTransferProgress(entry, progress);
                progress.onStarting(entry.getFullPath());
                $continuation.L$0 = this;
                $continuation.L$1 = entry;
                $continuation.L$2 = localPath;
                $continuation.L$3 = progress;
                $continuation.label = 1;
                v0 = entry.downloadFile(localPath, fileTransferProgress, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var9_7) goto lbl24
lbl23:
                // 1 sources

                return var9_7;
lbl24:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                progress = (DownloadProgress)$continuation.L$3;
                localPath = (Path)$continuation.L$2;
                entry = (DeviceFileEntry)$continuation.L$1;
                this = (DeviceExplorerFileManagerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = entry;
                $continuation.L$2 = localPath;
                $continuation.L$3 = progress;
                $continuation.label = 2;
                v1 = DeviceExplorerFilesUtils.INSTANCE.findFile(localPath, (Continuation<? super VirtualFile>)$continuation);
                ** if (v1 != var9_7) goto lbl42
lbl41:
                // 1 sources

                return var9_7;
lbl42:
                // 1 sources

                ** GOTO lbl52
            }
            case 2: {
                progress = (DownloadProgress)$continuation.L$3;
                localPath = (Path)$continuation.L$2;
                entry = (DeviceFileEntry)$continuation.L$1;
                this = (DeviceExplorerFileManagerImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl52:
                    // 2 sources

                    var6_9 = v1;
                    return var6_9;
                }
                catch (Throwable t) {
                    this.deleteTemporaryFile(localPath);
                    throw t;
                }
            }
            catch (Throwable var6_11) {
                throw var6_11;
            }
            {
                finally {
                    progress.onCompleted(entry.getFullPath());
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final FileTransferProgress createFileTransferProgress(DeviceFileEntry entry, DownloadProgress progress2) {
        return new FileTransferProgress(progress2, entry){
            final /* synthetic */ DownloadProgress $progress;
            final /* synthetic */ DeviceFileEntry $entry;
            {
                this.$progress = $progress;
                this.$entry = $entry;
            }

            @UiThread
            public void progress(long currentBytes, long totalBytes) {
                this.$progress.onProgress(this.$entry.getFullPath(), currentBytes, totalBytes);
            }

            @WorkerThread
            public boolean isCancelled() {
                return this.$progress.isCancelled();
            }
        };
    }

    @Override
    @NotNull
    public Path getPathForEntry(@NotNull DeviceFileEntry file2, @NotNull Path destinationPath) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)destinationPath, (String)"destinationPath");
        List entryPathComponents = new ArrayList();
        for (DeviceFileEntry entry = file2; entry != null; entry = entry.getParent()) {
            entryPathComponents.add(this.mapName(entry.getName()));
        }
        CollectionsKt.reverse((List)entryPathComponents);
        Path entryDestinationPath = destinationPath;
        for (String name : entryPathComponents) {
            Intrinsics.checkNotNullExpressionValue((Object)entryDestinationPath.resolve(name), (String)"entryDestinationPath.resolve(name)");
        }
        return entryDestinationPath;
    }

    private final String mapName(String name) {
        String string = PathUtilRt.suggestFileName((String)name, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestFileName(name,  /\u2026ue,  /*allowSpaces*/true)");
        return string;
    }

    private final void deleteTemporaryFile(Path localPath) {
        try {
            Files.deleteIfExists(localPath);
        }
        catch (IOException e) {
            this.LOGGER.warn("Error deleting device file from local file system \"" + localPath + "\"", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object openFile(@NotNull Path var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof openFile.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.openFile(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = DeviceExplorerFilesUtils.INSTANCE.findFile((Path)localPath, (Continuation<? super VirtualFile>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (DeviceExplorerFileManagerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                file = (VirtualFile)v0;
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(file, this, null){
                    int label;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ DeviceExplorerFileManagerImpl this$0;
                    {
                        this.$file = $file;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                if (FileTypeChooser.getKnownFileTypeOrAssociate((VirtualFile)this.$file, (Project)DeviceExplorerFileManagerImpl.access$getProject$p(this.this$0)) != null) break;
                                this.label = 1;
                                Object object3 = CoroutineContextUtilKt.cancelAndThrow((Continuation)this);
                                if (object3 != object2) throw new KotlinNothingValueException();
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                throw new KotlinNothingValueException();
                            }
                        }
                        OpenFileAction.openFile((VirtualFile)this.$file, (Project)DeviceExplorerFileManagerImpl.access$getProject$p(this.this$0));
                        return Boxing.boxBoolean((boolean)DeviceExplorerFileManagerImpl.access$getTemporaryEditorFiles$p(this.this$0).add(this.$file));
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl32
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$downloadFile(DeviceExplorerFileManagerImpl $this, DeviceFileEntry entry, Path localPath, DownloadProgress progress2, Continuation $completion) {
        return $this.downloadFile(entry, localPath, progress2, (Continuation<? super VirtualFile>)$completion);
    }

    public static final /* synthetic */ void access$deleteVirtualFile(DeviceExplorerFileManagerImpl $this, VirtualFile virtualFile) {
        $this.deleteVirtualFile(virtualFile);
    }

    public static final /* synthetic */ Project access$getProject$p(DeviceExplorerFileManagerImpl $this) {
        return $this.project;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManagerImpl$MyFileEditorManagerAdapter;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "(Lcom/android/tools/idea/device/explorer/files/DeviceExplorerFileManagerImpl;)V", "fileClosed", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.android.device-explorer-files"})
    private final class MyFileEditorManagerAdapter
    implements FileEditorManagerListener {
        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (DeviceExplorerFileManagerImpl.this.temporaryEditorFiles.contains(file2)) {
                DeviceExplorerFileManagerImpl.this.temporaryEditorFiles.remove(file2);
                Path localPath = Paths.get(file2.getPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)localPath, (String)"localPath");
                DeviceExplorerFileManagerImpl.this.deleteTemporaryFile(localPath);
            }
        }
    }
}

