/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.AndroidEnvironmentUtils;
import com.android.tools.idea.device.explorer.DeviceExplorerController;
import com.android.tools.idea.device.explorer.DeviceExplorerModel;
import com.android.tools.idea.device.explorer.files.DeviceExplorerFileManager;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerController;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerModel;
import com.android.tools.idea.device.explorer.files.DeviceFileExplorerView;
import com.android.tools.idea.device.explorer.files.ui.DeviceFileExplorerViewImpl;
import com.android.tools.idea.device.explorer.monitor.DeviceMonitorController;
import com.android.tools.idea.device.explorer.monitor.DeviceMonitorModel;
import com.android.tools.idea.device.explorer.monitor.adbimpl.AdbDeviceService;
import com.android.tools.idea.device.explorer.monitor.processes.DeviceProcessService;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorView;
import com.android.tools.idea.device.explorer.monitor.ui.DeviceMonitorViewImpl;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerViewImpl;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import icons.StudioIcons;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/device/explorer/DeviceExplorerToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "()V", "createDeviceFilesController", "Lcom/android/tools/idea/device/explorer/files/DeviceFileExplorerController;", "project", "Lcom/intellij/openapi/project/Project;", "createDeviceMonitorController", "Lcom/android/tools/idea/device/explorer/monitor/DeviceMonitorController;", "createToolWindowContent", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "isApplicable", "", "Companion", "intellij.android.device-explorer"})
public final class DeviceExplorerToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TOOL_WINDOW_ID = "Device Explorer";

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object t = StudioFlags.MERGED_DEVICE_FILE_EXPLORER_AND_DEVICE_MONITOR_TOOL_WINDOW_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"MERGED_DEVICE_FILE_EXPLO\u2026TOOL_WINDOW_ENABLED.get()");
        return (Boolean)t != false && AndroidEnvironmentUtils.isAndroidEnvironment((Project)project);
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setIcon(StudioIcons.Shell.ToolWindows.DEVICE_EXPLORER);
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(TOOL_WINDOW_ID);
        DeviceExplorerModel model2 = new DeviceExplorerModel(project);
        DeviceExplorerViewImpl view = new DeviceExplorerViewImpl(project, model2, TOOL_WINDOW_ID);
        DeviceMonitorController deviceMonitorController = this.createDeviceMonitorController(project);
        DeviceFileExplorerController deviceFilesController = this.createDeviceFilesController(project);
        DeviceExplorerController deviceExplorerController = new DeviceExplorerController(project, model2, view, deviceFilesController, deviceMonitorController);
        deviceExplorerController.setup();
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        Content content2 = contentManager2.getFactory().createContent(view.getComponent(), "", true);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"contentManager.factory.c\u2026view.component, \"\", true)");
        Content toolWindowContent = content2;
        contentManager2.addContent(toolWindowContent);
    }

    private final DeviceMonitorController createDeviceMonitorController(Project project) {
        AdbDeviceService adbService2 = (AdbDeviceService)project.getService(AdbDeviceService.class);
        DeviceProcessService processService = (DeviceProcessService)project.getService(DeviceProcessService.class);
        Intrinsics.checkNotNullExpressionValue((Object)processService, (String)"processService");
        DeviceMonitorModel model2 = new DeviceMonitorModel(processService);
        DeviceMonitorViewImpl view = new DeviceMonitorViewImpl(model2);
        DeviceMonitorView deviceMonitorView = view;
        Intrinsics.checkNotNullExpressionValue((Object)adbService2, (String)"adbService");
        return new DeviceMonitorController(project, model2, deviceMonitorView, adbService2);
    }

    private final DeviceFileExplorerController createDeviceFilesController(Project project) {
        DeviceExplorerFileManager fileManager = (DeviceExplorerFileManager)project.getService(DeviceExplorerFileManager.class);
        DeviceFileExplorerModel model2 = new DeviceFileExplorerModel();
        DeviceFileExplorerViewImpl view = new DeviceFileExplorerViewImpl(project, model2, TOOL_WINDOW_ID);
        DeviceFileExplorerView deviceFileExplorerView = view;
        Intrinsics.checkNotNullExpressionValue((Object)fileManager, (String)"fileManager");
        return new DeviceFileExplorerController(project, model2, deviceFileExplorerView, fileManager, new DeviceFileExplorerController.FileOpener(fileManager){
            final /* synthetic */ DeviceExplorerFileManager $fileManager;
            {
                this.$fileManager = $fileManager;
            }

            @UiThread
            @Nullable
            public Object openFile(@NotNull Path localPath, @NotNull Continuation<? super Unit> $completion) {
                Object object = this.$fileManager.openFile(localPath, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/device/explorer/DeviceExplorerToolWindowFactory$Companion;", "", "()V", "TOOL_WINDOW_ID", "", "intellij.android.device-explorer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

