/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debuggers.coroutine;

import com.android.tools.idea.debuggers.coroutine.CoroutineDebuggerListener;
import com.android.tools.idea.debuggers.coroutine.FlagController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebuggerManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/debuggers/coroutine/CoroutineDebuggerProjectListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "()V", "associatedProject", "Lcom/intellij/openapi/project/Project;", "projectOpened", "", "project", "intellij.android.debuggers"})
public final class CoroutineDebuggerProjectListener
implements ProjectManagerListener {
    @Nullable
    private Project associatedProject;

    public void projectOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!FlagController.INSTANCE.isCoroutineDebuggerEnabled().booleanValue()) {
            return;
        }
        if (this.associatedProject != null) {
            return;
        }
        this.associatedProject = project;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)project);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(project)");
        MessageBusConnection connection2 = messageBusConnection;
        CoroutineDebuggerListener executionListener = new CoroutineDebuggerListener(project);
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection2.subscribe(topic, (Object)executionListener);
    }
}

