/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.annotations.concurrency.UiThread;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.debug.DesugarUtils;
import com.android.tools.idea.editors.AttachAndroidSdkSourcesNotificationProvider;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Suppliers;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0003&'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0017J\"\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010\u00152\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager;", "Lcom/intellij/debugger/engine/PositionManagerImpl;", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "debugSessionListenerRegistered", "", "myAndroidVersion", "Lcom/android/sdklib/AndroidVersion;", "myGeneratedPsiFile", "Lcom/intellij/psi/PsiFile;", "mySourceFolder", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/vfs/VirtualFile;", "createGeneratedPsiFile", "createPrepareRequests", "", "Lcom/sun/jdi/request/ClassPrepareRequest;", "requestor", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "position", "Lcom/intellij/debugger/SourcePosition;", "createSourcePackageForApiLevel", "refreshIfNeeded", "getAcceptedFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "getAllClasses", "Lcom/sun/jdi/ReferenceType;", "getGeneratedFileSourcePosition", "project", "Lcom/intellij/openapi/project/Project;", "getPsiFileByLocation", "location", "Lcom/sun/jdi/Location;", "getSourceFileForApiLevel", "file", "getSourcePosition", "AttachSourcesCallback", "Companion", "MyXDebugSessionListener", "intellij.android.debuggers"})
public final class AndroidPositionManager
extends PositionManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DebugProcessImpl myDebugProcess;
    @Nullable
    private final AndroidVersion myAndroidVersion;
    @NotNull
    private Supplier<VirtualFile> mySourceFolder;
    @Nullable
    private PsiFile myGeneratedPsiFile;
    private boolean debugSessionListenerRegistered;
    @org.intellij.lang.annotations.Language(value="JAVA")
    private static final String GENERATED_FILE_CONTENTS_FORMAT;
    @NotNull
    private static final String GENERATED_FILE_NAME = "Unavailable Source";
    @NotNull
    private static final Logger LOG;

    public AndroidPositionManager(@NotNull DebugProcessImpl myDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)myDebugProcess, (String)"myDebugProcess");
        super(myDebugProcess);
        this.myDebugProcess = myDebugProcess;
        this.myAndroidVersion = (AndroidVersion)this.myDebugProcess.getProcessHandler().getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
        com.google.common.base.Supplier supplier2 = Suppliers.memoize((com.google.common.base.Supplier)new com.google.common.base.Supplier(this){
            final /* synthetic */ AndroidPositionManager this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public final VirtualFile get() {
                return AndroidPositionManager.access$createSourcePackageForApiLevel(this.this$0, false);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"memoize { createSourcePackageForApiLevel(false) }");
        this.mySourceFolder = (Supplier)supplier2;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        List<ReferenceType> list2 = DesugarUtils.addExtraClassesIfNeeded((DebugProcess)this.myDebugProcess, position, super.getAllClasses(position), (PositionManager)this);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"addExtraClassesIfNeeded(\u2026lClasses(position), this)");
        List<ReferenceType> referenceTypes = list2;
        if (referenceTypes.isEmpty()) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        return referenceTypes;
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        List<ClassPrepareRequest> list2 = DesugarUtils.addExtraPrepareRequestsIfNeeded((DebugProcess)this.myDebugProcess, requestor, position, super.createPrepareRequests(requestor, position));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"addExtraPrepareRequestsI\u2026sts(requestor, position))");
        List<ClassPrepareRequest> requests2 = list2;
        if (requests2.isEmpty()) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        return requests2;
    }

    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        return SetsKt.setOf((Object)JavaFileType.INSTANCE);
    }

    @Nullable
    public SourcePosition getSourcePosition(@Nullable Location location2) throws NoDataException {
        if (location2 == null) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        if (this.myAndroidVersion == null) {
            LOG.debug("getSourcePosition cannot determine version from device.");
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        Project project = this.myDebugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myDebugProcess.project");
        Project project2 = project;
        PsiFile file2 = this.getPsiFileByLocation(project2, location2);
        if (file2 == null || !AndroidSdks.getInstance().isInAndroidSdk((PsiElement)file2)) {
            NoDataException noDataException = NoDataException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)noDataException, (String)"INSTANCE");
            throw (Throwable)noDataException;
        }
        SourcePosition sourcePosition = this.getSourceFileForApiLevel(project2, file2, location2);
        if (sourcePosition == null) {
            sourcePosition = this.getGeneratedFileSourcePosition(project2);
        }
        return sourcePosition;
    }

    @VisibleForTesting
    @Nullable
    public PsiFile getPsiFileByLocation(@NotNull Project project, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return super.getPsiFileByLocation(project, location2);
    }

    private final SourcePosition getSourceFileForApiLevel(Project project, PsiFile file2, Location location2) {
        String relPath = Companion.getRelPathForJavaSource(project, file2);
        if (relPath == null) {
            LOG.debug("getApiSpecificPsi returned null because relPath is null for file: " + file2.getName());
            return null;
        }
        VirtualFile virtualFile = this.mySourceFolder.get();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile sourceFolder = virtualFile;
        VirtualFile vfile = sourceFolder.findFileByRelativePath(relPath);
        if (vfile == null) {
            LOG.debug("getSourceForApiLevel returned null because " + relPath + " is not present in " + sourceFolder);
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vfile);
        if (psiFile == null) {
            return null;
        }
        PsiFile apiSpecificSourceFile = psiFile;
        int lineNumber = DebuggerUtilsEx.getLineNumber((Location)location2, (boolean)true);
        return SourcePosition.createFromLine((PsiFile)apiSpecificSourceFile, (int)lineNumber);
    }

    private final SourcePosition getGeneratedFileSourcePosition(Project project) {
        if (this.myGeneratedPsiFile == null) {
            this.myGeneratedPsiFile = this.createGeneratedPsiFile();
        }
        PsiFile psiFile = this.myGeneratedPsiFile;
        if (psiFile == null) {
            return null;
        }
        PsiFile generatedPsiFile = psiFile;
        if (!this.debugSessionListenerRegistered) {
            this.debugSessionListenerRegistered = true;
            XDebugSession xDebugSession = this.myDebugProcess.getSession().getXDebugSession();
            if (xDebugSession != null) {
                VirtualFile virtualFile = generatedPsiFile.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"generatedPsiFile.virtualFile");
                xDebugSession.addSessionListener((XDebugSessionListener)new MyXDebugSessionListener(virtualFile, project));
            } else {
                LOG.debug("xDebugSession unavailable.");
            }
        }
        return SourcePosition.createFromLine((PsiFile)generatedPsiFile, (int)-1);
    }

    private final PsiFile createGeneratedPsiFile() {
        if (this.myAndroidVersion == null) {
            return null;
        }
        int apiLevel = this.myAndroidVersion.getApiLevel();
        Locale locale = Locale.getDefault();
        String string = GENERATED_FILE_CONTENTS_FORMAT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GENERATED_FILE_CONTENTS_FORMAT");
        String string2 = string;
        Object[] objectArray = new Object[]{apiLevel};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        String fileContent = string3;
        PsiFile generatedPsiFile = PsiFileFactory.getInstance((Project)this.myDebugProcess.getProject()).createFileFromText(GENERATED_FILE_NAME, (Language)JavaLanguage.INSTANCE, (CharSequence)fileContent, true, true);
        VirtualFile generatedVirtualFile = generatedPsiFile.getVirtualFile();
        try {
            generatedVirtualFile.setWritable(false);
        }
        catch (IOException e) {
            LOG.info("Unable to set generated file not writable.", (Throwable)e);
        }
        AttachSourcesCallback attachSourcesCallback = new AttachSourcesCallback(this.myAndroidVersion);
        generatedVirtualFile.putUserData(AttachAndroidSdkSourcesNotificationProvider.REQUIRED_SOURCES_KEY, (Object)attachSourcesCallback);
        return generatedPsiFile;
    }

    private final VirtualFile createSourcePackageForApiLevel(boolean refreshIfNeeded) {
        if (this.myAndroidVersion == null) {
            return null;
        }
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance().tryToChooseSdkHandler()");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(AndroidPositionManager.class));
        for (LocalPackage sourcePackage : sdkManager.getPackages().getLocalPackagesForPrefix("sources")) {
            VirtualFile sourceFolder;
            TypeDetails typeDetails = sourcePackage.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.ApiDetailsType)) {
                LOG.warn("Unable to get type details for source package @ " + sourcePackage.getLocation());
                continue;
            }
            if (!Intrinsics.areEqual((Object)this.myAndroidVersion, (Object)((DetailsTypes.ApiDetailsType)typeDetails).getAndroidVersion())) continue;
            VirtualFile virtualFile = sourceFolder = VfsUtil.findFile((Path)sourcePackage.getLocation(), (boolean)refreshIfNeeded);
            boolean bl = virtualFile != null ? virtualFile.isValid() : false;
            if (!bl) continue;
            return sourceFolder;
        }
        return null;
    }

    public static final /* synthetic */ PsiFile access$getMyGeneratedPsiFile$p(AndroidPositionManager $this) {
        return $this.myGeneratedPsiFile;
    }

    static {
        Object[] objectArray = new Object[]{" * Android SDK source code for this API level cannot be found.", " ********************************************************************/"};
        GENERATED_FILE_CONTENTS_FORMAT = Joiner.on((String)System.lineSeparator()).join((Object)"/*********************************************************************", (Object)" * The Android SDK of the device under debug has API level %d.", objectArray);
        Logger logger2 = Logger.getInstance(AndroidPositionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AndroidPositionManager::class.java)");
        LOG = logger2;
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00030\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager$MyXDebugSessionListener;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "fileToClose", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "myFileToClose", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "myProject", "sessionStopped", "", "intellij.android.debuggers"})
    public static final class MyXDebugSessionListener
    implements XDebugSessionListener {
        @NotNull
        private final WeakReference<VirtualFile> myFileToClose;
        @NotNull
        private final Project myProject;

        @VisibleForTesting
        public MyXDebugSessionListener(@NotNull VirtualFile fileToClose, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)fileToClose, (String)"fileToClose");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.myFileToClose = new WeakReference<VirtualFile>(fileToClose);
            this.myProject = project;
        }

        public void sessionStopped() {
            block2: {
                VirtualFile virtualFile = (VirtualFile)this.myFileToClose.get();
                if (virtualFile == null) break block2;
                VirtualFile it = virtualFile;
                boolean bl = false;
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application app$iv = ApplicationManager.getApplication();
                if (app$iv.isDispatchThread()) {
                    boolean bl2 = false;
                    FileEditorManager.getInstance((Project)this.myProject).closeFile(it);
                } else {
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, it){
                        final /* synthetic */ MyXDebugSessionListener this$0;
                        final /* synthetic */ VirtualFile $it$inlined;
                        {
                            this.this$0 = myXDebugSessionListener;
                            this.$it$inlined = virtualFile;
                        }

                        public final void run() {
                            boolean bl = false;
                            FileEditorManager.getInstance((Project)MyXDebugSessionListener.access$getMyProject$p(this.this$0)).closeFile(this.$it$inlined);
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0004H\u0007R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager$Companion;", "", "()V", "GENERATED_FILE_CONTENTS_FORMAT", "", "kotlin.jvm.PlatformType", "GENERATED_FILE_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getRelPathForJavaSource", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "changeClassExtensionToJava", "intellij.android.debuggers"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final String getRelPathForJavaSource(@NotNull Project project, @NotNull PsiFile file2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            FileType fileType = file2.getFileType();
            if (Intrinsics.areEqual((Object)fileType, (Object)JavaFileType.INSTANCE)) {
                VirtualFile sourceRoot = ProjectFileIndex.getInstance((Project)project).getSourceRootForFile(file2.getVirtualFile());
                if (sourceRoot == null) {
                    LOG.debug("Could not determine source root for file: " + file2.getVirtualFile().getPath());
                    string = null;
                } else {
                    string = VfsUtilCore.getRelativePath((VirtualFile)file2.getVirtualFile(), (VirtualFile)sourceRoot);
                }
            } else if (Intrinsics.areEqual((Object)fileType, (Object)JavaClassFileType.INSTANCE)) {
                String relativeClassPath;
                VirtualFile virtualFile = file2.getVirtualFile();
                String string2 = relativeClassPath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)VfsUtilCore.getRootFile((VirtualFile)virtualFile));
                string = string2 != null ? this.changeClassExtensionToJava(string2) : null;
            } else {
                string = null;
            }
            return string;
        }

        @VisibleForTesting
        @NotNull
        public final String changeClassExtensionToJava(@NotNull String $this$changeClassExtensionToJava) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$changeClassExtensionToJava, (String)"<this>");
            if (StringsKt.endsWith$default((String)$this$changeClassExtensionToJava, (String)".class", (boolean)false, (int)2, null)) {
                String string = $this$changeClassExtensionToJava.substring(0, $this$changeClassExtensionToJava.length() - ".class".length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                object = string + ".java";
            } else {
                object = $this$changeClassExtensionToJava;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/debug/AndroidPositionManager$AttachSourcesCallback;", "Lcom/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider$AttachAndroidSdkSourcesCallback;", "missingSourceVersion", "Lcom/android/sdklib/AndroidVersion;", "(Lcom/android/tools/idea/debug/AndroidPositionManager;Lcom/android/sdklib/AndroidVersion;)V", "getMissingSourceVersion", "()Lcom/android/sdklib/AndroidVersion;", "refreshAfterDownload", "", "intellij.android.debuggers"})
    public final class AttachSourcesCallback
    implements AttachAndroidSdkSourcesNotificationProvider.AttachAndroidSdkSourcesCallback {
        @NotNull
        private final AndroidVersion missingSourceVersion;

        public AttachSourcesCallback(AndroidVersion missingSourceVersion) {
            Intrinsics.checkNotNullParameter((Object)missingSourceVersion, (String)"missingSourceVersion");
            this.missingSourceVersion = missingSourceVersion;
        }

        @Override
        @NotNull
        public AndroidVersion getMissingSourceVersion() {
            return this.missingSourceVersion;
        }

        @Override
        @UiThread
        public void refreshAfterDownload() {
            Application application = ApplicationManager.getApplication();
            application.assertIsDispatchThread();
            com.google.common.base.Supplier supplier2 = Suppliers.ofInstance((Object)AndroidPositionManager.this.createSourcePackageForApiLevel(true));
            Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"ofInstance(createSourcePackageForApiLevel(true))");
            AndroidPositionManager.this.mySourceFolder = (Supplier)supplier2;
            DumbService.getInstance((Project)AndroidPositionManager.this.myDebugProcess.getProject()).smartInvokeLater(new Runnable(AndroidPositionManager.this, application){
                final /* synthetic */ AndroidPositionManager this$0;
                final /* synthetic */ Application $application;
                {
                    this.this$0 = $receiver;
                    this.$application = $application;
                }

                public final void run() {
                    AndroidPositionManager.access$getMyDebugProcess$p(this.this$0).getManagerThread().invoke(PrioritizedTask.Priority.HIGH, new Runnable(this.this$0, this.$application){
                        final /* synthetic */ AndroidPositionManager this$0;
                        final /* synthetic */ Application $application;
                        {
                            this.this$0 = $receiver;
                            this.$application = $application;
                        }

                        public final void run() {
                            AndroidPositionManager.access$getMyDebugProcess$p(this.this$0).getPositionManager().clearCache();
                            this.$application.invokeLater(new Runnable(this.this$0){
                                final /* synthetic */ AndroidPositionManager this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public final void run() {
                                    PsiFile psiFile = AndroidPositionManager.access$getMyGeneratedPsiFile$p(this.this$0);
                                    if (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null) {
                                        PsiFile psiFile2 = psiFile;
                                        AndroidPositionManager androidPositionManager = this.this$0;
                                        PsiFile it = psiFile2;
                                        boolean bl = false;
                                        if (it.isValid()) {
                                            FileEditorManager.getInstance((Project)AndroidPositionManager.access$getMyDebugProcess$p(androidPositionManager).getProject()).closeFile((VirtualFile)it);
                                        }
                                    }
                                    AndroidPositionManager.access$getMyDebugProcess$p(this.this$0).getSession().refresh(true);
                                }
                            }, new Condition(this.this$0){
                                final /* synthetic */ AndroidPositionManager this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public final boolean value(Object it) {
                                    return AndroidPositionManager.access$getMyDebugProcess$p(this.this$0).getSession().isStopped();
                                }
                            });
                        }
                    });
                }
            });
        }
    }
}

