/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.tools.idea.ddms.screenshot.ScreenshotImage;
import com.android.tools.idea.ddms.screenshot.ScreenshotSupplier;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenshotTask
extends Task.Modal {
    @NotNull
    private final ScreenshotSupplier myScreenshotSupplier;
    @Nullable
    private ScreenshotImage myImage;
    @Nullable
    private String myError;

    public ScreenshotTask(@NotNull Project project, @NotNull ScreenshotSupplier screenshotSupplier) {
        super(project, AndroidBundle.message("android.ddms.actions.screenshot.title", new Object[0]), true);
        this.myScreenshotSupplier = screenshotSupplier;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        indicator.setText(AndroidBundle.message("android.ddms.screenshot.task.step.obtain", new Object[0]));
        try {
            this.myImage = this.myScreenshotSupplier.captureScreenshot();
        }
        catch (Exception e) {
            if (indicator.isCanceled()) {
                return;
            }
            String message2 = ExceptionUtil.getMessage((Throwable)e);
            if (message2 == null) {
                AndroidBundle.message("android.ddms.screenshot.task.error1", e.getClass().getName());
            }
            this.myError = message2;
        }
    }

    @Nullable
    public ScreenshotImage getScreenshot() {
        return this.myImage;
    }

    @Nullable
    public String getError() {
        return this.myError;
    }
}

