/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.tools.adtui.ImageUtils;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/ddms/screenshot/ScreenshotImage;", "", "image", "Ljava/awt/image/BufferedImage;", "screenRotationQuadrants", "", "(Ljava/awt/image/BufferedImage;I)V", "height", "getHeight", "()I", "getImage", "()Ljava/awt/image/BufferedImage;", "getScreenRotationQuadrants", "width", "getWidth", "rotated", "rotationQuadrants", "intellij.android.core"})
public class ScreenshotImage {
    @NotNull
    private final BufferedImage image;
    private final int screenRotationQuadrants;

    public ScreenshotImage(@NotNull BufferedImage image, int screenRotationQuadrants) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.image = image;
        this.screenRotationQuadrants = screenRotationQuadrants;
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    public final int getScreenRotationQuadrants() {
        return this.screenRotationQuadrants;
    }

    public final int getWidth() {
        return this.image.getWidth();
    }

    public final int getHeight() {
        return this.image.getHeight();
    }

    @NotNull
    public ScreenshotImage rotated(int rotationQuadrants) {
        if (rotationQuadrants == 0) {
            return this;
        }
        if (!(-3 <= rotationQuadrants ? rotationQuadrants < 4 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        BufferedImage bufferedImage = ImageUtils.rotateByQuadrants((BufferedImage)this.image, (int)rotationQuadrants);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"rotateByQuadrants(image, rotationQuadrants)");
        return new ScreenshotImage(bufferedImage, (this.screenRotationQuadrants + rotationQuadrants + 4) % 4);
    }
}

