/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.ddms.screenshot.DeviceScreenshotImage;
import com.android.tools.idea.ddms.screenshot.ScreenshotImage;
import com.android.tools.idea.ddms.screenshot.ScreenshotSupplier;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/ddms/screenshot/DeviceScreenshotSupplier;", "Lcom/android/tools/idea/ddms/screenshot/ScreenshotSupplier;", "device", "Lcom/android/ddmlib/IDevice;", "(Lcom/android/ddmlib/IDevice;)V", "captureScreenshot", "Lcom/android/tools/idea/ddms/screenshot/ScreenshotImage;", "intellij.android.core"})
public final class DeviceScreenshotSupplier
implements ScreenshotSupplier {
    @NotNull
    private final IDevice device;

    public DeviceScreenshotSupplier(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.device = device2;
    }

    @Override
    @Slow
    @NotNull
    public ScreenshotImage captureScreenshot() {
        ScreenshotImage screenshotImage;
        try {
            RawImage rawImage = this.device.getScreenshot(10L, TimeUnit.SECONDS);
            if (rawImage.bpp != 16 && rawImage.bpp != 32) {
                Object[] objectArray = new Object[]{rawImage.bpp};
                throw new RuntimeException(AndroidBundle.message("android.ddms.screenshot.task.error.invalid.bpp", objectArray));
            }
            CollectingOutputReceiver receiver2 = new CollectingOutputReceiver();
            this.device.executeShellCommand("dumpsys display", (IShellOutputReceiver)receiver2);
            String string = receiver2.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"receiver.output");
            boolean roundScreen = StringsKt.contains$default((CharSequence)string, (CharSequence)"FLAG_ROUND", (boolean)false, (int)2, null);
            BufferedImage bufferedImage = rawImage.asBufferedImage();
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"rawImage.asBufferedImage()");
            screenshotImage = new DeviceScreenshotImage(bufferedImage, 0, roundScreen);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        catch (AdbCommandRejectedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new RuntimeException(e);
        }
        return screenshotImage;
    }
}

