/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.ddms.screenshot.ScreenshotImage;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\t\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/ddms/screenshot/DeviceScreenshotImage;", "Lcom/android/tools/idea/ddms/screenshot/ScreenshotImage;", "image", "Ljava/awt/image/BufferedImage;", "screenRotationQuadrants", "", "isRoundScreen", "", "(Ljava/awt/image/BufferedImage;IZ)V", "()Z", "rotated", "rotationQuadrants", "intellij.android.core"})
public final class DeviceScreenshotImage
extends ScreenshotImage {
    private final boolean isRoundScreen;

    public DeviceScreenshotImage(@NotNull BufferedImage image, int screenRotationQuadrants, boolean isRoundScreen) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        super(image, screenRotationQuadrants);
        this.isRoundScreen = isRoundScreen;
    }

    public final boolean isRoundScreen() {
        return this.isRoundScreen;
    }

    @Override
    @NotNull
    public DeviceScreenshotImage rotated(int rotationQuadrants) {
        if (rotationQuadrants == 0) {
            return this;
        }
        if (!(-3 <= rotationQuadrants ? rotationQuadrants < 4 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        BufferedImage bufferedImage = ImageUtils.rotateByQuadrants((BufferedImage)this.getImage(), (int)rotationQuadrants);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"rotateByQuadrants(image, rotationQuadrants)");
        return new DeviceScreenshotImage(bufferedImage, (this.getScreenRotationQuadrants() + rotationQuadrants + 4) % 4, this.isRoundScreen);
    }
}

