/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenrecord;

import com.android.tools.idea.ddms.screenrecord.ScreenRecorderPersistentOptions;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenRecorderOptionsDialog
extends DialogWrapper {
    @NonNls
    private static final String SCREENRECORDER_DIMENSIONS_KEY = "ScreenshotRecorder.Options.Dimensions";
    private final DefaultComboBoxModel<Integer> myComboBoxModel;
    private JPanel myPanel;
    @VisibleForTesting
    JTextField myBitRateTextField;
    @VisibleForTesting
    JCheckBox myShowTouchCheckBox;
    private JCheckBox myEmulatorRecordingCheckBox;
    private JComboBox<Integer> myResolutionPercentComboBox;

    public ScreenRecorderOptionsDialog(@NotNull Project project, boolean isEmulator) {
        super(project, true);
        Integer[] integerArray = new Integer[3];
        this.$$$setupUI$$$();
        integerArray[0] = 100;
        integerArray[1] = 50;
        integerArray[2] = 30;
        this.myComboBoxModel = new DefaultComboBoxModel<Integer>(integerArray);
        this.myResolutionPercentComboBox.setModel(this.myComboBoxModel);
        ScreenRecorderPersistentOptions options2 = ScreenRecorderPersistentOptions.getInstance();
        this.myComboBoxModel.setSelectedItem(options2.getResolutionPercent());
        if (options2.getBitRateMbps() > 0) {
            this.myBitRateTextField.setText(Integer.toString(options2.getBitRateMbps()));
        }
        this.myShowTouchCheckBox.setSelected(options2.getShowTaps());
        this.myEmulatorRecordingCheckBox.setSelected(options2.getUseEmulatorRecording());
        this.myEmulatorRecordingCheckBox.setVisible(isEmulator);
        this.setTitle("Screen Recorder Options");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return SCREENRECORDER_DIMENSIONS_KEY;
    }

    @Nullable
    protected String getHelpId() {
        return "org.jetbrains.android.r/studio-ui/am-video.html";
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.getOKAction().putValue("Name", AndroidBundle.message("android.ddms.screenrecord.options.ok.button.text", new Object[0]));
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info2 = ScreenRecorderOptionsDialog.validateInteger(this.myBitRateTextField, AndroidBundle.message("android.ddms.screenrecorder.options.bit.rate.invalid", new Object[0]));
        if (info2 != null) {
            return info2;
        }
        return super.doValidate();
    }

    @Nullable
    private static ValidationInfo validateInteger(JTextField textField2, String errorMessage) {
        String s = ScreenRecorderOptionsDialog.getText(textField2);
        if (s.isEmpty()) {
            return null;
        }
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return new ValidationInfo(errorMessage, (JComponent)textField2);
        }
        return null;
    }

    protected void doOKAction() {
        ScreenRecorderPersistentOptions options2 = ScreenRecorderPersistentOptions.getInstance();
        options2.setBitRateMbps(ScreenRecorderOptionsDialog.getIntegerValue(this.myBitRateTextField));
        options2.setResolutionPercent((Integer)this.myComboBoxModel.getSelectedItem());
        options2.setShowTaps(this.myShowTouchCheckBox.isSelected());
        options2.setUseEmulatorRecording(this.myEmulatorRecordingCheckBox.isSelected());
        super.doOKAction();
    }

    private static int getIntegerValue(JTextField textField2) {
        String s = ScreenRecorderOptionsDialog.getText(textField2);
        return s.isEmpty() ? 0 : Integer.parseInt(s);
    }

    private static String getText(JTextField textField2) {
        Document doc = textField2.getDocument();
        try {
            return doc.getText(0, doc.getLength()).trim();
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public boolean getUseEmulatorRecording() {
        return ScreenRecorderPersistentOptions.getInstance().getUseEmulatorRecording();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.ddms.screenrecorder.options.bit.rate"));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myBitRateTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, new Dimension(150, -1), new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.ddms.screenrecorder.options.resolution"));
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.ddms.screenrecorder.options.info"));
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myShowTouchCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.ddms.screenrecorder.options.show.taps"));
        jCheckBox2.setToolTipText(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.ddms.screenrecorder.options.show.taps.tooltip"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEmulatorRecordingCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.ddms.screenrecorder.options.use.emulator.recording"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.ddms.screenrecorder.options.use.emulator.recording.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myResolutionPercentComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

