/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.tools.idea.ddms.actions.PullRecordingTask;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenRecorderDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.NativeFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScreenRecorderTask
implements Runnable {
    private static final String SAVE_PATH_KEY = "ScreenRecorderTask.SavePath";
    private static final CharSequence MEDIA_UNSUPPORTED_ERROR = "-1010";
    private static final long MAX_RECORDING_TIME_MILLIS = TimeUnit.MINUTES.toMillis(3L);
    @NotNull
    private final Project myProject;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final String myRemotePath;
    @Nullable
    private final Path myHostRecordingFile;
    @NotNull
    private final ScreenRecorderOptions myOptions;
    private DialogWrapper myDialogWrapper;

    public ScreenRecorderTask(@NotNull Project project, @NotNull IDevice device2, @NotNull String remotePath, @Nullable Path hostRecordingFile, @NotNull ScreenRecorderOptions options2) {
        this.myProject = project;
        this.myDevice = device2;
        this.myRemotePath = remotePath;
        this.myHostRecordingFile = hostRecordingFile;
        this.myOptions = options2;
    }

    @Override
    @Slow
    public void run() {
        CollectingOutputReceiver receiver2 = null;
        EmulatorConsole console = null;
        if (this.myHostRecordingFile != null) {
            console = EmulatorConsole.getConsole((IDevice)this.myDevice);
            if (console == null) {
                return;
            }
            try {
                console.startEmulatorScreenRecording(ScreenRecorderTask.getEmulatorScreenRecorderOptions(this.myHostRecordingFile, this.myOptions));
            }
            catch (Exception e) {
                EventQueue.invokeLater(() -> this.showError("Unexpected error while launching screen recording", e));
                return;
            }
        } else {
            receiver2 = new CollectingOutputReceiver();
            this.startDeviceRecording(receiver2);
        }
        long start2 = System.currentTimeMillis();
        CountDownLatch stoppingLatch = new CountDownLatch(1);
        ScreenRecorderDialog dialog2 = new ScreenRecorderDialog("Screen Recorder", stoppingLatch::countDown);
        EventQueue.invokeLater(() -> {
            this.myDialogWrapper = dialog2.createWrapper(this.myProject);
            this.myDialogWrapper.show();
        });
        try {
            while (!(stoppingLatch.await(this.millisUntilNextSecondTick(start2), TimeUnit.MILLISECONDS) || System.currentTimeMillis() - start2 >= MAX_RECORDING_TIME_MILLIS || receiver2 != null && receiver2.isComplete())) {
                EventQueue.invokeLater(() -> dialog2.setRecordingTimeMillis(System.currentTimeMillis() - start2));
                if (console == null || (console = EmulatorConsole.getConsole((IDevice)this.myDevice)) != null) continue;
            }
            EventQueue.invokeLater(() -> dialog2.setRecordingLabelText("Stopping..."));
            this.stopRecording(receiver2, console);
        }
        catch (InterruptedException e) {
            this.stopRecording(receiver2, console);
            throw new ProcessCanceledException();
        }
        finally {
            EventQueue.invokeLater(() -> this.myDialogWrapper.close(1));
        }
        if (receiver2 != null) {
            this.pullRecording(receiver2);
        } else {
            this.pullEmulatorRecording();
        }
    }

    private long millisUntilNextSecondTick(long start2) {
        return 1000L - (System.currentTimeMillis() - start2) % 1000L;
    }

    private void startDeviceRecording(@NotNull CollectingOutputReceiver receiver2) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myDevice.startScreenRecorder(this.myRemotePath, this.myOptions, (IShellOutputReceiver)receiver2);
            }
            catch (Exception e) {
                receiver2.flush();
                EventQueue.invokeLater(() -> this.showError("Unexpected error while launching screen recording", e));
            }
        });
    }

    private void stopRecording(@Nullable CollectingOutputReceiver receiver2, @Nullable EmulatorConsole console) {
        if (receiver2 != null) {
            receiver2.cancel();
            try {
                receiver2.awaitCompletion(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
        } else if (console != null) {
            console.stopScreenRecording();
        }
    }

    private void pullEmulatorRecording() {
        assert (this.myHostRecordingFile != null);
        if (!Files.exists(this.myHostRecordingFile, new LinkOption[0])) {
            return;
        }
        EventQueue.invokeLater(() -> {
            VirtualFileWrapper fileWrapper2 = this.getTargetFile("webm");
            if (fileWrapper2 == null) {
                return;
            }
            try {
                Files.move(this.myHostRecordingFile, fileWrapper2.getFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.handleSavedRecording(fileWrapper2);
            }
            catch (IOException e) {
                this.showError("Unable to copy file to destination", e);
            }
        });
    }

    private void pullRecording(@NotNull CollectingOutputReceiver receiver2) {
        EventQueue.invokeLater(() -> {
            if (receiver2.getOutput().contains(MEDIA_UNSUPPORTED_ERROR)) {
                Messages.showErrorDialog((String)receiver2.getOutput(), (String)"Screen Recorder Error");
                return;
            }
            VirtualFileWrapper fileWrapper2 = this.getTargetFile("mp4");
            if (fileWrapper2 == null) {
                return;
            }
            new PullRecordingTask(this.myProject, this.myDevice, this.myRemotePath, fileWrapper2.getFile().getAbsolutePath(), () -> this.handleSavedRecording(fileWrapper2)).queue();
        });
    }

    private void handleSavedRecording(VirtualFileWrapper fileWrapper2) {
        String path2 = fileWrapper2.getFile().getAbsolutePath();
        String message2 = "Video Recording saved as " + path2;
        String cancel = CommonBundle.getOkButtonText();
        Icon icon2 = Messages.getInformationIcon();
        if (RevealFileAction.isSupported()) {
            String no = "Show in " + RevealFileAction.getFileManagerName();
            int exitCode2 = Messages.showYesNoCancelDialog((Project)this.myProject, (String)message2, (String)"Screen Recorder", (String)"Open", (String)no, (String)cancel, (Icon)icon2);
            if (exitCode2 == 0) {
                ScreenRecorderTask.openSavedFile(fileWrapper2);
            } else if (exitCode2 == 1) {
                RevealFileAction.openFile((File)new File(path2));
            }
        } else if (Messages.showOkCancelDialog((Project)this.myProject, (String)message2, (String)"Screen Recorder", (String)"Open File", (String)cancel, (Icon)icon2) == 0) {
            ScreenRecorderTask.openSavedFile(fileWrapper2);
        }
    }

    private static void openSavedFile(VirtualFileWrapper fileWrapper2) {
        VirtualFile file2 = fileWrapper2.getVirtualFile();
        if (file2 != null) {
            NativeFileType.openAssociatedApplication((VirtualFile)file2);
        }
    }

    @Nullable
    private VirtualFileWrapper getTargetFile(@NotNull String extension) {
        String lastPath;
        VirtualFile baseDir2;
        PropertiesComponent properties2 = PropertiesComponent.getInstance((Project)this.myProject);
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save As", "", new String[]{extension});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.myProject);
        VirtualFileWrapper saveFileWrapper = saveFileDialog.save(baseDir2 = (lastPath = properties2.getValue(SAVE_PATH_KEY)) != null ? LocalFileSystem.getInstance().findFileByPath(lastPath) : VfsUtil.getUserHomeDir(), ScreenRecorderTask.getDefaultFileName(extension));
        if (saveFileWrapper != null) {
            File saveFile = saveFileWrapper.getFile();
            properties2.setValue(SAVE_PATH_KEY, saveFile.getPath());
        }
        return saveFileWrapper;
    }

    @UiThread
    private void showError(@NotNull String message2, @Nullable Throwable throwable) {
        ScreenRecorderAction.showError(this.myProject, message2, throwable);
    }

    @NotNull
    private static String getDefaultFileName(@NotNull String extension) {
        Calendar now = Calendar.getInstance();
        String fileName = "device-%tF-%tH%tM%tS";
        return String.format(Locale.US, (String)(SystemInfo.isMac ? fileName + "." + extension : fileName), now, now, now, now);
    }

    @VisibleForTesting
    @NotNull
    static String getEmulatorScreenRecorderOptions(@NotNull Path filePath, @NotNull ScreenRecorderOptions options2) {
        StringBuilder sb = new StringBuilder();
        if (options2.width > 0 && options2.height > 0) {
            sb.append("--size ");
            sb.append(options2.width);
            sb.append('x');
            sb.append(options2.height);
            sb.append(' ');
        }
        if (options2.bitrateMbps > 0) {
            sb.append("--bit-rate ");
            sb.append(options2.bitrateMbps * 1000000);
            sb.append(' ');
        }
        if (options2.timeLimit > 0L) {
            sb.append("--time-limit ");
            long seconds = TimeUnit.SECONDS.convert(options2.timeLimit, options2.timeLimitUnits);
            if (seconds > 180L) {
                seconds = 180L;
            }
            sb.append(seconds);
            sb.append(' ');
        }
        sb.append(filePath);
        return sb.toString();
    }
}

