/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.prefs.AndroidLocationsException;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.ddms.actions.CachedFeatures;
import com.android.tools.idea.ddms.actions.Features;
import com.android.tools.idea.ddms.actions.ScreenRecorderTask;
import com.android.tools.idea.ddms.screenrecord.ScreenRecorderOptionsDialog;
import com.android.tools.idea.ddms.screenrecord.ScreenRecorderPersistentOptions;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeAvdManagers;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.StudioIcons;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScreenRecorderAction
extends AbstractDeviceAction
implements DumbAware {
    private static final String REMOTE_PATH = "/sdcard/screen-recording-%d.mp4";
    static final String TITLE = "Screen Recorder";
    private static final Pattern WM_SIZE_OUTPUT_REGEX = Pattern.compile("(?<width>\\d+)x(?<height>\\d+)");
    private static final String EMU_TMP_FILENAME = "tmp.webm";
    private static final Set<IDevice> myRecordingInProgress = new HashSet<IDevice>();
    private final Features myFeatures;
    private final Project myProject;

    public ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context2) {
        this(project, context2, new CachedFeatures((Disposable)project));
    }

    @VisibleForTesting
    ScreenRecorderAction(@NotNull Project project, @NotNull DeviceContext context2, @NotNull Features features) {
        super(context2, AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]), AndroidBundle.message("android.ddms.actions.screenrecord.description", new Object[0]), StudioIcons.Common.VIDEO_CAPTURE);
        this.myFeatures = features;
        this.myProject = project;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (!this.isEnabled()) {
            presentation.setEnabled(false);
            presentation.setText(AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]));
            return;
        }
        IDevice device2 = this.myDeviceContext.getSelectedDevice();
        presentation.setEnabled(this.myFeatures.screenRecord(device2));
        presentation.setText(AndroidBundle.message("android.ddms.actions.screenrecord", new Object[0]));
    }

    @Override
    protected boolean isEnabled() {
        return super.isEnabled() && !myRecordingInProgress.contains(this.myDeviceContext.getSelectedDevice());
    }

    @Override
    protected void performAction(@NotNull AnActionEvent e, final @NotNull IDevice device2) {
        final ScreenRecorderOptionsDialog dialog2 = new ScreenRecorderOptionsDialog(this.myProject, device2.isEmulator());
        if (!dialog2.showAndGet()) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Starting screen recording..."){
            private boolean myShowTouchEnabled;

            public void run(@NotNull ProgressIndicator indicator) {
                this.myShowTouchEnabled = ScreenRecorderAction.isShowTouchEnabled(device2);
            }

            public void onSuccess() {
                ScreenRecorderAction.this.startRecordingAsync(dialog2.getUseEmulatorRecording(), device2, this.myShowTouchEnabled);
            }
        });
    }

    private void startRecordingAsync(boolean useEmulatorRecording, @NotNull IDevice device2, boolean showTouchEnabled) {
        AvdManager manager = ScreenRecorderAction.getVirtualDeviceManager();
        Path emulatorRecordingFile = manager != null && useEmulatorRecording ? this.getTemporaryVideoPathForVirtualDevice(device2, manager) : null;
        myRecordingInProgress.add(device2);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Dimension size = this.getDeviceScreenSize(device2);
            ScreenRecorderOptions options2 = ScreenRecorderPersistentOptions.getInstance().toScreenRecorderOptions(size);
            if (options2.showTouches != showTouchEnabled) {
                ScreenRecorderAction.setShowTouch(device2, options2.showTouches);
            }
            try {
                ScreenRecorderTask task2 = new ScreenRecorderTask(this.myProject, device2, String.format(Locale.US, REMOTE_PATH, System.currentTimeMillis()), emulatorRecordingFile, options2);
                task2.run();
            }
            finally {
                if (options2.showTouches != showTouchEnabled) {
                    ScreenRecorderAction.setShowTouch(device2, showTouchEnabled);
                }
                EventQueue.invokeLater(() -> myRecordingInProgress.remove(device2));
            }
        });
    }

    @Nullable
    private static AvdManager getVirtualDeviceManager() {
        Logger logger2 = Logger.getInstance(ScreenRecorderAction.class);
        try {
            return IdeAvdManagers.INSTANCE.getAvdManager(AndroidSdks.getInstance().tryToChooseSdkHandler());
        }
        catch (AndroidLocationsException exception) {
            logger2.warn((Throwable)exception);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    Path getTemporaryVideoPathForVirtualDevice(@NotNull IDevice device2, @NotNull AvdManager manager) {
        if (!this.myFeatures.screenRecord(device2)) {
            return null;
        }
        AvdInfo virtualDevice = manager.getAvd(device2.getAvdName(), true);
        if (virtualDevice == null) {
            return null;
        }
        return virtualDevice.getDataFolderPath().resolve(EMU_TMP_FILENAME);
    }

    private static void setShowTouch(@NotNull IDevice device2, boolean isEnabled2) {
        int value2 = isEnabled2 ? 1 : 0;
        try {
            device2.executeShellCommand("settings put system show_touches " + value2, (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to set show taps to " + isEnabled2, e);
        }
    }

    private static boolean isShowTouchEnabled(@NotNull IDevice device2) {
        CollectingOutputReceiver receiver2 = new CollectingOutputReceiver();
        try {
            device2.executeShellCommand("settings get system show_touches", (IShellOutputReceiver)receiver2);
            String output = receiver2.getOutput();
            return output.equals("1");
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            Logger.getInstance(ScreenRecorderAction.class).warn("Failed to retrieve setting", e);
            return false;
        }
    }

    static void showError(@Nullable Project project, @NotNull String message2, @Nullable Throwable throwable) {
        ApplicationManager.getApplication().invokeLater(() -> {
            Object msg = message2;
            if (throwable != null) {
                msg = (String)msg + (String)(throwable.getLocalizedMessage() != null ? ": " + throwable.getLocalizedMessage() : "");
            }
            Messages.showErrorDialog((Project)project, (String)msg, (String)TITLE);
        });
    }

    @Nullable
    private Dimension getDeviceScreenSize(@NotNull IDevice device2) {
        CollectingOutputReceiver receiver2 = new CollectingOutputReceiver();
        try {
            device2.executeShellCommand("wm size", (IShellOutputReceiver)receiver2);
            receiver2.awaitCompletion(5L, TimeUnit.SECONDS);
            String output = receiver2.getOutput();
            Matcher matcher = WM_SIZE_OUTPUT_REGEX.matcher(output);
            if (!matcher.find()) {
                Logger.getInstance(((Object)((Object)this)).getClass()).warn("Unexpected output from 'wm size': " + output);
                return null;
            }
            return new Dimension(Integer.parseInt(matcher.group("width")), Integer.parseInt(matcher.group("height")));
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException | NumberFormatException e) {
            Logger.getInstance(((Object)((Object)this)).getClass()).warn("Failed to get device screen size.", e);
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }
}

