/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PullRecordingTask
extends Task.Modal {
    private final String myRemotePath;
    private final String myLocalPath;
    private final Runnable myHandleSavedFileRunnable;
    private final IDevice myDevice;

    public PullRecordingTask(@Nullable Project project, @NotNull IDevice device2, @NotNull String remotePath, @NotNull String localFilePath, Runnable handleSavedFileRunnable) {
        super(project, "Screen Recorder", false);
        this.myDevice = device2;
        this.myRemotePath = remotePath;
        this.myLocalPath = localFilePath;
        this.myHandleSavedFileRunnable = handleSavedFileRunnable;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        try {
            this.myDevice.pullFile(this.myRemotePath, this.myLocalPath);
            this.myDevice.removeRemotePackage(this.myRemotePath);
        }
        catch (Exception e) {
            ScreenRecorderAction.showError(this.myProject, "Unexpected error while copying video recording from device", e);
        }
    }

    public void onSuccess() {
        assert (this.myProject != null);
        this.myHandleSavedFileRunnable.run();
    }
}

