/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.io.Images;
import com.android.resources.ScreenOrientation;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.ddms.actions.DeviceScreenshotAction;
import com.android.tools.idea.ddms.screenshot.DeviceArtFramingOption;
import com.android.tools.idea.ddms.screenshot.DeviceArtScreenshotPostprocessor;
import com.android.tools.idea.ddms.screenshot.DeviceScreenshotSupplier;
import com.android.tools.idea.ddms.screenshot.FramingOption;
import com.android.tools.idea.ddms.screenshot.ScreenshotImage;
import com.android.tools.idea.ddms.screenshot.ScreenshotPostprocessor;
import com.android.tools.idea.ddms.screenshot.ScreenshotSupplier;
import com.android.tools.idea.ddms.screenshot.ScreenshotTask;
import com.android.tools.idea.ddms.screenshot.ScreenshotViewer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.awt.image.RenderedImage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/ddms/actions/DeviceScreenshotAction;", "Lcom/android/tools/idea/ddms/actions/AbstractDeviceAction;", "Lcom/intellij/openapi/project/DumbAware;", "myProject", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/android/tools/idea/ddms/DeviceContext;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/ddms/DeviceContext;)V", "findFrameIndexForDeviceModel", "", "frames", "", "Lcom/android/tools/idea/ddms/screenshot/FramingOption;", "deviceModel", "", "getDefaultFrame", "screenshotImage", "Lcom/android/tools/idea/ddms/screenshot/ScreenshotImage;", "getFramingOptions", "Lcom/android/tools/idea/ddms/screenshot/DeviceArtFramingOption;", "performAction", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "device", "Lcom/android/ddmlib/IDevice;", "intellij.android.core"})
public final class DeviceScreenshotAction
extends AbstractDeviceAction
implements DumbAware {
    @NotNull
    private final Project myProject;

    public DeviceScreenshotAction(@NotNull Project myProject, @NotNull DeviceContext context2) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, AndroidBundle.message("android.ddms.actions.screenshot.title", new Object[0]), AndroidBundle.message("android.ddms.actions.screenshot.description", new Object[0]), StudioIcons.Common.SCREENSHOT);
        this.myProject = myProject;
    }

    @Override
    protected void performAction(@NotNull AnActionEvent event, @NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Project project = this.myProject;
        DeviceScreenshotSupplier deviceScreenshotSupplier = new DeviceScreenshotSupplier(device2);
        new ScreenshotTask(project, device2, this, deviceScreenshotSupplier){
            final /* synthetic */ Project $project;
            final /* synthetic */ IDevice $device;
            final /* synthetic */ DeviceScreenshotAction this$0;
            {
                this.$project = $project;
                this.$device = $device;
                this.this$0 = $receiver;
                super($project, $super_call_param$1);
            }

            public void onSuccess() {
                String string = this.getError();
                if (string != null) {
                    String string2 = string;
                    Project project = this.$project;
                    String msg = string2;
                    boolean bl = false;
                    Messages.showErrorDialog((Project)project, (String)msg, (String)AndroidBundle.message("android.ddms.actions.screenshot.title", new Object[0]));
                    return;
                }
                try {
                    Path backingFile = FileUtil.createTempFile((String)"screenshot", (String)".png").toPath();
                    ScreenshotImage screenshotImage = this.getScreenshot();
                    Intrinsics.checkNotNull((Object)screenshotImage);
                    ScreenshotImage screenshotImage2 = screenshotImage;
                    RenderedImage renderedImage = screenshotImage2.getImage();
                    Intrinsics.checkNotNullExpressionValue((Object)backingFile, (String)"backingFile");
                    Images.writeImage((RenderedImage)renderedImage, (String)"png", (Path)backingFile);
                    ScreenshotSupplier screenshotSupplier = new DeviceScreenshotSupplier(this.$device);
                    ScreenshotPostprocessor screenshotPostprocessor = new DeviceArtScreenshotPostprocessor();
                    List framingOptions = DeviceScreenshotAction.access$getFramingOptions(this.this$0, screenshotImage2);
                    int defaultFrame = DeviceScreenshotAction.access$getDefaultFrame(this.this$0, framingOptions, screenshotImage2, this.$device.getProperty("ro.product.model"));
                    EnumSet<Enum> enumSet = EnumSet.of((Enum)ScreenshotViewer.Option.ALLOW_IMAGE_ROTATION);
                    ScreenshotViewer viewer2 = new ScreenshotViewer(this.$project, screenshotImage2, backingFile, screenshotSupplier, screenshotPostprocessor, framingOptions, defaultFrame, enumSet){
                        final /* synthetic */ Project $project;
                        {
                            this.$project = $project;
                            super($project, $screenshotImage, $backingFile, $screenshotSupplier, $screenshotPostprocessor, $framingOptions, $defaultFrame, (Set<ScreenshotViewer.Option>)$super_call_param$1);
                        }

                        protected void doOKAction() {
                            block1: {
                                super.doOKAction();
                                Path path2 = this.getScreenshot();
                                if (path2 == null) break block1;
                                Path path3 = path2;
                                Project project = this.$project;
                                Path it = path3;
                                boolean bl = false;
                                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(it);
                                if (virtualFile != null) {
                                    VirtualFile virtualFile2 = virtualFile;
                                    boolean bl2 = false;
                                    virtualFile2.refresh(false, false);
                                    FileEditorManager.getInstance((Project)project).openFile(virtualFile2, true);
                                }
                            }
                        }
                    };
                    viewer2.show();
                }
                catch (Exception e) {
                    performAction.1 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger2 = Logger.getInstance(performAction.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                    logger2.warn("Error while displaying screenshot viewer: ", (Throwable)e);
                    Object[] objectArray = new Object[]{e};
                    Messages.showErrorDialog((Project)this.$project, (String)AndroidBundle.message("android.ddms.screenshot.generic.error", objectArray), (String)AndroidBundle.message("android.ddms.actions.screenshot.title", new Object[0]));
                }
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<DeviceArtFramingOption> getFramingOptions(ScreenshotImage screenshotImage) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DeviceArtDescriptor it;
        void $this$filterTo$iv$iv;
        double imgAspectRatio = (double)screenshotImage.getWidth() / (double)screenshotImage.getHeight();
        ScreenOrientation orientation = imgAspectRatio >= 0.99999 ? ScreenOrientation.LANDSCAPE : ScreenOrientation.PORTRAIT;
        List allDescriptors = DeviceArtDescriptor.getDescriptors(null);
        Intrinsics.checkNotNullExpressionValue((Object)allDescriptors, (String)"allDescriptors");
        Iterable $this$filter$iv = allDescriptors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DeviceArtDescriptor)element$iv$iv;
            boolean bl = false;
            if (!it.canFrameImage(screenshotImage.getImage(), orientation)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DeviceArtDescriptor)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection2.add(new DeviceArtFramingOption(it));
        }
        return (List)destination$iv$iv;
    }

    private final int getDefaultFrame(List<? extends FramingOption> frames, ScreenshotImage screenshotImage, String deviceModel) {
        int index2;
        if (deviceModel != null && (index2 = this.findFrameIndexForDeviceModel(frames, deviceModel)) >= 0) {
            return index2;
        }
        String defaultDevice = Math.min(screenshotImage.getWidth(), screenshotImage.getHeight()) > 1280 ? "Generic Tablet" : "Generic Phone";
        return RangesKt.coerceAtLeast((int)this.findFrameIndexForDeviceModel(frames, defaultDevice), (int)0);
    }

    private final int findFrameIndexForDeviceModel(List<? extends FramingOption> frames, String deviceModel) {
        int n;
        block2: {
            List<? extends FramingOption> $this$indexOfFirst$iv = frames;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<? extends FramingOption> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                FramingOption item$iv;
                FramingOption it = item$iv = iterator2.next();
                boolean bl = false;
                if (StringsKt.equals((String)it.getDisplayName(), (String)deviceModel, (boolean)true)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    public static final /* synthetic */ List access$getFramingOptions(DeviceScreenshotAction $this, ScreenshotImage screenshotImage) {
        return $this.getFramingOptions(screenshotImage);
    }

    public static final /* synthetic */ int access$getDefaultFrame(DeviceScreenshotAction $this, List frames, ScreenshotImage screenshotImage, String deviceModel) {
        return $this.getDefaultFrame(frames, screenshotImage, deviceModel);
    }
}

