/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.ClientCellRenderer;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.utils.CharSequences;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePanel
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IClientChangeListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(DevicePanel.class);
    private final DeviceContext myDeviceContext;
    @Nullable
    private final IDevice myInitialDevice;
    @Nullable
    private AndroidDebugBridge myBridge;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DeviceNamePropertiesProvider myProvider;
    @NotNull
    private final Map<String, String> myPreferredClients;
    private boolean myIgnoringActionEvents;
    private DeviceComboBox myDeviceCombo;
    private JComboBox<Client> myProcessComboBox;
    private final NullableLazyValue<String> myCandidateClientName = new NullableLazyValue<String>(){

        @Nullable
        protected String compute() {
            return DevicePanel.this.getApplicationName();
        }
    };

    public DevicePanel(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        this(project, deviceContext, null);
    }

    public DevicePanel(@NotNull Project project, @NotNull DeviceContext deviceContext, @Nullable IDevice initialDevice) {
        this(project, deviceContext, new MyDeviceComboBox(), new MyProcessComboBox(), initialDevice);
    }

    @VisibleForTesting
    DevicePanel(@NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull DeviceComboBox deviceComboBox, @NotNull ComboBox<Client> processComboBox, @Nullable IDevice initialDevice) {
        this.myProject = project;
        this.myProvider = new DeviceNamePropertiesFetcher((Disposable)this.myProject);
        this.myDeviceContext = deviceContext;
        this.myPreferredClients = new HashMap<String, String>();
        this.myInitialDevice = initialDevice;
        this.initializeDeviceCombo(deviceComboBox);
        this.initializeProcessComboBox(processComboBox);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    private void initializeDeviceCombo(@NotNull DeviceComboBox deviceComboBox) {
        deviceComboBox.initRenderer(new MyFutureCallback());
        deviceComboBox.addActionListener(event -> {
            if (this.myIgnoringActionEvents) {
                return;
            }
            this.updateProcessComboBox();
            Object device2 = this.myDeviceCombo.getSelectedItem();
            this.myDeviceContext.fireDeviceSelected(device2 instanceof IDevice ? (IDevice)device2 : null);
        });
        this.myDeviceCombo = deviceComboBox;
    }

    private void initializeProcessComboBox(@NotNull ComboBox<Client> processComboBox) {
        processComboBox.setName("Processes");
        AccessibleContextUtil.setName(processComboBox, (String)"Processes");
        processComboBox.addActionListener(event -> {
            if (this.myIgnoringActionEvents) {
                return;
            }
            Client client2 = (Client)this.myProcessComboBox.getSelectedItem();
            if (client2 != null) {
                this.myPreferredClients.put(client2.getDevice().getName(), client2.getClientData().getClientDescription());
            }
            this.myDeviceContext.fireClientSelected(client2);
        });
        this.myProcessComboBox = processComboBox;
        this.myProcessComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                DevicePanel.this.updateProcessComboBox();
            }
        });
        new ComboboxSpeedSearch((JComboBox)processComboBox){

            protected String getElementText(@NotNull Object element2) {
                return ClientCellRenderer.getClientName(((Client)element2).getClientData());
            }

            protected boolean compare(@NotNull String text2, @Nullable String pattern) {
                return pattern != null && CharSequences.indexOfIgnoreCase((CharSequence)text2, (CharSequence)pattern, (int)0) >= 0;
            }
        };
    }

    @NotNull
    public JComboBox<IDevice> getDeviceComboBox() {
        return this.myDeviceCombo;
    }

    public void selectDevice(IDevice device2) {
        this.myDeviceCombo.setSelectedItem(device2);
    }

    @NotNull
    public JComboBox<Client> getClientComboBox() {
        return this.myProcessComboBox;
    }

    public void selectClient(Client client2) {
        this.myProcessComboBox.setSelectedItem(client2);
    }

    @Nullable
    private String getApplicationName() {
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module2);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        this.myBridge = null;
        if (this.myDeviceCombo != null) {
            Disposer.dispose((Disposable)this.myDeviceCombo);
            this.myDeviceCombo = null;
        }
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        if (bridge == null) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            this.myBridge = bridge;
            this.updateDeviceCombo();
            if (this.myInitialDevice != null) {
                Optional<IDevice> optionalDevice = IntStream.range(0, this.myDeviceCombo.getItemCount()).mapToObj(i -> (IDevice)this.myDeviceCombo.getItemAt(i)).filter(device2 -> DevicePanel.equals(device2, this.myInitialDevice)).findFirst();
                if (optionalDevice.isPresent()) {
                    this.myDeviceCombo.setSelectedItem(optionalDevice.get());
                } else {
                    this.myDeviceCombo.addItem(this.myInitialDevice);
                    this.myDeviceCombo.setSelectedItem(this.myInitialDevice);
                }
            }
        }));
    }

    @VisibleForTesting
    void setBridge(@NotNull AndroidDebugBridge bridge) {
        this.myBridge = bridge;
    }

    public void deviceConnected(@NotNull IDevice device2) {
        LOG.info("Device connected: " + device2.getName());
        if (device2.isEmulator()) {
            device2.getAvdData().addListener(() -> UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo), MoreExecutors.directExecutor());
        } else {
            UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
        LOG.info("Device disconnected: " + device2.getName());
        UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
    }

    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        UIUtil.invokeLaterIfNeeded(() -> this.deviceChangedImpl(device2, changeMask));
    }

    @VisibleForTesting
    void deviceChangedImpl(@NotNull IDevice device2, int changeMask) {
        if ((changeMask & 2) != 0) {
            if (!this.myProcessComboBox.isPopupVisible()) {
                this.updateProcessComboBox();
            }
        } else if ((changeMask & 1) != 0) {
            this.updateDeviceCombo();
        }
        this.myDeviceContext.fireDeviceChanged(device2, changeMask);
    }

    public void clientChanged(@NotNull Client client2, int changeMask) {
        if ((changeMask & 1) != 0) {
            ApplicationManager.getApplication().invokeLater(this::updateProcessComboBox);
        }
    }

    @VisibleForTesting
    void updateDeviceCombo() {
        if (this.myBridge == null) {
            return;
        }
        this.myIgnoringActionEvents = true;
        IDevice selectedDevice = (IDevice)this.myDeviceCombo.getSelectedItem();
        this.myDeviceCombo.removeAllItems();
        List<IDevice> devices2 = Arrays.asList(this.myBridge.getDevices());
        devices2.forEach(device2 -> this.myDeviceCombo.addItem(device2));
        this.myDeviceCombo.setSerialNumbersVisible(DeviceRenderer.shouldShowSerialNumbers(devices2, this.myProvider));
        Optional<IDevice> optionalDevice = IntStream.range(0, this.myDeviceCombo.getItemCount()).mapToObj(i -> (IDevice)this.myDeviceCombo.getItemAt(i)).filter(device2 -> DevicePanel.equals(device2, selectedDevice)).findFirst();
        if (optionalDevice.isPresent()) {
            IDevice device3 = optionalDevice.get();
            this.myDeviceCombo.setSelectedItem(device3);
            this.myDeviceContext.fireDeviceSelected(device3);
        } else if (selectedDevice != null) {
            this.myDeviceCombo.addItem(selectedDevice);
            this.myDeviceCombo.setSelectedItem(selectedDevice);
            this.myDeviceContext.fireDeviceSelected(selectedDevice);
        }
        this.updateProcessComboBox();
        this.myIgnoringActionEvents = false;
    }

    private static boolean equals(@NotNull IDevice device1, @Nullable IDevice device2) {
        if (device2 == null) {
            return false;
        }
        boolean device1Emulator = device1.isEmulator();
        if (device1Emulator != device2.isEmulator()) {
            return false;
        }
        if (device1Emulator) {
            return Objects.equals(device1.getAvdName(), device2.getAvdName());
        }
        return device1.getSerialNumber().equals(device2.getSerialNumber());
    }

    private void updateProcessComboBox() {
        if (this.myDeviceCombo == null) {
            return;
        }
        this.myIgnoringActionEvents = true;
        IDevice device2 = (IDevice)this.myDeviceCombo.getSelectedItem();
        Client selected = (Client)this.myProcessComboBox.getSelectedItem();
        Client toSelect = null;
        boolean update2 = true;
        this.myProcessComboBox.removeAllItems();
        if (device2 != null) {
            boolean selectedClientDied;
            Client preferredClient;
            String preferred = this.getPreferredClient(device2.getName());
            if (preferred != null && (preferredClient = device2.getClient(preferred)) != null) {
                toSelect = preferredClient;
            }
            ArrayList clients = Lists.newArrayList((Object[])device2.getClients());
            boolean bl = selectedClientDied = selected != null && selected.getDevice() == device2 && !clients.contains(selected);
            if (selectedClientDied) {
                if (toSelect == null) {
                    toSelect = selected;
                }
                clients.add(selected);
            }
            clients.sort(new ClientCellRenderer.ClientComparator());
            for (Client client2 : clients) {
                if (StringUtil.isEmpty((String)ClientCellRenderer.getClientName(client2.getClientData()))) continue;
                this.myProcessComboBox.addItem(client2);
            }
            this.myProcessComboBox.setSelectedItem(toSelect);
            update2 = toSelect != selected;
        }
        this.myIgnoringActionEvents = false;
        if (update2) {
            this.myDeviceContext.fireClientSelected((Client)this.myProcessComboBox.getSelectedItem());
        }
    }

    @VisibleForTesting
    void setIgnoringActionEvents(boolean ignoringActionEvents) {
        this.myIgnoringActionEvents = ignoringActionEvents;
    }

    @Nullable
    private String getPreferredClient(@NotNull String device2) {
        String client2 = this.myPreferredClients.get(device2);
        return client2 == null ? (String)this.myCandidateClientName.getValue() : client2;
    }

    @VisibleForTesting
    void putPreferredClient(@NotNull String device2, @NotNull String client2) {
        this.myPreferredClients.put(device2, client2);
    }

    private static final class MyProcessComboBox
    extends ComboBox<Client> {
        private MyProcessComboBox() {
            this.setRenderer((ListCellRenderer)((Object)new ClientCellRenderer("No debuggable processes")));
        }
    }

    private final class MyFutureCallback
    implements FutureCallback<DeviceNameProperties> {
        private MyFutureCallback() {
        }

        public void onSuccess(@Nullable DeviceNameProperties properties2) {
            DevicePanel.this.updateDeviceCombo();
        }

        public void onFailure(@NotNull Throwable throwable) {
            LOG.warn("Error retrieving device name properties", throwable);
        }
    }

    private static final class MyDeviceComboBox
    extends DeviceComboBox {
        private DeviceNamePropertiesFetcher myFetcher;
        private DeviceRenderer.DeviceComboBoxRenderer myRenderer;

        private MyDeviceComboBox() {
        }

        @Override
        void initRenderer(@NotNull FutureCallback<DeviceNameProperties> callback) {
            this.myFetcher = new DeviceNamePropertiesFetcher(this, callback);
            this.myRenderer = new DeviceRenderer.DeviceComboBoxRenderer("No connected devices", false, this.myFetcher);
            this.setRenderer((ListCellRenderer)((Object)this.myRenderer));
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myFetcher);
        }

        @Override
        void setSerialNumbersVisible(boolean visible) {
            this.myRenderer.setShowSerial(visible);
        }
    }

    static abstract class DeviceComboBox
    extends ComboBox<IDevice>
    implements Disposable {
        DeviceComboBox() {
            AccessibleContextUtil.setName((Component)((Object)this), (String)"Devices");
        }

        abstract void initRenderer(@NotNull FutureCallback<DeviceNameProperties> var1);

        abstract void setSerialNumbersVisible(boolean var1);
    }
}

