/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.utils.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClientCellRenderer
extends ColoredListCellRenderer<Client> {
    @NotNull
    private final String myEmptyText;

    public ClientCellRenderer() {
        this("");
    }

    public ClientCellRenderer(@NotNull String emptyText2) {
        this.myEmptyText = emptyText2;
    }

    @VisibleForTesting
    static Pair<String, String> splitApplicationName(String name) {
        int index2 = name.lastIndexOf(46);
        return Pair.of((Object)name.substring(0, index2 + 1), (Object)name.substring(index2 + 1));
    }

    private static void renderClient(@NotNull Client c, @NotNull ColoredTextContainer container) {
        ClientData cd = c.getClientData();
        String name = ClientCellRenderer.getClientName(cd);
        if (name == null) {
            return;
        }
        Pair<String, String> app = ClientCellRenderer.splitApplicationName(name);
        container.append((String)app.getFirst(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        container.append((String)app.getSecond(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (cd.isValidUserId() && cd.getUserId() != 0) {
            container.append(String.format(Locale.US, " (user %1$d)", cd.getUserId()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        container.append(String.format(Locale.US, " (%1$d)", cd.getPid()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        if (!c.isValid()) {
            container.append(" [DEAD]", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
    }

    @Nullable
    static String getClientName(@NotNull ClientData cd) {
        return cd.getClientDescription();
    }

    protected void customizeCellRenderer(@NotNull JList<? extends Client> list2, Client value2, int index2, boolean selected, boolean focused) {
        if (value2 == null) {
            this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
            return;
        }
        ClientCellRenderer.renderClient(value2, (ColoredTextContainer)this);
    }

    public static class ClientComparator
    implements Comparator<Client> {
        @Override
        public int compare(Client a, Client b) {
            ClientData ad = a.getClientData();
            ClientData bd = b.getClientData();
            String as = ad.getClientDescription() != null ? ad.getClientDescription() : String.valueOf(ad.getPid());
            String bs = bd.getClientDescription() != null ? bd.getClientDescription() : String.valueOf(bd.getPid());
            return as.compareTo(bs);
        }
    }
}

