/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.analytics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.databinding.analytics.api.DataBindingTracker;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.project.LayoutBindingEnabledFacetsProvider;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DataBindingEvent;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/databinding/analytics/LayoutBindingTracker;", "Lcom/android/tools/idea/databinding/analytics/api/DataBindingTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "enabledFacetsProvider", "Lcom/android/tools/idea/databinding/project/LayoutBindingEnabledFacetsProvider;", "createStudioEventBuilder", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "kotlin.jvm.PlatformType", "isDataBindingEnabled", "", "isViewBindingEnabled", "runInBackground", "", "runnable", "Ljava/lang/Runnable;", "trackDataBindingCompletion", "eventType", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$EventType;", "context", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$DataBindingContext;", "trackPolledMetaData", "trackPollingEvent", "dataBindingMetadata", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$DataBindingPollMetadata;", "viewBindingMetaData", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$ViewBindingPollMetadata;", "trackUserEvent", "TrackPollingMetadataTask", "intellij.android.databinding"})
public class LayoutBindingTracker
implements DataBindingTracker {
    @NotNull
    private final Project project;
    @NotNull
    private final LayoutBindingEnabledFacetsProvider enabledFacetsProvider;

    public LayoutBindingTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.enabledFacetsProvider = LayoutBindingEnabledFacetsProvider.Companion.getInstance(this.project);
    }

    @Override
    public void trackPolledMetaData() {
        if (!((Collection)this.enabledFacetsProvider.getAllBindingEnabledFacets()).isEmpty()) {
            this.runInBackground(new TrackPollingMetadataTask(this.project));
        }
    }

    @Override
    public void trackDataBindingCompletion(@NotNull DataBindingEvent.EventType eventType, @NotNull DataBindingEvent.DataBindingContext context2) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.isDataBindingEnabled()) {
            this.trackUserEvent(eventType, context2);
        }
    }

    private final boolean isDataBindingEnabled() {
        return !((Collection)this.enabledFacetsProvider.getDataBindingEnabledFacets()).isEmpty();
    }

    private final boolean isViewBindingEnabled() {
        return !((Collection)this.enabledFacetsProvider.getViewBindingEnabledFacets()).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void trackUserEvent(DataBindingEvent.EventType eventType, DataBindingEvent.DataBindingContext context2) {
        void $this$trackUserEvent_u24lambda_u2d1_u24lambda_u2d0;
        DataBindingEvent.Builder builder2;
        AndroidStudioEvent.Builder builder3;
        AndroidStudioEvent.Builder $this$trackUserEvent_u24lambda_u2d1 = builder3 = this.createStudioEventBuilder();
        boolean bl = false;
        DataBindingEvent.Builder builder4 = builder2 = DataBindingEvent.newBuilder();
        AndroidStudioEvent.Builder builder5 = $this$trackUserEvent_u24lambda_u2d1;
        boolean bl2 = false;
        $this$trackUserEvent_u24lambda_u2d1_u24lambda_u2d0.setType(eventType);
        $this$trackUserEvent_u24lambda_u2d1_u24lambda_u2d0.setContext(context2);
        builder5.setDataBindingEvent(builder2.build());
        AndroidStudioEvent.Builder studioEventBuilder = builder3;
        Intrinsics.checkNotNullExpressionValue((Object)studioEventBuilder, (String)"studioEventBuilder");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(studioEventBuilder, this.project));
    }

    /*
     * WARNING - void declaration
     */
    private final void trackPollingEvent(DataBindingEvent.EventType eventType, DataBindingEvent.DataBindingPollMetadata dataBindingMetadata, DataBindingEvent.ViewBindingPollMetadata viewBindingMetaData) {
        void $this$trackPollingEvent_u24lambda_u2d3_u24lambda_u2d2;
        DataBindingEvent.Builder builder2;
        AndroidStudioEvent.Builder builder3;
        AndroidStudioEvent.Builder $this$trackPollingEvent_u24lambda_u2d3 = builder3 = this.createStudioEventBuilder();
        boolean bl = false;
        DataBindingEvent.Builder builder4 = builder2 = DataBindingEvent.newBuilder();
        AndroidStudioEvent.Builder builder5 = $this$trackPollingEvent_u24lambda_u2d3;
        boolean bl2 = false;
        $this$trackPollingEvent_u24lambda_u2d3_u24lambda_u2d2.setType(eventType);
        $this$trackPollingEvent_u24lambda_u2d3_u24lambda_u2d2.setPollMetadata(dataBindingMetadata);
        $this$trackPollingEvent_u24lambda_u2d3_u24lambda_u2d2.setViewBindingMetadata(viewBindingMetaData);
        builder5.setDataBindingEvent(builder2.build());
        AndroidStudioEvent.Builder studioEventBuilder = builder3;
        Intrinsics.checkNotNullExpressionValue((Object)studioEventBuilder, (String)"studioEventBuilder");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(studioEventBuilder, this.project));
    }

    protected void runInBackground(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        ApplicationManager.getApplication().executeOnPooledThread(runnable2);
    }

    private final AndroidStudioEvent.Builder createStudioEventBuilder() {
        return AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DATA_BINDING);
    }

    public static final /* synthetic */ void access$trackPollingEvent(LayoutBindingTracker $this, DataBindingEvent.EventType eventType, DataBindingEvent.DataBindingPollMetadata dataBindingMetadata, DataBindingEvent.ViewBindingPollMetadata viewBindingMetaData) {
        $this.trackPollingEvent(eventType, dataBindingMetadata, viewBindingMetaData);
    }

    public static final /* synthetic */ boolean access$isDataBindingEnabled(LayoutBindingTracker $this) {
        return $this.isDataBindingEnabled();
    }

    public static final /* synthetic */ boolean access$isViewBindingEnabled(LayoutBindingTracker $this) {
        return $this.isViewBindingEnabled();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/databinding/analytics/LayoutBindingTracker$TrackPollingMetadataTask;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/idea/databinding/analytics/LayoutBindingTracker;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "run", "", "intellij.android.databinding"})
    private final class TrackPollingMetadataTask
    implements Runnable {
        @NotNull
        private final Project project;

        public TrackPollingMetadataTask(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Override
        public void run() {
            DumbService.getInstance((Project)this.project).runReadActionInSmartMode(new Runnable(this, LayoutBindingTracker.this){
                final /* synthetic */ TrackPollingMetadataTask this$0;
                final /* synthetic */ LayoutBindingTracker this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    void $this$run_u24lambda_u2d7;
                    int n;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Object[] $this$count$iv;
                    void $this$run_u24lambda_u2d6;
                    Object element$iv22;
                    void $this$forEach$iv;
                    VirtualFile it;
                    void $this$mapNotNullTo$iv$iv2;
                    Iterable $this$mapNotNull$iv2;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    int dataBindingLayoutCount = 0;
                    int viewBindingLayoutCount = 0;
                    int importCount = 0;
                    int variableCount = 0;
                    Collection collection2 = FileTypeIndex.getFiles((FileType)((FileType)XmlFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.this$0.getProject()));
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getFiles(XmlFileType.INS\u2026pe.projectScope(project))");
                    Iterable iterable = collection2;
                    boolean $i$f$filter232 = false;
                    void var7_10 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        VirtualFile it2 = (VirtualFile)element$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                        if (!BindingXmlIndex.Companion.acceptsFile(it2)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    TrackPollingMetadataTask $i$f$filter232 = this.this$0;
                    boolean $i$f$mapNotNull232 = false;
                    destination$iv$iv = $this$mapNotNull$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                    boolean $i$f$forEach = false;
                    Iterator<T> bl = $this$forEach$iv$iv$iv.iterator();
                    while (bl.hasNext()) {
                        BindingXmlData it$iv$iv;
                        T element$iv$iv$iv;
                        T t = element$iv$iv$iv = bl.next();
                        boolean bl2 = false;
                        it = (VirtualFile)t;
                        boolean bl3 = false;
                        Project project = $i$f$filter232.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (BindingXmlIndex.Companion.getDataForFile(project, it) == null) continue;
                        boolean bl4 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv2 = (List)destination$iv$iv2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv22 : $this$forEach$iv) {
                        BindingXmlData layoutInfo = (BindingXmlData)element$iv22;
                        boolean bl5 = false;
                        if (layoutInfo.getLayoutType() == BindingLayoutType.DATA_BINDING_LAYOUT) {
                            ++dataBindingLayoutCount;
                            importCount += layoutInfo.getImports().size();
                            variableCount += layoutInfo.getVariables().size();
                            continue;
                        }
                        if (layoutInfo.getLayoutType() != BindingLayoutType.PLAIN_LAYOUT || layoutInfo.getViewBindingIgnore()) continue;
                        ++viewBindingLayoutCount;
                    }
                    iterable = DataBindingEvent.DataBindingPollMetadata.newBuilder();
                    LayoutBindingTracker layoutBindingTracker = this.this$1;
                    Object $i$f$mapNotNull232 = this.this$0;
                    element$iv22 = iterable;
                    DataBindingEvent.EventType eventType = DataBindingEvent.EventType.DATA_BINDING_BUILD_EVENT;
                    LayoutBindingTracker layoutBindingTracker2 = this.this$1;
                    boolean bl6 = false;
                    $this$run_u24lambda_u2d6.setDataBindingEnabled(LayoutBindingTracker.access$isDataBindingEnabled(layoutBindingTracker));
                    $this$run_u24lambda_u2d6.setLayoutXmlCount(dataBindingLayoutCount);
                    $this$run_u24lambda_u2d6.setImportCount(importCount);
                    $this$run_u24lambda_u2d6.setVariableCount(variableCount);
                    Module[] moduleArray = ModuleManager.getInstance((Project)((TrackPollingMetadataTask)$i$f$mapNotNull232).getProject()).getModules();
                    Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getInstance(project).modules");
                    Object[] bl5 = moduleArray;
                    void var11_21 = $this$run_u24lambda_u2d6;
                    boolean $i$f$count = false;
                    int count$iv232 = 0;
                    for (void var16_37 : $this$count$iv) {
                        it = (Module)var16_37;
                        boolean bl7 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!(ModuleExtensionsKt.getAndroidFacet((Module)it) != null)) continue;
                        ++count$iv232;
                    }
                    int n2 = count$iv232;
                    var11_21.setModuleCount(n2);
                    Module[] moduleArray2 = ModuleManager.getInstance((Project)((TrackPollingMetadataTask)$i$f$mapNotNull232).getProject()).getModules();
                    Intrinsics.checkNotNullExpressionValue((Object)moduleArray2, (String)"getInstance(project).modules");
                    $this$count$iv = moduleArray2;
                    var11_21 = $this$run_u24lambda_u2d6;
                    boolean $i$f$mapNotNull = false;
                    void count$iv232 = $this$mapNotNull$iv;
                    Collection destination$iv$iv3 = new ArrayList<E>();
                    boolean bl3 = false;
                    void var16_38 = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach3 = false;
                    int n3 = ((void)var16_38).length;
                    for (int i = 0; i < n3; ++i) {
                        AndroidFacet it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = var16_38[i];
                        boolean bl8 = false;
                        Module it3 = (Module)element$iv$iv;
                        boolean bl9 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
                        if (ModuleExtensionsKt.getAndroidFacet((Module)it3) == null) continue;
                        boolean bl10 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv3;
                    $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (T t : $this$count$iv) {
                            AndroidFacet androidFacet = (AndroidFacet)t;
                            boolean bl11 = false;
                            if (!DataBindingUtil.isDataBindingEnabled(androidFacet) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    n2 = n;
                    var11_21.setDataBindingEnabledModuleCount(n2);
                    Unit unit = Unit.INSTANCE;
                    DataBindingEvent.DataBindingPollMetadata dataBindingPollMetadata = iterable.build();
                    iterable = DataBindingEvent.ViewBindingPollMetadata.newBuilder();
                    layoutBindingTracker = this.this$1;
                    $i$f$mapNotNull232 = iterable;
                    unit = dataBindingPollMetadata;
                    boolean bl12 = false;
                    $this$run_u24lambda_u2d7.setViewBindingEnabled(LayoutBindingTracker.access$isViewBindingEnabled(layoutBindingTracker));
                    $this$run_u24lambda_u2d7.setLayoutXmlCount(viewBindingLayoutCount);
                    Unit unit2 = Unit.INSTANCE;
                    LayoutBindingTracker.access$trackPollingEvent(layoutBindingTracker2, eventType, (DataBindingEvent.DataBindingPollMetadata)unit, iterable.build());
                }
            });
        }
    }
}

