/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.ddmlib.AdbDevice;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.connection.assistant.actions.ButtonMessage;
import com.android.tools.idea.connection.assistant.actions.ConnectionAssistantSection;
import com.android.tools.idea.connection.assistant.actions.CustomSuccessState;
import com.android.tools.idea.connection.assistant.actions.DeviceCrossReference;
import com.android.tools.idea.connection.assistant.actions.DeviceCrossReferenceKt;
import com.android.tools.idea.connection.assistant.actions.DeviceSummary;
import com.android.tools.idea.connection.assistant.actions.DeviceSummaryKt;
import com.android.tools.idea.connection.assistant.actions.ListUsbDevicesAction;
import com.android.tools.idea.connection.assistant.actions.ListUsbDevicesActionStateManager;
import com.android.tools.idea.rendering.HtmlBuilderHelper;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.usb.Platform;
import com.android.tools.usb.UsbDevice;
import com.android.tools.usb.UsbDeviceCollector;
import com.android.tools.usb.UsbDeviceCollectorImpl;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ConnectionAssistantEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.EdtInvocationManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0002J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J$\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016JN\u0010#\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u00122\u0018\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u000f0\u00052\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u0007J\u0006\u0010%\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000RJ\u0010\b\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00060\u0006 \u000b*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u000b*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00060\u0006\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00060\u000f0\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "Lcom/intellij/openapi/Disposable;", "()V", "deviceFunction", "Lkotlin/Function0;", "", "Lcom/android/ddmlib/IDevice;", "myDevicesFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/connection/assistant/actions/DeviceCrossReference;", "kotlin.jvm.PlatformType", "myProject", "Lcom/intellij/openapi/project/Project;", "rawDeviceFunction", "Ljava/util/concurrent/CompletionStage;", "Lcom/android/ddmlib/AdbDevice;", "usbDeviceCollector", "Lcom/android/tools/usb/UsbDeviceCollector;", "dispose", "", "generateMessage", "Lcom/android/tools/idea/connection/assistant/actions/ButtonMessage;", "getAllDevices", "getDevices", "getId", "", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "project", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "message", "init", "deviceCollector", "refresh", "Companion", "connection-assistant"})
public final class ListUsbDevicesActionStateManager
extends AssistActionStateManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private UsbDeviceCollector usbDeviceCollector;
    @Nullable
    private Project myProject;
    private CompletableFuture<List<DeviceCrossReference>> myDevicesFuture = CompletableFuture.completedFuture(CollectionsKt.emptyList());
    private Function0<? extends CompletionStage<List<AdbDevice>>> rawDeviceFunction;
    private Function0<? extends List<? extends IDevice>> deviceFunction;
    private static ListUsbDevicesActionStateManager myInstance;

    @Override
    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        this.init(project, actionData, (UsbDeviceCollector)new UsbDeviceCollectorImpl(), (Function0<? extends CompletionStage<List<AdbDevice>>>)((Function0)init.1.INSTANCE), (Function0<? extends List<? extends IDevice>>)((Function0)init.2.INSTANCE));
    }

    @VisibleForTesting
    public final void init(@NotNull Project project, @NotNull ActionData actionData, @NotNull UsbDeviceCollector deviceCollector, @NotNull Function0<? extends CompletionStage<List<AdbDevice>>> rawDeviceFunction, @NotNull Function0<? extends List<? extends IDevice>> deviceFunction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        Intrinsics.checkNotNullParameter((Object)deviceCollector, (String)"deviceCollector");
        Intrinsics.checkNotNullParameter(rawDeviceFunction, (String)"rawDeviceFunction");
        Intrinsics.checkNotNullParameter(deviceFunction, (String)"deviceFunction");
        this.myProject = project;
        this.usbDeviceCollector = deviceCollector;
        myInstance = this;
        this.rawDeviceFunction = rawDeviceFunction;
        this.deviceFunction = deviceFunction;
        this.refresh();
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
    }

    private final CompletionStage<List<DeviceCrossReference>> getDevices() {
        CompletableFuture<List<DeviceCrossReference>> completableFuture = this.myDevicesFuture;
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"myDevicesFuture");
        return completableFuture;
    }

    public final void refresh() {
        UsbDeviceCollector usbDeviceCollector = this.usbDeviceCollector;
        if (usbDeviceCollector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
            usbDeviceCollector = null;
        }
        CompletableFuture completableFuture = usbDeviceCollector.listUsbDevices();
        Function0<? extends CompletionStage<List<AdbDevice>>> function0 = this.rawDeviceFunction;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rawDeviceFunction");
            function0 = null;
        }
        this.myDevicesFuture = ((CompletableFuture)completableFuture.thenCombine((CompletionStage)function0.invoke(), new BiFunction(this){
            final /* synthetic */ ListUsbDevicesActionStateManager this$0;
            {
                this.this$0 = $receiver;
            }

            public final List<DeviceCrossReference> apply(List<UsbDevice> a, List<AdbDevice> b) {
                Intrinsics.checkNotNullExpressionValue(a, (String)"a");
                Collection collection2 = a;
                Function0 function0 = ListUsbDevicesActionStateManager.access$getDeviceFunction$p(this.this$0);
                if (function0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"deviceFunction");
                    function0 = null;
                }
                Collection collection3 = (Collection)function0.invoke();
                Intrinsics.checkNotNullExpressionValue(b, (String)"b");
                return DeviceCrossReferenceKt.crossReference(collection2, collection3, (Collection<AdbDevice>)b);
            }
        })).exceptionally((Function)refresh.2.INSTANCE);
        this.myDevicesFuture.thenAccept(new Consumer(this){
            final /* synthetic */ ListUsbDevicesActionStateManager this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(List<DeviceCrossReference> it) {
                EdtInvocationManager.getInstance().invokeLater(new Runnable(this.this$0, it){
                    final /* synthetic */ ListUsbDevicesActionStateManager this$0;
                    final /* synthetic */ List<DeviceCrossReference> $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                    }

                    public final void run() {
                        Project project = ListUsbDevicesActionStateManager.access$getMyProject$p(this.this$0);
                        Intrinsics.checkNotNull((Object)project);
                        if (!project.isDisposed()) {
                            AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.CONNECTION_ASSISTANT_EVENT).setConnectionAssistantEvent(ConnectionAssistantEvent.newBuilder().setType(ConnectionAssistantEvent.ConnectionAssistantEventType.USB_DEVICES_DETECTED).setUsbDevicesDetected(this.$it.size()));
                            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder()\n           \u2026t.size)\n                )");
                            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(builder2, ListUsbDevicesActionStateManager.access$getMyProject$p(this.this$0)));
                            Project project2 = ListUsbDevicesActionStateManager.access$getMyProject$p(this.this$0);
                            Intrinsics.checkNotNull((Object)project2);
                            this.this$0.refreshDependencyState(project2);
                        }
                    }
                });
            }
        });
    }

    public void dispose() {
        this.myDevicesFuture.cancel(true);
        this.myProject = null;
    }

    @Override
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        if (!this.myDevicesFuture.isDone()) {
            return DefaultActionState.IN_PROGRESS;
        }
        return this.myDevicesFuture.get().isEmpty() ? (AssistActionState)DefaultActionState.ERROR_RETRY : (AssistActionState)CustomSuccessState.INSTANCE;
    }

    @Override
    @Nullable
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        ButtonMessage buttonMessage = this.generateMessage();
        String title = buttonMessage.component1();
        String body = buttonMessage.component2();
        return new StatefulButtonMessage(title, this.getState(project, actionData), body);
    }

    @Override
    @NotNull
    public String getId() {
        return ListUsbDevicesAction.Companion.getACTION_ID();
    }

    private final List<DeviceCrossReference> getAllDevices() {
        List<DeviceCrossReference> list2 = this.myDevicesFuture.get();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"myDevicesFuture.get()");
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final ButtonMessage generateMessage() {
        UsbDeviceCollector usbDeviceCollector;
        DeviceSummary device2;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        void $this$mapTo$iv$iv;
        if (!this.myDevicesFuture.isDone()) {
            return new ButtonMessage("Loading...", null, 2, null);
        }
        Iterable $this$map$iv = this.getAllDevices();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            DeviceCrossReference deviceCrossReference = (DeviceCrossReference)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(DeviceSummaryKt.summarize((DeviceCrossReference)((Object)it)));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List devices2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DeviceSummary it = (DeviceSummary)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getLabel());
                it = (DeviceSummary)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getLabel())));
            }
        });
        HtmlBuilder titleHtmlBuilder = new HtmlBuilder().openHtmlBody();
        if (!((Collection)devices2).isEmpty()) {
            titleHtmlBuilder.beginSpan("color: " + UIUtils.getCssColor(UIUtils.getSuccessColor())).add("Android Studio detected " + devices2.size() + " device(s).").endSpan();
        } else {
            titleHtmlBuilder.beginSpan("color: " + UIUtils.getCssColor(UIUtils.getFailureColor())).add(AndroidBundle.message("connection.assistant.usb.no_devices.title", new Object[0])).endSpan();
        }
        Iterable $this$filter$iv = devices2;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            DeviceSummary it = (DeviceSummary)element$iv$iv;
            boolean bl = false;
            if (!(it.getSection() == ConnectionAssistantSection.WORKING)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List workingDevices = (List)destination$iv$iv2;
        Iterable $this$filter$iv2 = devices2;
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            DeviceSummary it = (DeviceSummary)element$iv$iv;
            boolean bl = false;
            if (!(it.getSection() == ConnectionAssistantSection.POSSIBLE_PROBLEM)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List problemDevices = (List)destination$iv$iv3;
        Iterable $this$filter$iv3 = devices2;
        boolean $i$f$filter3 = false;
        destination$iv$iv3 = $this$filter$iv3;
        Object destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DeviceSummary it = (DeviceSummary)element$iv$iv;
            boolean bl = false;
            if (!(it.getSection() == ConnectionAssistantSection.OTHER_USB)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List usbDevices = (List)destination$iv$iv4;
        HtmlBuilder bodyHtmlBuilder = new HtmlBuilder().openHtmlBody();
        bodyHtmlBuilder.newline();
        if (!((Collection)workingDevices).isEmpty()) {
            bodyHtmlBuilder.addHeading("Found " + workingDevices.size() + " Android device(s) ready for debugging:", HtmlBuilderHelper.getHeaderFontColor());
            Iterable $this$forEach$iv = workingDevices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                device2 = (DeviceSummary)element$iv;
                boolean bl = false;
                String name = device2.getLabel();
                bodyHtmlBuilder.beginParagraph().add(name);
                bodyHtmlBuilder.newlineIfNecessary().endParagraph();
            }
            bodyHtmlBuilder.beginParagraph().endParagraph();
        }
        if (!((Collection)problemDevices).isEmpty()) {
            bodyHtmlBuilder.addHeading("Found " + problemDevices.size() + " Android device(s) with possible problems:", HtmlBuilderHelper.getHeaderFontColor());
            Iterable $this$forEach$iv = problemDevices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                device2 = (DeviceSummary)element$iv;
                boolean bl = false;
                String name = device2.getLabel();
                bodyHtmlBuilder.beginParagraph().add(name).endParagraph();
                if (device2.getErrorMessage() == null) continue;
                bodyHtmlBuilder.beginList().listItem().add(device2.getErrorMessage()).endList();
            }
            bodyHtmlBuilder.beginParagraph().endParagraph();
        }
        if (!((Collection)usbDevices).isEmpty()) {
            void $this$groupByTo$iv$iv;
            bodyHtmlBuilder.addHeading("Found " + usbDevices.size() + " USB device(s) not recognized as Android devices:", HtmlBuilderHelper.getHeaderFontColor());
            Iterable $this$groupBy$iv = usbDevices;
            boolean $i$f$groupBy = false;
            destination$iv$iv4 = $this$groupBy$iv;
            Map destination$iv$iv5 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                DeviceSummary usbDevice = (DeviceSummary)element$iv$iv;
                boolean bl = false;
                DeviceSummary key$iv$iv = usbDevice;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv5;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            destination$iv$iv5.forEach(new BiConsumer(bodyHtmlBuilder){
                final /* synthetic */ HtmlBuilder $bodyHtmlBuilder;
                {
                    this.$bodyHtmlBuilder = $bodyHtmlBuilder;
                }

                public final void accept(@NotNull DeviceSummary deviceSummary, @NotNull List<DeviceSummary> deviceList2) {
                    Intrinsics.checkNotNullParameter((Object)deviceSummary, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter(deviceList2, (String)"deviceList");
                    DeviceSummary device2 = (DeviceSummary)CollectionsKt.first(deviceList2);
                    String name = device2.getLabel();
                    this.$bodyHtmlBuilder.beginParagraph().add(name);
                    if (deviceList2.size() > 1) {
                        this.$bodyHtmlBuilder.addNbsp().addItalic("(" + deviceList2.size() + " devices)");
                    }
                    this.$bodyHtmlBuilder.newlineIfNecessary().endParagraph();
                }
            });
            bodyHtmlBuilder.beginParagraph().endParagraph();
        }
        if (devices2.isEmpty()) {
            bodyHtmlBuilder.beginParagraph().add(AndroidBundle.message("connection.assistant.usb.no_devices.body", new Object[0])).endParagraph().newlineIfNecessary();
        }
        if ((usbDeviceCollector = this.usbDeviceCollector) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usbDeviceCollector");
            usbDeviceCollector = null;
        }
        if (usbDeviceCollector.getPlatform() == Platform.Windows) {
            bodyHtmlBuilder.beginParagraph().addBold("Install device drivers.").add(" If you want to connect a device for testing, then you need to install the appropriate USB drivers. For more information, read the ").addLink("online documentation", "https://developer.android.com/studio/run/oem-usb.html").add(".").endParagraph();
        }
        String string = titleHtmlBuilder.closeHtmlBody().getHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"titleHtmlBuilder.closeHtmlBody().html");
        return new ButtonMessage(string, bodyHtmlBuilder.closeHtmlBody().getHtml());
    }

    public static final /* synthetic */ Function0 access$getDeviceFunction$p(ListUsbDevicesActionStateManager $this) {
        return $this.deviceFunction;
    }

    public static final /* synthetic */ Project access$getMyProject$p(ListUsbDevicesActionStateManager $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager$Companion;", "", "()V", "myInstance", "Lcom/android/tools/idea/connection/assistant/actions/ListUsbDevicesActionStateManager;", "getInstance", "connection-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ListUsbDevicesActionStateManager getInstance() {
            ListUsbDevicesActionStateManager listUsbDevicesActionStateManager = myInstance;
            if (listUsbDevicesActionStateManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myInstance");
                listUsbDevicesActionStateManager = null;
            }
            return listUsbDevicesActionStateManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

